set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7732277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.332029,
      1.390719,
      3.740464,
      NULL,
      5,
      0,
      0,
      3.344991,
      '114',
      '40321443',
      NULL,
      46,
      '4320304',
      NULL,
      NULL,
      NULL,
      2,
      '2201',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      93.584871,
      63.918349,
      NULL,
      3,
      0,
      ' 0-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-26-2002',
      '10-26-1993',
      NULL,
      3.914231,
      0,
      NULL,
      1,
      1.822560,
      1.961004,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.420908,
      1,
      NULL,
      0,
      0,
      1,
      0.079472,
      NULL,
      1,
      1.729389,
      0.040042,
      1,
      4.438896,
      NULL,
      1,
      NULL,
      0,
      NULL,
      9,
      1,
      1.600249,
      1.716834,
      1,
      3,
      1.222179,
      1,
      5.179680,
      0,
      0,
      6.521922,
      2,
      0.878517,
      0.163698,
      2,
      3,
      1.282268,
      NULL,
      NULL,
      0.630759,
      NULL,
      NULL,
      5,
      4,
      2.889851,
      3.785267,
      0,
      1,
      NULL,
      0.076933,
      NULL,
      NULL,
      0,
      1,
      3.151933,
      1,
      0,
      3.370067,
      0,
      1,
      2.948349,
      0,
      1.984421,
      5.831376,
      1,
      1.739515,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.125436,
      NULL,
      NULL,
      NULL,
      3.092475,
      2.191468,
      0.134761,
      NULL,
      NULL,
      0,
      NULL,
      1.650863,
      NULL,
      0.895045,
      NULL,
      1,
      0,
      0.472686,
      NULL,
      0.204171,
      4.494389,
      NULL,
      4,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      3.205399,
      4,
      1,
      4.278757,
      NULL,
      NULL,
      7,
      10,
      6,
      3,
      7,
      7,
      0.416496,
      NULL,
      5.334431,
      NULL,
      ' 3-14-2003',
      360.891283,
      ' 3- 2-1993',
      827,
      1.230503,
      1.475817,
      1,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988059,
      1.613796,
      NULL,
      0,
      0.296633,
      2.576295,
      1.832476,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.776619,
      2.018286,
      1,
      1,
      NULL,
      2.296767,
      1.742497,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      NULL,
      NULL,
      5.672440,
      NULL,
      2,
      1,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.896213,
      1.345034,
      1,
      0.852345,
      0,
      3,
      17.845373,
      0,
      1.667193,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      NULL,
      0.274547,
      NULL,
      0.876660,
      NULL,
      3,
      1.361737,
      0,
      2.461954,
      0.424085,
      NULL,
      1,
      1,
      1.284957,
      0.526570,
      0.042338,
      0,
      1,
      1.282135,
      0.145370,
      0,
      0,
      1.900709,
      NULL,
      0,
      0.073708,
      3,
      NULL,
      1.489890,
      NULL,
      7,
      8.584098,
      0,
      5,
      0,
      NULL,
      5.795511,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      45,
      NULL,
      0.785138,
      NULL,
      3.222171,
      NULL,
      3.224968,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      '0123',
      '',
      '',
      0.482968,
      12.470922,
      158,
      NULL,
      1.338648,
      41,
      7,
      NULL,
      1,
      0.330316,
      1.170493,
      NULL,
      1,
      NULL,
      NULL,
      1.997579,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      3.240828,
      1,
      NULL,
      1.863150,
      1.359847,
      NULL,
      3,
      NULL,
      0,
      1.337857,
      1.446266,
      1,
      0.004222,
      0,
      1.236644,
      1.409453,
      NULL,
      NULL,
      6,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.837207,
      0,
      2,
      NULL,
      NULL,
      1.943774,
      0.690880,
      0,
      2.966054,
      0.180933,
      0.516382,
      NULL,
      2,
      NULL,
      0.928459,
      NULL,
      0.326375,
      NULL,
      0.502388,
      3.359113,
      0.397363,
      0,
      2,
      3.849937,
      NULL,
      0.609196,
      NULL,
      NULL,
      1.822837,
      NULL,
      NULL,
      1,
      1,
      0.882631,
      2.474579,
      1.067659,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674851,
      NULL,
      NULL,
      NULL,
      2.799572,
      0.758377,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.649412,
      NULL,
      NULL,
      0,
      1.563448,
      1.615071,
      3.747189,
      NULL,
      1.049719,
      3,
      0.150888,
      0.712030,
      4,
      1.318076,
      NULL,
      0,
      NULL,
      NULL,
      1.277869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.861371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790729,
      NULL,
      NULL,
      3.288025,
      0,
      NULL,
      NULL,
      0,
      0.865357,
      NULL,
      NULL,
      2.207770,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.977153,
      3.824585,
      1,
      NULL,
      0.694067,
      1.468923,
      1,
      2,
      2,
      0.668993,
      4,
      2,
      3,
      3.061266,
      NULL,
      3.603489,
      1,
      2.304201,
      NULL,
      2.222318,
      1,
      3,
      0.536705,
      NULL,
      5.249204,
      4.824649,
      NULL,
      1,
      4.584712,
      0.250435,
      3,
      7.746600,
      NULL,
      1.421232,
      1,
      0.077750,
      NULL,
      2,
      NULL,
      NULL,
      0.892155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.308760,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.246248,
      NULL,
      NULL,
      2.159118,
      NULL,
      NULL,
      2.734047,
      NULL,
      NULL,
      7.400049,
      NULL,
      NULL,
      0,
      0.661707,
      0.378252,
      1,
      1,
      1.284717,
      0.498632,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.302579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.283745,
      NULL,
      NULL,
      NULL,
      0.576667,
      NULL,
      NULL,
      NULL,
      1.560576,
      NULL,
      NULL,
      NULL,
      1.753842,
      NULL,
      NULL,
      NULL,
      1.120985,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      1.791024,
      1,
      69.355963,
      31.785624,
      NULL,
      4.575594,
      0.121320,
      0.681240,
      NULL,
      NULL,
      NULL,
      NULL,
      7.759868,
      0.222287,
      NULL,
      NULL,
      0.676779,
      NULL,
      NULL,
      1,
      NULL,
      0,
      81.883111,
      NULL,
      0.631505,
      1,
      0.466143,
      NULL,
      0.288136,
      1,
      3.745568,
      1,
      0,
      0,
      1.519810,
      1.522402,
      1.526288,
      1.488263,
      NULL,
      0.928905,
      1,
      3.133767,
      NULL,
      0.348207,
      1,
      3.252926,
      NULL,
      NULL,
      0.424658,
      2.853065,
      NULL,
      3,
      0.857602,
      50,
      0.924957,
      1.423846,
      7.399334,
      12,
      2.100325,
      2.009120,
      8,
      NULL,
      0,
      1.602704,
      0.381479,
      1.553480,
      NULL,
      0.462463,
      0.493032,
      0,
      1,
      1,
      NULL,
      0,
      1.397529,
      NULL,
      0,
      1.354430,
      0.164338,
      1,
      0,
      1.481770,
      1.215661,
      1.523044,
      0,
      1,
      0,
      0.379522,
      1,
      1,
      0.689138,
      1.988192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787215,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368607,
      NULL,
      NULL,
      0,
      NULL,
      1.545366,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.502679,
      1.764264,
      1,
      NULL,
      3.467594,
      NULL,
      2.563509,
      NULL,
      356,
      NULL,
      0.049042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969466,
      1,
      NULL,
      NULL,
      NULL,
      1.247049,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.244353,
      NULL,
      1.724744,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094955,
      2.277999,
      0.881769,
      0,
      1,
      0,
      NULL,
      NULL,
      1.630159,
      1,
      NULL,
      1.631236,
      0.229839,
      0.013086,
      1.352205,
      NULL,
      6.005436,
      4.355133,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.770243,
      NULL,
      1,
      0.482859,
      NULL,
      0.319932,
      1,
      10.253347,
      2.222369,
      3.734352,
      1,
      1.557064,
      1.604167,
      NULL,
      1.766402,
      NULL,
      NULL,
      1.415675,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.688937,
      0.466917,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.203920,
      0,
      NULL,
      NULL,
      1.448845,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.007095,
      NULL,
      0.676924,
      NULL,
      2.601594,
      9,
      6.335429,
      1.190652,
      NULL,
      NULL,
      112.221428,
      95.762022,
      4.902247,
      NULL,
      3.981761,
      '24301',
      '3400',
      '11221',
      1,
      '',
      '',
      '',
      0,
      '31221',
      NULL,
      '2102');
commit;
end;
/


