set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9850425';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.464188,
      0,
      1.536862,
      0.169697,
      5.937714,
      1,
      2.454640,
      1,
      '412',
      '21103011',
      63,
      10,
      '2134214',
      0.458278,
      1,
      3,
      NULL,
      NULL,
      2,
      0.355709,
      NULL,
      NULL,
      ' 4-24-1976',
      72,
      242.554647,
      NULL,
      3.559713,
      2.068091,
      ' 2-12-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      4.860591,
      NULL,
      NULL,
      ' 5- 9-1984',
      1,
      0,
      1.553521,
      NULL,
      0.993958,
      1.563874,
      0.013980,
      0.272394,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      3.492122,
      1,
      NULL,
      1,
      1.667710,
      NULL,
      1.126627,
      NULL,
      1,
      0.938505,
      2.128500,
      1.738698,
      2,
      3.120214,
      7,
      0.818761,
      0,
      2.086870,
      2.969550,
      0,
      1,
      3.024343,
      0.129839,
      4.474278,
      5.585035,
      3,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.543799,
      0.619238,
      0.897476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772677,
      1.620126,
      1,
      1.642364,
      3.469049,
      4,
      1,
      1,
      1,
      NULL,
      0.584811,
      NULL,
      0,
      2.088353,
      0,
      1,
      1.371333,
      1,
      0.638500,
      NULL,
      1,
      1.162414,
      2.696981,
      1.757091,
      3.942200,
      0,
      NULL,
      4.299824,
      1.474844,
      1,
      0.582278,
      NULL,
      NULL,
      NULL,
      1.801695,
      NULL,
      4.408362,
      7,
      0.923927,
      NULL,
      3,
      6,
      3.655683,
      5.503901,
      0.158812,
      3,
      0,
      NULL,
      ' 4- 8-1999',
      218.677956,
      '10-21-1992',
      NULL,
      1.092198,
      0.255228,
      1.933452,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.328210,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.189315,
      NULL,
      2.933430,
      0,
      2.299314,
      2,
      2,
      0.492164,
      1.036221,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753784,
      0.848145,
      4.570244,
      NULL,
      NULL,
      5.012911,
      0,
      NULL,
      NULL,
      NULL,
      1.545404,
      2.035008,
      1.661728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.405634,
      1,
      0,
      1,
      NULL,
      8,
      0,
      1.875610,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.087855,
      2.513078,
      1,
      1.468365,
      0.997642,
      2.759528,
      1,
      1.784661,
      2,
      2.208594,
      1,
      NULL,
      3.335748,
      2,
      0.485515,
      3.420817,
      1.653825,
      1.811977,
      0.698363,
      0,
      1,
      0.896515,
      NULL,
      0,
      1,
      1.864911,
      NULL,
      NULL,
      1.800987,
      1,
      8.738066,
      8,
      0,
      4.292302,
      7.090829,
      0.379218,
      NULL,
      0,
      7.265351,
      1,
      2.386273,
      3,
      12.433005,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      3,
      '33224',
      '',
      '',
      0.691419,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.769945,
      34,
      21,
      44,
      1.553436,
      18.506901,
      1.288864,
      0,
      1.813434,
      NULL,
      NULL,
      1,
      0.048353,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.871444,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1.817662,
      3.026885,
      NULL,
      0,
      1,
      1.100341,
      3.206833,
      2,
      0,
      2.739809,
      3.377298,
      1.729254,
      1,
      1.744655,
      NULL,
      NULL,
      0.024388,
      1,
      NULL,
      1.000552,
      3.497308,
      0.949370,
      NULL,
      NULL,
      NULL,
      NULL,
      1.477313,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.763525,
      NULL,
      NULL,
      1.856776,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.020999,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.705623,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      1,
      2.047413,
      0.393312,
      1.517807,
      0,
      NULL,
      NULL,
      1,
      6.512419,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.929808,
      NULL,
      NULL,
      0.087776,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.707906,
      0,
      7,
      5,
      4,
      5,
      2,
      3,
      1.804462,
      NULL,
      NULL,
      0.482248,
      NULL,
      NULL,
      3,
      0,
      3.805237,
      2.669598,
      NULL,
      3,
      2.862086,
      NULL,
      0,
      NULL,
      3.771305,
      0.482295,
      2.552000,
      3,
      0.815451,
      NULL,
      3.488001,
      2.103298,
      3,
      0,
      2.826491,
      0,
      4,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.666053,
      0.274375,
      NULL,
      1,
      0,
      1,
      0.372647,
      1,
      NULL,
      NULL,
      1.437368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.139420,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.307649,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571507,
      1,
      0,
      0.146507,
      NULL,
      1.714994,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3.875079,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653322,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.879597,
      NULL,
      NULL,
      NULL,
      0.159206,
      NULL,
      NULL,
      NULL,
      3.606097,
      NULL,
      NULL,
      NULL,
      0.776178,
      NULL,
      NULL,
      NULL,
      8.988780,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.940962,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      1.951703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184293,
      308.631414,
      2,
      0.389410,
      1.436533,
      0.834349,
      0,
      1,
      0,
      0.518948,
      0,
      1,
      NULL,
      1,
      1,
      1.874083,
      NULL,
      1.243277,
      NULL,
      1,
      1.522002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738921,
      NULL,
      1.794718,
      NULL,
      3.427103,
      1,
      1.607008,
      3.278990,
      NULL,
      3,
      NULL,
      0.457788,
      NULL,
      3,
      NULL,
      0,
      2.715198,
      NULL,
      1,
      0.896123,
      NULL,
      1,
      1.801065,
      NULL,
      1,
      0.718529,
      NULL,
      1,
      3.440151,
      NULL,
      1,
      2.778312,
      NULL,
      0.444122,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.549181,
      0,
      NULL,
      NULL,
      0,
      NULL,
      3.021558,
      0.275571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038333,
      NULL,
      0,
      NULL,
      3.415801,
      NULL,
      0.139757,
      0,
      NULL,
      NULL,
      41.566767,
      NULL,
      0,
      3,
      3.533237,
      NULL,
      '',
      '',
      1.911783,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


