set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7509559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '1121321',
      2,
      0,
      1,
      NULL,
      '1442',
      NULL,
      1,
      NULL,
      NULL,
      ' 5- 3-1996',
      0.531270,
      NULL,
      4.746446,
      0.618244,
      1.778694,
      ' 5-18-1976',
      39,
      0.710805,
      138,
      122,
      0,
      ' 9-14-2001',
      ' 1-29-2001',
      ' 2- 9-1978',
      3,
      1.963499,
      2,
      0,
      NULL,
      2.199801,
      1,
      1.111148,
      1.619764,
      299,
      3,
      14,
      NULL,
      11.621709,
      NULL,
      0,
      16.772194,
      2,
      1,
      5.642461,
      1,
      0.309335,
      NULL,
      0,
      NULL,
      1,
      1.346434,
      1,
      0.390831,
      1.318751,
      1.204396,
      1.538230,
      7,
      3,
      3,
      5,
      NULL,
      2,
      0.330525,
      NULL,
      NULL,
      0.551467,
      1.133602,
      1,
      0.732909,
      5.819707,
      1.766816,
      NULL,
      0,
      0,
      5,
      0.369917,
      1.138140,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.050040,
      0,
      1.258766,
      1,
      0.509855,
      1.456424,
      1.575700,
      1.804134,
      1,
      1.463869,
      0,
      0.486887,
      1,
      NULL,
      1.708987,
      1,
      NULL,
      NULL,
      0.776425,
      NULL,
      0,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      7,
      0.578261,
      1,
      1,
      0.933653,
      1,
      0,
      NULL,
      1.853493,
      1,
      NULL,
      1,
      1.058538,
      0.610496,
      NULL,
      1,
      0.397122,
      0,
      NULL,
      NULL,
      8.038572,
      2,
      NULL,
      1,
      0,
      6,
      5,
      6,
      NULL,
      0,
      6,
      0,
      1,
      NULL,
      2,
      1,
      6,
      NULL,
      3,
      6.171019,
      0.924443,
      7,
      7.403693,
      NULL,
      3,
      0,
      2,
      ' 9-26-2000',
      NULL,
      '11-10-1993',
      21,
      0.765466,
      0,
      NULL,
      5,
      1.994686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.424770,
      0.649726,
      0,
      0,
      NULL,
      1.702261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3.906567,
      NULL,
      1.207219,
      1.805362,
      1.264111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.052690,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.602889,
      5,
      5.289681,
      1.908655,
      7.533013,
      4,
      2.105911,
      NULL,
      1.291517,
      NULL,
      7,
      0.861554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064930,
      1.241816,
      0.974542,
      NULL,
      0,
      0.830629,
      3.690026,
      326.032577,
      0,
      0.861695,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      5.909670,
      1.181417,
      0.511923,
      4,
      5,
      1,
      NULL,
      0,
      1.204572,
      5,
      3.625926,
      0,
      0,
      0,
      NULL,
      1,
      1.666985,
      0.997541,
      1.532815,
      0.463545,
      0.520778,
      1,
      NULL,
      NULL,
      0.034447,
      1.555754,
      1.327874,
      NULL,
      0,
      0,
      1,
      NULL,
      5,
      NULL,
      3,
      0,
      2.529213,
      2.679756,
      3,
      NULL,
      NULL,
      31.280235,
      3.293696,
      NULL,
      NULL,
      23.250494,
      27.673436,
      57,
      NULL,
      0,
      4.736823,
      '34144',
      '42100',
      '',
      0,
      NULL,
      NULL,
      '',
      0.068952,
      '',
      '',
      '',
      0.912314,
      24,
      25,
      11.161763,
      3.535522,
      9,
      19.432906,
      8.230762,
      0.528784,
      0.751389,
      1.235349,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.995172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760322,
      NULL,
      NULL,
      3,
      NULL,
      1.228249,
      1.809387,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.324554,
      NULL,
      NULL,
      1.601782,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      4.142605,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.001586,
      0,
      0.226349,
      NULL,
      2.421219,
      1,
      0.950625,
      2.192864,
      0.316973,
      0,
      2,
      NULL,
      3,
      NULL,
      1.947602,
      NULL,
      0,
      3,
      NULL,
      1.450937,
      1,
      0,
      0.555858,
      0.953063,
      NULL,
      NULL,
      1.419786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985639,
      3,
      NULL,
      1,
      0.610412,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.300573,
      NULL,
      NULL,
      0.805453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.071688,
      2,
      5.541802,
      4,
      1.344236,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.208096,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.690582,
      2,
      2,
      NULL,
      NULL,
      NULL,
      6.063514,
      5,
      NULL,
      8,
      4,
      5.870321,
      1.247883,
      NULL,
      NULL,
      NULL,
      3,
      0.404635,
      3,
      0.540191,
      3,
      1.964038,
      2.362635,
      0.095282,
      7,
      2.868567,
      1.163197,
      3,
      0.726722,
      NULL,
      0.486277,
      3.043137,
      2.394372,
      0.076690,
      3.807789,
      2.746428,
      3.471668,
      NULL,
      NULL,
      NULL,
      6.304630,
      5,
      3,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      1.038578,
      1.885283,
      0.908137,
      1.060633,
      3.910080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.000803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.677867,
      NULL,
      0,
      0,
      0.183295,
      2.120950,
      NULL,
      NULL,
      1.193869,
      3,
      NULL,
      NULL,
      8.186898,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.221651,
      NULL,
      NULL,
      NULL,
      1,
      1.286921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538147,
      NULL,
      NULL,
      NULL,
      2.867889,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.480958,
      NULL,
      NULL,
      0.769977,
      1.924560,
      NULL,
      NULL,
      1.258523,
      1.026292,
      NULL,
      NULL,
      0,
      1.025861,
      NULL,
      NULL,
      0,
      1.311924,
      NULL,
      NULL,
      1.852834,
      1,
      NULL,
      NULL,
      1.266277,
      1,
      NULL,
      NULL,
      6.393475,
      0,
      NULL,
      NULL,
      2.226591,
      NULL,
      1.894013,
      2,
      2,
      NULL,
      1805,
      NULL,
      374.880374,
      552,
      0,
      NULL,
      NULL,
      0.089703,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.203892,
      NULL,
      NULL,
      0,
      NULL,
      1,
      192,
      NULL,
      1.995277,
      1,
      0,
      1.866794,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.085165,
      0.157302,
      0,
      0,
      0,
      0.210979,
      1,
      0.416215,
      3.294390,
      NULL,
      1.644559,
      NULL,
      0.709695,
      NULL,
      NULL,
      NULL,
      1.295368,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      1,
      3,
      21.948332,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535349,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611795,
      NULL,
      1.196270,
      NULL,
      1.158052,
      NULL,
      0.796231,
      NULL,
      0.662468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130253,
      NULL,
      1.059521,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.431099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419439,
      NULL,
      1,
      NULL,
      1.096175,
      NULL,
      61,
      NULL,
      0.991944,
      NULL,
      NULL,
      NULL,
      1.753653,
      NULL,
      NULL,
      24.420780,
      11.177305,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.180451,
      1,
      10,
      4.945245,
      NULL,
      NULL,
      NULL,
      14,
      0.484610,
      3.644588,
      NULL,
      1,
      1,
      NULL,
      1.883954,
      1,
      1.597159,
      0,
      0,
      0.386401,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.756467,
      NULL,
      1,
      3.281566,
      0.805969,
      NULL,
      1.065172,
      1,
      0.318419,
      NULL,
      0,
      0.350960,
      0,
      3.411498,
      0,
      1.586712,
      1,
      1.992390,
      2,
      1.252557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019777,
      1,
      NULL,
      3,
      1.947177,
      3.621545,
      NULL,
      3,
      0,
      NULL,
      1,
      2,
      0.679269,
      0.536987,
      2,
      NULL,
      NULL,
      1.121947,
      0.262077,
      2,
      NULL,
      0,
      1.722104,
      0.374560,
      1.381852,
      1,
      0.700025,
      NULL,
      71,
      1.507242,
      0.141259,
      NULL,
      2.958309,
      0.560978,
      0.240301,
      NULL,
      12.346862,
      5.403681,
      0.622751,
      0.094303,
      0,
      21,
      8,
      1,
      NULL,
      5,
      '42410',
      '11000',
      '',
      1.751625,
      '',
      '',
      '',
      1,
      '',
      NULL,
      NULL);
commit;
end;
/


