set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7808502';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '2033102',
      3,
      1.158303,
      1,
      2,
      '1231',
      1,
      1.843728,
      NULL,
      NULL,
      NULL,
      46.902190,
      NULL,
      1.315138,
      0.346426,
      1,
      ' 3-15-1998',
      66.445424,
      0.462932,
      208,
      148,
      NULL,
      ' 4-20-1996',
      ' 3-23-1979',
      ' 1-19-1979',
      3.767531,
      0,
      2,
      2.688373,
      0.440371,
      2,
      0.470802,
      1,
      1.302073,
      289,
      6,
      12.014997,
      0.851320,
      16,
      NULL,
      2,
      22.454512,
      5.255869,
      0.132745,
      1.877482,
      0.498209,
      1,
      NULL,
      0,
      1.411158,
      1.042497,
      1,
      0,
      1.802962,
      NULL,
      31,
      11,
      1.081568,
      6,
      2.805512,
      4.267448,
      0,
      1,
      NULL,
      NULL,
      0,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      4,
      2,
      0,
      0.634013,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      NULL,
      0,
      NULL,
      NULL,
      0.373481,
      1,
      0.991607,
      2,
      1,
      0,
      1,
      1.077619,
      3,
      NULL,
      0,
      1.241863,
      NULL,
      1,
      NULL,
      0,
      7.868651,
      8,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      6.291288,
      0.840713,
      1.973049,
      1,
      0,
      2.811115,
      0.124504,
      NULL,
      0,
      4.003159,
      NULL,
      0.071926,
      4,
      0.979920,
      0,
      1,
      0.184329,
      1,
      NULL,
      1.422482,
      0.072380,
      0,
      NULL,
      NULL,
      0.818274,
      NULL,
      0.781569,
      1.252349,
      NULL,
      3.128501,
      NULL,
      4.121321,
      3,
      5,
      9,
      NULL,
      9,
      3.087287,
      7.970208,
      2.157364,
      3.192755,
      0.125953,
      5.278550,
      3.058667,
      5,
      2,
      NULL,
      ' 5- 3-1979',
      1719,
      ' 9- 0-1983',
      54.425008,
      2.033037,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.783456,
      0.004022,
      NULL,
      0.375284,
      1,
      0.631622,
      0.431941,
      1,
      6.068216,
      1.873996,
      0,
      1.717694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      11,
      0,
      3.623625,
      NULL,
      1,
      NULL,
      0,
      0,
      22.705539,
      9.765943,
      NULL,
      3,
      NULL,
      2,
      1.119232,
      1.206560,
      0.564456,
      NULL,
      1,
      1,
      0.162238,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.882737,
      1,
      0.542627,
      2.870381,
      NULL,
      0.490890,
      1,
      47.614890,
      178,
      17.074459,
      NULL,
      NULL,
      3.430424,
      2,
      NULL,
      NULL,
      NULL,
      3.688859,
      2,
      NULL,
      0.194434,
      1,
      NULL,
      2.052780,
      3,
      NULL,
      3.014215,
      0,
      NULL,
      1,
      1,
      NULL,
      0.695314,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.803032,
      0.709265,
      1,
      0,
      9,
      1.401696,
      2.215047,
      1.310586,
      7.737191,
      1.123377,
      NULL,
      0,
      3.857583,
      1,
      3,
      3,
      33.588514,
      NULL,
      0,
      NULL,
      NULL,
      9.077797,
      48,
      4.540149,
      0.652553,
      NULL,
      '22042',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      4,
      '40013',
      '3212',
      '04212',
      0,
      3,
      NULL,
      NULL,
      2,
      8.004447,
      NULL,
      NULL,
      4,
      0.140094,
      1,
      3.597778,
      0,
      NULL,
      NULL,
      0.193743,
      NULL,
      NULL,
      1.568763,
      NULL,
      NULL,
      1.873164,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.571408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.897517,
      1,
      5.432738,
      1.861839,
      0,
      NULL,
      NULL,
      NULL,
      1.569547,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.507611,
      NULL,
      1.722077,
      1.619561,
      NULL,
      0.845800,
      NULL,
      0.353758,
      2,
      NULL,
      0.860724,
      0,
      1.923734,
      0.565648,
      3.559340,
      1.299594,
      1.881876,
      2,
      1.606931,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.144894,
      NULL,
      9,
      0,
      0,
      0.653903,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.101438,
      NULL,
      1.983542,
      2,
      1,
      0.738077,
      1,
      5.986293,
      0,
      9,
      1,
      2,
      1.790254,
      0.335687,
      NULL,
      NULL,
      0,
      1.335136,
      1.646565,
      1.883374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522385,
      NULL,
      NULL,
      1.008678,
      NULL,
      NULL,
      0.759731,
      NULL,
      NULL,
      0.729695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4.263819,
      0,
      NULL,
      0,
      1.973436,
      3.323732,
      NULL,
      0.554363,
      1.863747,
      2,
      NULL,
      1,
      NULL,
      1,
      3,
      NULL,
      2.487539,
      1.396552,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.003831,
      2,
      1.757924,
      2,
      9.501804,
      1,
      3,
      1,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.637122,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.355937,
      NULL,
      NULL,
      0.238292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.867604,
      NULL,
      NULL,
      0.638762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917880,
      NULL,
      NULL,
      0.527670,
      NULL,
      NULL,
      0.358585,
      NULL,
      NULL,
      2.681207,
      NULL,
      NULL,
      2,
      0.036930,
      0,
      1.722456,
      0.460127,
      1,
      2.258468,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      5,
      49.325764,
      NULL,
      NULL,
      1.146613,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.407108,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770369,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201132,
      NULL,
      NULL,
      NULL,
      1.429085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.002102,
      3.484112,
      NULL,
      NULL,
      0.642672,
      6,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      271.268253,
      209.523278,
      2,
      NULL,
      2.845798,
      0.467890,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.311308,
      3,
      19,
      0,
      0.812524,
      NULL,
      1.067831,
      251,
      8.655449,
      0,
      0,
      0,
      1,
      0,
      0,
      0.645683,
      NULL,
      0.049521,
      0.051379,
      0,
      1.335772,
      NULL,
      1,
      1,
      1,
      NULL,
      0.481342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      9,
      2.300090,
      NULL,
      5.092011,
      4.821992,
      4,
      2,
      6,
      0,
      3.681929,
      0,
      0.562980,
      NULL,
      0.549500,
      3.561392,
      2,
      0,
      0,
      1,
      1,
      NULL,
      1.439954,
      NULL,
      1,
      3.771949,
      1,
      1.531603,
      1.111884,
      1.645627,
      3,
      3,
      1.674208,
      3,
      0,
      3.479760,
      3.093112,
      NULL,
      1.579663,
      NULL,
      NULL,
      NULL,
      2,
      3.990735,
      0,
      0.234338,
      3.816468,
      1.686355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.696982,
      0,
      3,
      1.395314,
      0,
      NULL,
      3.027485,
      0.975101,
      0.886941,
      0.650595,
      3,
      NULL,
      1.351101,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0.851051,
      NULL,
      1,
      1.795940,
      0.113637,
      NULL,
      2.990360,
      1,
      6,
      2,
      NULL,
      NULL,
      0.951128,
      1,
      1,
      NULL,
      1.633256,
      1.002982,
      1,
      9,
      NULL,
      2.269489,
      2,
      53.389950,
      6,
      5,
      NULL,
      5.727958,
      NULL,
      '04010',
      '21101',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '20214',
      '0111',
      '12003');
commit;
end;
/


