set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9835448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2.731806,
      2.234124,
      NULL,
      3,
      2.061460,
      NULL,
      3.456591,
      '241',
      '42201404',
      1.185047,
      11,
      '3031404',
      1,
      0,
      2,
      NULL,
      '4004',
      6,
      1,
      NULL,
      NULL,
      NULL,
      225.097565,
      NULL,
      NULL,
      1.853200,
      NULL,
      ' 9- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1.472547,
      NULL,
      NULL,
      ' 8-29-1991',
      0.563298,
      0.702006,
      0,
      NULL,
      0.410699,
      2.481356,
      2,
      0,
      1.489603,
      149.579739,
      NULL,
      NULL,
      2.983367,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918998,
      0.171453,
      NULL,
      3.402515,
      5.400837,
      0,
      1.437953,
      1,
      NULL,
      1.711073,
      1,
      0.444143,
      1.046358,
      1.088200,
      NULL,
      1.494734,
      NULL,
      1,
      1.636019,
      0,
      0.134398,
      0,
      NULL,
      NULL,
      1.287861,
      NULL,
      NULL,
      0.809033,
      NULL,
      0.948216,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.712988,
      1.075238,
      1,
      0,
      1.754014,
      1.636177,
      NULL,
      0.761675,
      0,
      NULL,
      NULL,
      0.264226,
      NULL,
      1.346718,
      1,
      NULL,
      0.241476,
      0,
      NULL,
      1,
      1.230459,
      1,
      1,
      0.800820,
      1.598727,
      NULL,
      NULL,
      2.112188,
      1,
      NULL,
      0,
      2.270297,
      1.424685,
      0.317521,
      2.027781,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.023570,
      0,
      3.306639,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.815120,
      NULL,
      0,
      1.751100,
      NULL,
      1.020053,
      1.072423,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.273189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.278765,
      1,
      0.285426,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175739,
      3.363490,
      0,
      0.220045,
      0,
      NULL,
      1,
      0,
      NULL,
      1.476193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.640131,
      0.289689,
      2.552340,
      NULL,
      1.511335,
      1.218398,
      3,
      1,
      0.561403,
      0.395324,
      2.981909,
      2,
      1,
      1,
      2.054730,
      0,
      NULL,
      0.158405,
      5,
      1,
      0,
      NULL,
      0,
      1,
      0.771474,
      1,
      1,
      0.598043,
      1.608528,
      1.442193,
      0.666793,
      NULL,
      5.481893,
      4,
      2.503051,
      3,
      4,
      0.359908,
      2,
      6,
      1,
      1,
      3,
      35,
      2,
      NULL,
      22,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      '33200',
      '',
      '',
      0,
      '',
      '',
      '',
      1.839864,
      '43443',
      '21400',
      '',
      0.554091,
      9.640291,
      NULL,
      59.725552,
      3,
      NULL,
      4,
      8.888943,
      1.162208,
      2,
      2,
      0.960637,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.117172,
      NULL,
      NULL,
      0.356452,
      NULL,
      NULL,
      2.358036,
      0.557645,
      0.792799,
      1,
      0.759158,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.643530,
      NULL,
      NULL,
      1.648574,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.522246,
      NULL,
      NULL,
      NULL,
      0.255744,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.366476,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.747251,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.765327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.016865,
      NULL,
      NULL,
      1.285840,
      1.202474,
      0,
      1.257703,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0.490780,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.517431,
      1.809144,
      0,
      NULL,
      NULL,
      0.513783,
      NULL,
      NULL,
      1.623757,
      NULL,
      NULL,
      0.200951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.947351,
      NULL,
      NULL,
      1.718274,
      0.991783,
      1.379583,
      NULL,
      1.119693,
      0.918325,
      NULL,
      0,
      3,
      0,
      NULL,
      6.785865,
      2.457099,
      0,
      NULL,
      NULL,
      0.249444,
      3,
      0,
      NULL,
      1.757680,
      1,
      2,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      7,
      1,
      0.792136,
      0,
      1.007565,
      0.603708,
      1,
      NULL,
      NULL,
      0.559020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.525376,
      NULL,
      NULL,
      0.743019,
      NULL,
      NULL,
      1.324733,
      NULL,
      NULL,
      3.880487,
      NULL,
      NULL,
      1.181455,
      NULL,
      NULL,
      4.530216,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.554123,
      NULL,
      1.535439,
      0,
      NULL,
      NULL,
      2.839726,
      1,
      NULL,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.964318,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.431940,
      NULL,
      NULL,
      NULL,
      0.821178,
      NULL,
      NULL,
      NULL,
      0.728989,
      NULL,
      NULL,
      NULL,
      0.694743,
      0.391248,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.657326,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198078,
      NULL,
      NULL,
      3,
      1.174540,
      NULL,
      NULL,
      NULL,
      0.143927,
      NULL,
      NULL,
      NULL,
      5.822015,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.295945,
      NULL,
      12.339613,
      NULL,
      261.941784,
      13,
      1.703019,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.280144,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.668181,
      NULL,
      0,
      22,
      0.385696,
      0.632108,
      NULL,
      0.780664,
      0.949048,
      1.158220,
      0.572880,
      1.053317,
      0.908989,
      NULL,
      1,
      0,
      0.283766,
      0,
      0.116411,
      NULL,
      0.117928,
      0,
      1.881823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104768,
      0.873563,
      1,
      1,
      NULL,
      4,
      2.317925,
      0.473871,
      NULL,
      1,
      3.563512,
      0.971265,
      NULL,
      0,
      1,
      1,
      2,
      2.907297,
      NULL,
      3,
      2.063806,
      0.290092,
      0.059536,
      0,
      0.164505,
      0,
      NULL,
      NULL,
      1.822835,
      1.300102,
      3.557115,
      0,
      NULL,
      1.368181,
      1,
      1.844310,
      0,
      1.038746,
      1,
      0.658976,
      1,
      2.671612,
      0,
      1,
      1.968731,
      1.155787,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.641174,
      0,
      0,
      1.924673,
      1.427865,
      2,
      4.839835,
      5,
      0,
      NULL,
      NULL,
      126,
      36.349202,
      1.028472,
      4.015955,
      3.559487,
      '02213',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      1,
      '43202',
      '04130',
      '');
commit;
end;
/


