set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6817387';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3430442',
      2,
      1,
      2,
      NULL,
      '3424',
      2.754931,
      1,
      NULL,
      NULL,
      ' 2- 2-1986',
      5.755510,
      NULL,
      4.870276,
      NULL,
      0.035185,
      '11- 6-1995',
      75,
      2.522058,
      38.195890,
      115.106243,
      2,
      ' 4-24-1991',
      ' 8-29-2002',
      ' 4- 4-1980',
      3,
      2,
      0.435695,
      1,
      0,
      1,
      1.442927,
      1.876823,
      1,
      356,
      9,
      3,
      0.858936,
      28.380851,
      18.615278,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0.470921,
      0.427027,
      0,
      1.972663,
      1,
      0,
      0,
      1.749249,
      0,
      3.796933,
      4.770624,
      1.906425,
      NULL,
      5.913698,
      1.251373,
      0,
      1.921455,
      0.974244,
      1,
      0.048173,
      0,
      1,
      1,
      1,
      0.073955,
      4.382291,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.601144,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087667,
      2,
      0,
      1.299212,
      NULL,
      7.616366,
      1,
      0,
      NULL,
      7.024349,
      NULL,
      3.999812,
      0,
      5.213516,
      1.282975,
      0,
      0.395916,
      0,
      0,
      NULL,
      0.649725,
      1.345207,
      1,
      NULL,
      5,
      NULL,
      3.785183,
      0.336946,
      NULL,
      2.542663,
      2,
      0.153205,
      2.813568,
      1,
      5.618824,
      2,
      1,
      1,
      3.468264,
      1,
      0,
      6,
      7,
      NULL,
      1.908668,
      1,
      3.481822,
      0.518291,
      ' 9-15-1985',
      1272.002671,
      ' 8- 9-1984',
      176,
      NULL,
      0,
      0,
      0.818058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.815544,
      1.814699,
      4,
      5,
      5.322183,
      1.152181,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.120848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.075823,
      2,
      1.961019,
      1,
      1.639555,
      1,
      NULL,
      NULL,
      NULL,
      1.190179,
      1.985274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.269625,
      0.212861,
      0.883451,
      NULL,
      1,
      NULL,
      1.451525,
      6.017448,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.822700,
      NULL,
      NULL,
      2,
      3,
      1.683812,
      1,
      2,
      1,
      1.293026,
      NULL,
      1.500632,
      1,
      0,
      1.777990,
      0,
      0,
      2,
      NULL,
      1,
      NULL,
      0.335950,
      0,
      2.533449,
      0.820874,
      1,
      1,
      NULL,
      11.148782,
      6.803140,
      7,
      NULL,
      6.524743,
      2.239992,
      3.374668,
      5.510231,
      1,
      NULL,
      NULL,
      47.873668,
      1.469238,
      3.450680,
      NULL,
      71,
      41.513258,
      20.585907,
      0.457291,
      NULL,
      3.186711,
      '41224',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.774837,
      '',
      '',
      '',
      1.000295,
      NULL,
      356,
      28.345937,
      1.553289,
      28.321283,
      2.194552,
      NULL,
      3,
      1,
      3,
      0.325601,
      1,
      3.453773,
      1.787794,
      0,
      0.054867,
      NULL,
      2.659228,
      0.784802,
      0.967763,
      0.163436,
      NULL,
      NULL,
      2,
      0,
      1.301264,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.903836,
      5,
      2.896817,
      1.470204,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.450983,
      NULL,
      NULL,
      0.767570,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.758567,
      NULL,
      NULL,
      1.913661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.550936,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3.924854,
      4.083420,
      3.901488,
      NULL,
      NULL,
      NULL,
      1.590130,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.231548,
      NULL,
      NULL,
      0.178981,
      NULL,
      NULL,
      0.190918,
      NULL,
      NULL,
      1.676661,
      2,
      1,
      1.773030,
      NULL,
      1.627027,
      3,
      0,
      2.283149,
      NULL,
      5.592447,
      4.566196,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.570512,
      2,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      1.583448,
      0.498184,
      0.264489,
      3,
      1.639104,
      NULL,
      3,
      1,
      2,
      1.764976,
      NULL,
      5,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.430708,
      1.621344,
      1.435970,
      NULL,
      0.673816,
      1,
      0.553311,
      NULL,
      NULL,
      0.611441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.271037,
      NULL,
      NULL,
      1.638126,
      NULL,
      NULL,
      0.554640,
      NULL,
      NULL,
      1.180350,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.631501,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      20.387478,
      NULL,
      NULL,
      NULL,
      2.976348,
      NULL,
      NULL,
      NULL,
      3.855080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.030345,
      NULL,
      NULL,
      NULL,
      0.668280,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.872150,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.139804,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.766537,
      1,
      NULL,
      NULL,
      0.180779,
      1.829513,
      NULL,
      NULL,
      0.877256,
      1.015848,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.113007,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      126.556574,
      12,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662717,
      NULL,
      NULL,
      1.456244,
      NULL,
      NULL,
      3.051811,
      1.898305,
      1.655249,
      235.100524,
      1.652388,
      0,
      1.999182,
      0.436846,
      NULL,
      0.737791,
      1.119672,
      1,
      1,
      0.768500,
      0.503363,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066110,
      1,
      1,
      2,
      1,
      3,
      2,
      NULL,
      10,
      NULL,
      0,
      3,
      0,
      1.660588,
      NULL,
      1.485718,
      2.488846,
      1.665125,
      1.216126,
      3,
      0,
      0,
      0.284186,
      1,
      0,
      0,
      0,
      1.946709,
      NULL,
      0.223097,
      0.061539,
      0.479186,
      2,
      1,
      NULL,
      1,
      1.008395,
      NULL,
      NULL,
      0,
      0.544829,
      NULL,
      0.421734,
      0.018068,
      0,
      3,
      0.123743,
      1.017554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.156536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508258,
      0.945134,
      1,
      0.835682,
      0,
      1,
      2,
      11.524513,
      8.711674,
      NULL,
      0.264204,
      0.605812,
      NULL,
      32,
      NULL,
      1.713287,
      0.451523,
      '03102',
      NULL,
      '44041',
      1,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


