set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8836024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4240344',
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.610011,
      1,
      NULL,
      NULL,
      ' 5-28-1978',
      64.045730,
      NULL,
      1.870549,
      3.502886,
      0.156985,
      ' 4-16-1985',
      17.466022,
      1,
      18.200165,
      NULL,
      3,
      ' 3-22-1990',
      '11-13-1975',
      NULL,
      0,
      1.311660,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0.232087,
      0.178508,
      36,
      1.862945,
      5,
      4.091246,
      NULL,
      NULL,
      3.350345,
      NULL,
      0.059513,
      2,
      NULL,
      0.345169,
      4.180635,
      1.926352,
      1.131223,
      0,
      0,
      1,
      0.336996,
      NULL,
      0.288088,
      0,
      5,
      4.879950,
      3,
      3,
      9,
      1.147349,
      1,
      NULL,
      5.196322,
      0,
      1.076560,
      1,
      NULL,
      NULL,
      0,
      0.198531,
      0.077059,
      0.452921,
      1.569165,
      0,
      0.719803,
      1,
      4.225007,
      0.575985,
      0.049029,
      NULL,
      NULL,
      0.456223,
      1,
      0.927743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733118,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.798513,
      NULL,
      1.323945,
      2.498092,
      9,
      1,
      5,
      NULL,
      4,
      5.156854,
      NULL,
      1.496460,
      NULL,
      NULL,
      NULL,
      1.294856,
      0.244578,
      1.882564,
      NULL,
      0.493010,
      0.592919,
      2,
      NULL,
      NULL,
      5,
      2.534136,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      5.583773,
      1.450029,
      3,
      1,
      4,
      6,
      NULL,
      0,
      5,
      NULL,
      0.713058,
      1,
      0.531843,
      0.252469,
      ' 2-25-1994',
      22,
      '11-23-2001',
      9.693133,
      0,
      1.312310,
      NULL,
      3,
      7,
      NULL,
      1.040772,
      2,
      1,
      0.161846,
      1.313845,
      NULL,
      2,
      8.208739,
      NULL,
      NULL,
      0,
      NULL,
      0,
      6.733140,
      2.654365,
      ' 0-10-1997',
      0,
      ' 7-10-1976',
      17,
      0,
      1.354999,
      1,
      0.552026,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.872358,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.596698,
      0,
      1.348390,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031235,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      0,
      4,
      0.080497,
      0.091188,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.653993,
      3,
      0.551046,
      2,
      3.400747,
      2,
      2.673622,
      2.780298,
      1,
      1,
      0.227321,
      NULL,
      0,
      4.128572,
      0.959129,
      NULL,
      0.920817,
      0.711918,
      1,
      0.210928,
      1,
      0.625985,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      6,
      3.919135,
      3.112217,
      NULL,
      NULL,
      3,
      0.533468,
      0,
      1,
      0.386158,
      0.710065,
      3,
      NULL,
      3,
      0.496344,
      NULL,
      61.038505,
      19.412301,
      NULL,
      3,
      0.536218,
      NULL,
      NULL,
      '13114',
      '',
      1,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      1,
      38.817876,
      16,
      4,
      0,
      25,
      0,
      3,
      5,
      1.031698,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568852,
      NULL,
      NULL,
      2.329676,
      NULL,
      0,
      NULL,
      0.225024,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.597624,
      0.484938,
      NULL,
      NULL,
      0.716927,
      NULL,
      NULL,
      0.387499,
      NULL,
      NULL,
      0.839777,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.690516,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.658891,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.082425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.441867,
      NULL,
      NULL,
      0.507745,
      NULL,
      NULL,
      1.349131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999963,
      NULL,
      NULL,
      NULL,
      2.631697,
      NULL,
      0.570344,
      NULL,
      NULL,
      0,
      0,
      0,
      3.487374,
      0,
      0.237576,
      1.553965,
      1.003200,
      0.264619,
      0,
      3.922557,
      1,
      0.389131,
      NULL,
      NULL,
      1.361505,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.576724,
      NULL,
      NULL,
      0.633110,
      NULL,
      NULL,
      0,
      3.637745,
      0,
      NULL,
      1,
      0.368579,
      1.658763,
      2,
      1,
      0.496156,
      NULL,
      NULL,
      0.725621,
      3.228000,
      0,
      0.963490,
      NULL,
      NULL,
      3,
      3,
      2.937616,
      1,
      NULL,
      NULL,
      6.913500,
      6,
      5.995791,
      1,
      3,
      NULL,
      3,
      5.204088,
      9,
      1.677005,
      NULL,
      NULL,
      3,
      2,
      1.974782,
      3,
      2,
      4,
      0,
      NULL,
      NULL,
      0,
      4,
      7.171364,
      NULL,
      0.390596,
      NULL,
      0.678162,
      1.532923,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      82.011009,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.569840,
      NULL,
      NULL,
      0.629513,
      NULL,
      NULL,
      1.096358,
      NULL,
      NULL,
      1.798367,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.575395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.951530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104402,
      1,
      0.242782,
      1,
      NULL,
      NULL,
      2.280565,
      NULL,
      NULL,
      7,
      2.240830,
      NULL,
      NULL,
      131.861579,
      324.755654,
      NULL,
      NULL,
      3,
      1.652914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.168585,
      NULL,
      NULL,
      3.578939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.462648,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.213203,
      NULL,
      NULL,
      3.231133,
      2.821397,
      NULL,
      NULL,
      3.020635,
      3,
      NULL,
      NULL,
      NULL,
      0.426418,
      NULL,
      NULL,
      1.280646,
      0.616221,
      NULL,
      NULL,
      3,
      0.406876,
      NULL,
      NULL,
      2.559345,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.569959,
      NULL,
      NULL,
      1.332125,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.683218,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.155778,
      NULL,
      1,
      NULL,
      20,
      1.954539,
      2,
      0,
      1.130051,
      0.071033,
      0,
      0,
      2.568862,
      1,
      0,
      1.187093,
      0.809051,
      NULL,
      0.561543,
      1,
      1,
      0,
      2.153605,
      NULL,
      1.032391,
      NULL,
      1,
      NULL,
      0.244479,
      NULL,
      1.291804,
      NULL,
      1,
      NULL,
      250.465531,
      NULL,
      1.184318,
      32,
      50.221678,
      0.554158,
      0.089550,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.192975,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.196945,
      NULL,
      NULL,
      NULL,
      1.528433,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.878257,
      NULL,
      0.589809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.641442,
      3,
      1,
      1.258151,
      1,
      2,
      NULL,
      3,
      2.931999,
      0,
      1.293307,
      0,
      1,
      1,
      1.591913,
      NULL,
      1,
      0.411451,
      0,
      1.231115,
      0.547608,
      0,
      1.910519,
      0,
      NULL,
      0.835524,
      0,
      0.081880,
      0.593213,
      0.992288,
      0.036961,
      0,
      NULL,
      3.551279,
      0.694630,
      0,
      0.031092,
      0.576263,
      NULL,
      1,
      0.753070,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819688,
      1.973712,
      1,
      1.365191,
      0,
      1.974189,
      NULL,
      2.765752,
      NULL,
      1.139678,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187621,
      1.048415,
      0,
      '20113',
      '00342',
      '01313',
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


