set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9313298';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '0401140',
      1.347748,
      0,
      NULL,
      0,
      '0013',
      2,
      0,
      NULL,
      NULL,
      ' 2-24-1985',
      2.544293,
      NULL,
      1.537188,
      2.770247,
      1,
      '11-25-1982',
      16,
      2,
      158,
      49,
      1,
      ' 4- 9-1987',
      ' 6-22-1984',
      ' 8-27-1984',
      0,
      NULL,
      2,
      2.838383,
      NULL,
      NULL,
      3,
      0.542564,
      1.558469,
      144,
      6,
      NULL,
      2,
      10.749776,
      2,
      6.850260,
      21,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.255742,
      6,
      3.071312,
      3.810598,
      1,
      4,
      3.601758,
      NULL,
      NULL,
      3,
      0,
      1.663005,
      1,
      1.360986,
      0.938533,
      NULL,
      1,
      3,
      1.080621,
      1.553086,
      1,
      NULL,
      NULL,
      1.755388,
      NULL,
      NULL,
      0.643980,
      1,
      NULL,
      3,
      2.819874,
      2.299960,
      NULL,
      0,
      3,
      3,
      NULL,
      1,
      1.691389,
      2.186952,
      NULL,
      1,
      1,
      NULL,
      0.808102,
      0,
      1,
      0.340928,
      6,
      1,
      2.571031,
      1.798732,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.394339,
      1.547699,
      1.104398,
      1.389396,
      1,
      3.120996,
      4.947019,
      0.004998,
      1.713808,
      0,
      1,
      1,
      1,
      6,
      1,
      0.075109,
      1.871782,
      0,
      NULL,
      3,
      NULL,
      1.715193,
      4,
      NULL,
      0,
      2,
      1.886354,
      3.011718,
      NULL,
      NULL,
      NULL,
      0.929793,
      0,
      3,
      NULL,
      1.818027,
      6,
      6.622385,
      1,
      NULL,
      2.475107,
      2.026057,
      0,
      0.992308,
      NULL,
      5.620815,
      4.527351,
      3.052410,
      ' 7- 6-1983',
      1295,
      ' 4-19-1998',
      854,
      3,
      1.495867,
      NULL,
      1,
      1.413904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.064213,
      NULL,
      1.148617,
      0.352411,
      0,
      3.437862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.428746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      0.027659,
      0.563064,
      2,
      NULL,
      1.588706,
      0,
      1,
      2.656452,
      NULL,
      1.761632,
      8,
      NULL,
      NULL,
      NULL,
      0.789014,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      3,
      0.678753,
      1.256226,
      1.583716,
      3,
      12,
      1,
      1.558965,
      53.007994,
      NULL,
      5.398790,
      NULL,
      1.934486,
      1,
      1,
      2.108117,
      2,
      NULL,
      3,
      1,
      2,
      0.131322,
      3,
      1.453414,
      0,
      1,
      NULL,
      NULL,
      1,
      1.498906,
      NULL,
      0.669020,
      0.958661,
      NULL,
      1,
      NULL,
      0.903540,
      1.825641,
      0,
      1.765676,
      1.361007,
      5,
      0,
      5.349105,
      1.087091,
      3,
      3,
      1.351614,
      3.547620,
      0,
      2,
      NULL,
      2,
      NULL,
      2,
      2.611151,
      NULL,
      NULL,
      NULL,
      10,
      18,
      12,
      NULL,
      0.339480,
      1.177669,
      '04132',
      '03102',
      '',
      0,
      '',
      '',
      '',
      2,
      '42000',
      '',
      '',
      NULL,
      NULL,
      31.212010,
      NULL,
      0.872254,
      NULL,
      NULL,
      NULL,
      0.213175,
      NULL,
      2.768370,
      NULL,
      1,
      NULL,
      NULL,
      3.806742,
      0.716393,
      1,
      2,
      0,
      2.460394,
      1.847704,
      NULL,
      NULL,
      3,
      0.688970,
      1.278513,
      1.230935,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.072329,
      0,
      NULL,
      NULL,
      1.428382,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.910665,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.865083,
      0,
      2,
      2.573218,
      1.729152,
      3,
      NULL,
      1.035237,
      2.980087,
      NULL,
      0.903885,
      3.851583,
      0,
      3.021325,
      3.682865,
      NULL,
      1.749409,
      1,
      NULL,
      1.758770,
      1,
      1,
      NULL,
      NULL,
      2,
      0.382406,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1,
      0.724966,
      NULL,
      2.326899,
      NULL,
      0,
      1.342057,
      NULL,
      NULL,
      NULL,
      1.771104,
      NULL,
      NULL,
      NULL,
      0.063043,
      NULL,
      NULL,
      NULL,
      1,
      0.949996,
      0,
      0,
      1.226619,
      0.063659,
      NULL,
      NULL,
      1.506661,
      1.116395,
      0.695164,
      NULL,
      NULL,
      1.789169,
      NULL,
      1,
      2.124906,
      0,
      3,
      4.021690,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      5,
      0.295536,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      2.944809,
      2,
      5,
      7.079627,
      2.494307,
      NULL,
      4.639283,
      0,
      1,
      0.080688,
      NULL,
      NULL,
      NULL,
      3,
      0.653429,
      1,
      0.969135,
      0,
      9.741806,
      7.658840,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.639731,
      0,
      1.282207,
      3,
      1.522017,
      2.893609,
      2.832519,
      NULL,
      7,
      6.821481,
      2.266405,
      1,
      1.687331,
      0.977206,
      2.161437,
      NULL,
      3,
      0,
      1.157420,
      0.899484,
      1,
      0,
      2.390023,
      NULL,
      NULL,
      3.916284,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1.353499,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.267011,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.344565,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295963,
      NULL,
      NULL,
      0.892245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.006814,
      NULL,
      NULL,
      NULL,
      2,
      0.177333,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.539560,
      NULL,
      NULL,
      NULL,
      1.504368,
      NULL,
      NULL,
      NULL,
      2.529311,
      NULL,
      NULL,
      NULL,
      0.916773,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.043131,
      NULL,
      NULL,
      NULL,
      3.474870,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.320454,
      NULL,
      NULL,
      NULL,
      2.385127,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.596240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.847372,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      1.504902,
      1.902088,
      184,
      93,
      3,
      1.055963,
      0,
      1.564574,
      NULL,
      NULL,
      2.949126,
      13.813771,
      22.513378,
      1,
      3,
      1.359170,
      3,
      30,
      NULL,
      NULL,
      NULL,
      1,
      1463,
      20.011008,
      0.250622,
      NULL,
      1,
      NULL,
      1,
      0,
      1.600524,
      0.727916,
      1.879125,
      0.323158,
      0.788524,
      1,
      1.126515,
      0,
      1,
      1,
      0.232598,
      1.446168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052201,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.543544,
      1,
      NULL,
      1.829584,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      0,
      1.205601,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824001,
      1.311875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102255,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500883,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059411,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.026576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.196491,
      1.867785,
      NULL,
      4.281393,
      0.543286,
      NULL,
      1,
      3,
      3,
      2,
      1.366016,
      1.012090,
      1,
      0.399404,
      0.038848,
      NULL,
      2.472407,
      0.637986,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.072627,
      3.006263,
      0.397060,
      0,
      NULL,
      1,
      1,
      3.296970,
      0.736738,
      1.884889,
      1,
      3.117283,
      3,
      0,
      1.758729,
      1.225464,
      1.949610,
      0,
      NULL,
      NULL,
      2.808298,
      2,
      1,
      NULL,
      1.007238,
      1.216862,
      1,
      2.586623,
      0,
      0.922822,
      1.314818,
      1,
      NULL,
      3,
      2,
      2.537658,
      3,
      0,
      2.789777,
      0.443667,
      2.426948,
      NULL,
      1.162417,
      NULL,
      2.614422,
      0.874568,
      42.091929,
      0.836786,
      3,
      NULL,
      0,
      3,
      3.373360,
      1.555422,
      2,
      NULL,
      NULL,
      NULL,
      3.421124,
      NULL,
      3,
      NULL,
      0.566595,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      0,
      2.543010,
      3,
      NULL,
      3,
      2.504755,
      NULL,
      29,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1,
      0,
      8,
      0.036103,
      0,
      0,
      0.550856,
      1.070902,
      2.465392,
      62.264111,
      NULL,
      1,
      0,
      '33402',
      '11043',
      NULL,
      0,
      '21212',
      NULL,
      '',
      NULL,
      '02040',
      '',
      '');
commit;
end;
/


