set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9603567';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '4004010',
      1.617072,
      NULL,
      2,
      2,
      '3344',
      NULL,
      1,
      NULL,
      NULL,
      ' 2-14-1975',
      35.611588,
      NULL,
      0,
      NULL,
      1,
      ' 1- 2-1983',
      29,
      0,
      170,
      NULL,
      3,
      ' 2-14-1983',
      ' 9-12-2003',
      NULL,
      0.521932,
      0,
      2,
      2.336924,
      0,
      3,
      0,
      1,
      1.187724,
      9,
      10.808816,
      7,
      0,
      NULL,
      33.610853,
      2,
      13,
      2.699272,
      1,
      2.172118,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.992687,
      0,
      9.640681,
      1,
      1.819362,
      2.268410,
      2,
      6,
      1.977632,
      NULL,
      1.600089,
      1.749292,
      3,
      NULL,
      11,
      0,
      0.165778,
      2,
      3.196636,
      1.806589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.523568,
      0.814094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.825186,
      0.458579,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.546419,
      2.156258,
      1.132667,
      NULL,
      1.419457,
      NULL,
      0.389197,
      1.112302,
      0.358205,
      2,
      0,
      0.884763,
      3,
      1,
      0.203456,
      1,
      1.383788,
      1,
      NULL,
      0,
      1,
      0.568864,
      0,
      3.869386,
      1.769051,
      1,
      1,
      0,
      1.478401,
      0.156812,
      1,
      NULL,
      3,
      0.638043,
      1,
      NULL,
      1.268497,
      1.985416,
      0,
      4,
      1,
      NULL,
      NULL,
      1,
      8,
      5,
      1,
      ' 2-29-1981',
      NULL,
      ' 8-18-2002',
      1609,
      NULL,
      1,
      NULL,
      1.653600,
      1.700359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982885,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.351333,
      1.195539,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.901373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073911,
      1,
      1,
      NULL,
      0.598428,
      NULL,
      0.759083,
      NULL,
      NULL,
      0,
      0.110376,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.891086,
      1,
      3.525066,
      3,
      3,
      1,
      2,
      0,
      2.595259,
      2.295918,
      1,
      3.861047,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.339907,
      0,
      1.101644,
      1.708670,
      NULL,
      1.380036,
      NULL,
      0.120482,
      NULL,
      1.462713,
      6.243894,
      3.717668,
      7,
      2.605285,
      2.180050,
      3,
      2.618122,
      0.135299,
      NULL,
      NULL,
      41,
      2,
      1.660510,
      NULL,
      8,
      11,
      22,
      2.374568,
      NULL,
      3.646965,
      '43002',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1.918359,
      '',
      NULL,
      NULL,
      2.032742,
      7.645827,
      NULL,
      44.395609,
      1,
      3,
      1,
      4,
      2.638115,
      2.180652,
      0.037619,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.932177,
      3.017485,
      0.253230,
      NULL,
      3.842791,
      3.433099,
      2,
      1,
      0,
      NULL,
      0.990946,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.246435,
      0,
      NULL,
      NULL,
      7.196492,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.201792,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.824645,
      NULL,
      NULL,
      1.713423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.660957,
      2.091403,
      2,
      1.234094,
      NULL,
      NULL,
      0.873586,
      NULL,
      NULL,
      6,
      6,
      2,
      0,
      NULL,
      NULL,
      0.253641,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.778812,
      NULL,
      NULL,
      0.668774,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.113426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108398,
      NULL,
      NULL,
      1.262445,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.799922,
      NULL,
      1.628254,
      NULL,
      NULL,
      1.867374,
      1.044254,
      1.785281,
      2.523211,
      2,
      3.415766,
      0.581408,
      NULL,
      NULL,
      5,
      1.719912,
      NULL,
      3,
      0,
      0,
      3,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.495672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537100,
      0,
      1.870893,
      0,
      1,
      3,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.919341,
      NULL,
      NULL,
      NULL,
      1.833178,
      NULL,
      NULL,
      NULL,
      0.227177,
      NULL,
      NULL,
      NULL,
      0.580478,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.430658,
      338,
      NULL,
      1,
      NULL,
      NULL,
      0.413509,
      NULL,
      NULL,
      0.020688,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313830,
      NULL,
      1.569234,
      119.311741,
      0.073089,
      1.417138,
      1,
      0,
      NULL,
      0.797793,
      NULL,
      1.570337,
      0.178237,
      1,
      1,
      1,
      1,
      NULL,
      0.057822,
      NULL,
      1,
      0.080413,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.735941,
      1.731621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077901,
      1.294087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.353258,
      NULL,
      0.938582,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.233514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.563593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.554602,
      NULL,
      NULL,
      NULL,
      3.378442,
      NULL,
      0,
      NULL,
      0,
      1.611440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.067003,
      NULL,
      4.742058,
      NULL,
      0.633975,
      NULL,
      1,
      3,
      2.521599,
      3.155560,
      NULL,
      0,
      1.777575,
      1,
      NULL,
      1.160876,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.487915,
      NULL,
      0,
      0,
      NULL,
      1.811420,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.809365,
      0.885108,
      NULL,
      NULL,
      1.118202,
      NULL,
      NULL,
      2.100906,
      NULL,
      0.390182,
      1,
      NULL,
      NULL,
      0.138703,
      0.122344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.981543,
      NULL,
      1,
      NULL,
      NULL,
      2.239218,
      1,
      1.876519,
      0,
      2,
      20,
      NULL,
      1.680438,
      2,
      0,
      '21132',
      '',
      '',
      1.936872,
      '',
      '',
      '',
      0.111366,
      NULL,
      '',
      '');
commit;
end;
/


