set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      NULL,
      3,
      3.789258,
      3,
      2,
      NULL,
      1.737794,
      NULL,
      '44322314',
      57.658192,
      NULL,
      '1022441',
      1.725816,
      1.961829,
      NULL,
      2,
      '0112',
      4,
      1,
      NULL,
      NULL,
      '10-16-1974',
      NULL,
      18.261245,
      NULL,
      3,
      1.045461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 2-21-1996',
      ' 4- 5-1999',
      NULL,
      3,
      NULL,
      3.103533,
      1.806601,
      1,
      NULL,
      1.054375,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      2,
      1.846082,
      0.555336,
      1.445334,
      1.223273,
      0.632465,
      1,
      1.945765,
      1,
      0.453719,
      2.685843,
      1.805311,
      0.980356,
      2.163225,
      7.517189,
      1.416343,
      NULL,
      0.263947,
      0,
      2.050092,
      6,
      7,
      7.856832,
      1,
      1,
      NULL,
      0.848953,
      0.940817,
      NULL,
      0.598068,
      NULL,
      0.197716,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3.515342,
      8.553787,
      1,
      1.722137,
      1,
      2,
      0,
      2,
      1,
      2.399864,
      0.884967,
      0.985792,
      1.891003,
      0,
      3.298110,
      3,
      0,
      1.966191,
      1,
      1.322826,
      3.192428,
      8,
      1.221116,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416407,
      1,
      0.825956,
      1,
      NULL,
      4.417899,
      3.899464,
      NULL,
      0,
      1.307665,
      0,
      5,
      NULL,
      3.243230,
      0.409844,
      0.221330,
      NULL,
      1.552842,
      1.827743,
      NULL,
      0.777121,
      7,
      NULL,
      1,
      3.646163,
      3.879868,
      0,
      3,
      1,
      NULL,
      1,
      2,
      0.548837,
      0.399845,
      0.259173,
      1.648515,
      2,
      6,
      2,
      5.693858,
      5,
      4.558681,
      3,
      6,
      0,
      6,
      5.596393,
      2,
      ' 3- 2-2000',
      135.364236,
      ' 5-25-1995',
      NULL,
      0.728292,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1.401959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3.482169,
      0.753716,
      0,
      1,
      NULL,
      5.781000,
      5.705459,
      0,
      2,
      3,
      0,
      1.828914,
      1.292753,
      1.661102,
      3,
      5.912370,
      1.144660,
      7,
      0.803597,
      NULL,
      NULL,
      NULL,
      1.300723,
      3.618885,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.560754,
      NULL,
      NULL,
      0.922215,
      NULL,
      2.687130,
      4.807471,
      2.183894,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.508562,
      3.911964,
      1,
      NULL,
      1,
      1.830716,
      3.001141,
      2.659491,
      NULL,
      3,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.593285,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      10,
      3.879716,
      1,
      11.552786,
      10,
      0,
      2.179151,
      1,
      3.085979,
      1,
      0.645792,
      2.505514,
      50.271642,
      0.376024,
      2.341657,
      47,
      NULL,
      5.712844,
      35.957084,
      NULL,
      NULL,
      NULL,
      '23013',
      '',
      '',
      0.307318,
      '',
      '',
      '',
      NULL,
      '0042',
      '',
      '',
      3.264882,
      NULL,
      1,
      51,
      1.884127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.624569,
      NULL,
      1,
      NULL,
      NULL,
      0.385692,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.295095,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.418731,
      NULL,
      1,
      1,
      0,
      1,
      1.795204,
      0.712190,
      0,
      0.563430,
      NULL,
      NULL,
      1.240977,
      1.717269,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.396430,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.792563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.107251,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.294457,
      NULL,
      0.280736,
      0,
      3,
      1.406622,
      0,
      0,
      NULL,
      0.292251,
      NULL,
      1,
      1.499919,
      NULL,
      1.324701,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.967991,
      NULL,
      NULL,
      3.585401,
      1,
      NULL,
      1.355257,
      1.446674,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.262158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.829012,
      2,
      1.062251,
      1.129833,
      NULL,
      NULL,
      1,
      0,
      3,
      0.144749,
      NULL,
      NULL,
      0.195710,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459369,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.541211,
      1.433813,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082184,
      3.865343,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.235342,
      1.377937,
      0,
      2.339660,
      NULL,
      0.560692,
      4.639157,
      7.647982,
      1.708674,
      3.665240,
      NULL,
      NULL,
      3,
      1.284352,
      1,
      0.591691,
      2,
      0.083946,
      NULL,
      NULL,
      1,
      NULL,
      2.485451,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      0.057627,
      0,
      1.396165,
      0,
      3.909137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.506106,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.435320,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.835509,
      NULL,
      1,
      1.152987,
      NULL,
      3.998739,
      0.561824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.362363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.586071,
      NULL,
      NULL,
      NULL,
      1.899628,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.343522,
      NULL,
      NULL,
      NULL,
      3.737907,
      NULL,
      NULL,
      NULL,
      1.013294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.931273,
      NULL,
      NULL,
      NULL,
      0.838329,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      31.490960,
      57,
      0.611716,
      NULL,
      NULL,
      3.485161,
      1.356767,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.129397,
      NULL,
      1.271422,
      27,
      NULL,
      0.198363,
      1,
      0.659924,
      0.566191,
      NULL,
      1,
      1,
      0.749409,
      0.108827,
      NULL,
      0.751471,
      0.287553,
      0.742181,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070609,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.095019,
      7,
      3.386819,
      NULL,
      0,
      0,
      1.711163,
      NULL,
      0,
      0.011807,
      NULL,
      0.087824,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400961,
      0.714768,
      NULL,
      1.949380,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.775393,
      NULL,
      2.962073,
      2,
      NULL,
      2,
      NULL,
      NULL,
      0,
      0.575439,
      NULL,
      2.671539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341819,
      NULL,
      1.282738,
      NULL,
      1.150263,
      NULL,
      NULL,
      NULL,
      0.984183,
      0,
      NULL,
      NULL,
      27,
      73.716999,
      0.398218,
      4.146028,
      4,
      '10131',
      '23244',
      '',
      1,
      '',
      '',
      '',
      2.608097,
      '4210',
      '',
      NULL);
commit;
end;
/


