set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9834815';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.804308,
      1,
      2,
      2,
      NULL,
      3.215814,
      0,
      1,
      '031',
      '41024230',
      23.944240,
      NULL,
      '2211000',
      NULL,
      1,
      3,
      3,
      '3043',
      NULL,
      0.168739,
      NULL,
      NULL,
      '10-15-1974',
      220.682547,
      192.546707,
      NULL,
      NULL,
      0.786674,
      ' 7-28-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 5- 5-1976',
      NULL,
      ' 7- 8-1999',
      2,
      0.982160,
      0,
      2.497400,
      0.675103,
      2,
      6.973649,
      3,
      NULL,
      NULL,
      NULL,
      2,
      0.007291,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476440,
      3.415922,
      NULL,
      1.915208,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      1.333223,
      0.394589,
      1.057531,
      0,
      3.846160,
      2,
      0.681072,
      1.062092,
      0.678056,
      0.791004,
      NULL,
      0.238522,
      1.649002,
      0.537335,
      0.394384,
      7,
      0.464163,
      1,
      9.653990,
      5.994282,
      NULL,
      0.511567,
      NULL,
      1.726246,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.576858,
      5.150198,
      0.174445,
      0,
      1,
      1,
      3.474795,
      1,
      0,
      0,
      3.696878,
      0,
      1.481828,
      0.391767,
      NULL,
      0,
      1,
      3.645358,
      1,
      1.139275,
      1,
      NULL,
      0,
      NULL,
      3,
      1.588631,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      5,
      5,
      0,
      0.153586,
      0,
      0,
      1.332353,
      0,
      1,
      0.137239,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.083077,
      0,
      0,
      1.302799,
      0,
      4,
      1,
      0.314759,
      1.199215,
      0.815344,
      0.519763,
      NULL,
      1,
      1.631385,
      NULL,
      NULL,
      0,
      NULL,
      6,
      NULL,
      1.594655,
      9,
      0.510348,
      0.320695,
      0,
      2.086014,
      NULL,
      NULL,
      ' 1-22-1993',
      158,
      2.877272,
      0.491420,
      1.002436,
      2.119791,
      0.749238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.986025,
      0,
      1.800360,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      3,
      1,
      0.687168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.526027,
      7.375587,
      0.587288,
      2.839475,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.180431,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.074097,
      NULL,
      1,
      0.224307,
      0.242945,
      1,
      1.413928,
      NULL,
      NULL,
      NULL,
      0.655696,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      2.060904,
      3.630628,
      0,
      3.386938,
      1,
      2,
      3,
      2,
      2.675950,
      1,
      2,
      3,
      1,
      1.460099,
      0,
      1.128606,
      NULL,
      1.139626,
      1.300919,
      4.709901,
      1,
      0,
      5.067217,
      0,
      1.880330,
      0,
      0.710458,
      0.141089,
      1,
      9,
      11,
      7,
      8.786595,
      5,
      5.700523,
      1,
      3.779467,
      NULL,
      1,
      NULL,
      0.797872,
      61,
      0,
      3,
      14.747976,
      NULL,
      34.985078,
      62.423736,
      5,
      1,
      1.393838,
      '02334',
      '',
      '',
      1.730557,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1,
      10,
      74.911905,
      2.798028,
      1.677174,
      NULL,
      NULL,
      2,
      NULL,
      2.995513,
      2.835993,
      3.693247,
      0,
      NULL,
      NULL,
      0.536076,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.300599,
      NULL,
      NULL,
      0.903174,
      NULL,
      0.217779,
      3.890122,
      1.206736,
      3,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.998255,
      1.033021,
      2,
      1.334284,
      NULL,
      NULL,
      7,
      3.202751,
      1.451842,
      1.825983,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.889090,
      1.831135,
      1.709026,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.483293,
      2.927795,
      NULL,
      0,
      NULL,
      3,
      1.126000,
      NULL,
      2.467588,
      1,
      1.885523,
      0,
      1,
      NULL,
      NULL,
      3.660071,
      0.274924,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.896514,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.048106,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.667354,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.009033,
      NULL,
      1.498775,
      NULL,
      NULL,
      0,
      1.930315,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595416,
      NULL,
      NULL,
      0.315304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.984712,
      NULL,
      1,
      NULL,
      NULL,
      2.000893,
      2.667704,
      2.127597,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028405,
      3.541853,
      0.584419,
      1.991632,
      1.263160,
      2.144769,
      4,
      0,
      2.360061,
      3,
      3.286614,
      1.994850,
      0.558755,
      1,
      2.616911,
      1,
      3.507438,
      NULL,
      NULL,
      0.440333,
      1,
      NULL,
      5.419413,
      3,
      0,
      NULL,
      NULL,
      3.549015,
      NULL,
      5.410872,
      1.793793,
      1,
      1.655299,
      1.259503,
      0.633696,
      0,
      NULL,
      NULL,
      1.504587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.363105,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.240146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470208,
      NULL,
      NULL,
      0,
      NULL,
      1.570600,
      NULL,
      NULL,
      NULL,
      2.706903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.940816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.859088,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.802726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.799493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.119291,
      48,
      11,
      2.768362,
      109,
      28,
      0.596040,
      NULL,
      NULL,
      0.278115,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.789403,
      NULL,
      NULL,
      1.996040,
      NULL,
      1,
      0,
      6,
      NULL,
      0,
      1.029415,
      0.049632,
      0.074291,
      0.410276,
      NULL,
      0.188323,
      1.579061,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303220,
      1.555150,
      0,
      NULL,
      1.799473,
      0,
      0.196028,
      1,
      3,
      0.191230,
      1,
      0.169365,
      NULL,
      NULL,
      0.893478,
      NULL,
      NULL,
      1,
      0.947479,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129607,
      3.881344,
      NULL,
      1.914248,
      1.659267,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.735488,
      NULL,
      0.714362,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0.384113,
      0.973924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544630,
      NULL,
      NULL,
      NULL,
      1.515231,
      NULL,
      6.878817,
      3,
      3.969478,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      0.890629,
      5.859352,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '');
commit;
end;
/


