set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8931807';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4443014',
      0,
      0,
      2,
      3,
      '2104',
      2.796069,
      1.185423,
      NULL,
      NULL,
      ' 5- 5-1992',
      31,
      NULL,
      1.149967,
      NULL,
      1,
      ' 7- 1-1984',
      18.010809,
      2.172819,
      301.620715,
      164.325174,
      NULL,
      ' 1- 0-1986',
      NULL,
      NULL,
      0,
      3,
      NULL,
      3.740715,
      0.173217,
      2,
      NULL,
      0.559755,
      1.633083,
      312,
      9,
      15.804880,
      NULL,
      2.546526,
      NULL,
      3,
      10,
      1.434888,
      1,
      1,
      0.330919,
      NULL,
      NULL,
      1.171101,
      0,
      1,
      1,
      NULL,
      1,
      1,
      4,
      0,
      0,
      6.658813,
      1.979254,
      4,
      NULL,
      NULL,
      0,
      1,
      0,
      9,
      2.886820,
      1.913785,
      NULL,
      2.353741,
      0,
      10,
      0,
      NULL,
      1,
      1.789908,
      0.751204,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.474373,
      1,
      0.065214,
      3,
      NULL,
      NULL,
      1.878208,
      2,
      2,
      3,
      0.247269,
      NULL,
      1.946307,
      1.548194,
      1.329416,
      0.065203,
      2.710532,
      NULL,
      1.756029,
      0,
      1.152288,
      7,
      1.381759,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.931586,
      NULL,
      7,
      1,
      0,
      1.916815,
      NULL,
      0,
      1,
      3,
      1,
      0,
      1,
      1,
      1.543179,
      1,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      6,
      1,
      4,
      7,
      0,
      6.218300,
      7,
      11.956003,
      8,
      7.866977,
      1,
      2,
      10.300944,
      2,
      1.098217,
      4,
      2.193190,
      3.138335,
      7,
      7.518848,
      NULL,
      11,
      7.045528,
      0.523457,
      ' 2-23-1984',
      687,
      ' 0-18-1998',
      NULL,
      2,
      5,
      NULL,
      6.706454,
      1.379156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.766648,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220532,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483839,
      1,
      0.603559,
      1.217994,
      0.435275,
      0.517872,
      3.958061,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397461,
      1,
      1,
      2.654915,
      1.904018,
      1,
      1,
      2.900405,
      40.867320,
      NULL,
      1,
      174.565008,
      NULL,
      11,
      2,
      1.791991,
      3,
      NULL,
      NULL,
      2,
      1.151669,
      1.894728,
      0,
      3,
      NULL,
      2.091262,
      0.575789,
      3.777006,
      NULL,
      0.350617,
      NULL,
      151.709586,
      0,
      66.544242,
      NULL,
      194.637243,
      NULL,
      0,
      0.099475,
      0,
      NULL,
      1.014143,
      1,
      1.534016,
      NULL,
      NULL,
      NULL,
      7,
      3.666660,
      1,
      1.000267,
      NULL,
      3,
      0.875456,
      4.358121,
      3.573369,
      3,
      0.797013,
      42.503767,
      0,
      0.444838,
      NULL,
      12,
      31,
      41,
      1,
      0,
      3.867952,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      2,
      '0414',
      '32220',
      '',
      2,
      NULL,
      28,
      14.961786,
      0,
      1.798025,
      1.229100,
      108,
      8,
      2.439167,
      NULL,
      2.471582,
      1.064954,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.424426,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.225925,
      NULL,
      NULL,
      1.476112,
      2,
      1.069839,
      1.628149,
      NULL,
      NULL,
      NULL,
      0.862301,
      0,
      2.720242,
      0,
      3.192894,
      3,
      1,
      0.648383,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.458436,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977648,
      NULL,
      NULL,
      NULL,
      1.377368,
      3,
      2.333628,
      3,
      NULL,
      NULL,
      1.322920,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.408660,
      NULL,
      1,
      NULL,
      3.632583,
      0.222529,
      3.522824,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.996629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.672457,
      0,
      9.611300,
      0.245897,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      2.776060,
      3,
      3,
      1.100176,
      2,
      0.941584,
      NULL,
      NULL,
      6.859237,
      1.270778,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      4.381236,
      2.192406,
      0.951526,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850428,
      NULL,
      NULL,
      2.929515,
      1,
      1.996443,
      3.265714,
      0,
      NULL,
      8.500964,
      2.924845,
      0.814970,
      2.044340,
      4,
      0.001482,
      NULL,
      NULL,
      NULL,
      3,
      0.930738,
      2.288417,
      1,
      2,
      NULL,
      NULL,
      0,
      0.661209,
      NULL,
      7.047771,
      4.425830,
      2.294255,
      NULL,
      2,
      NULL,
      1,
      1.022373,
      1.962470,
      2,
      0,
      1,
      NULL,
      0.609649,
      8,
      NULL,
      0.809605,
      11,
      1.945579,
      4.744846,
      2.489594,
      NULL,
      NULL,
      1,
      0.216102,
      0,
      1.775997,
      0,
      1.038001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341137,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.074889,
      NULL,
      NULL,
      1.214166,
      NULL,
      NULL,
      0.656109,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1.181107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      90,
      NULL,
      NULL,
      NULL,
      0.164880,
      NULL,
      NULL,
      NULL,
      1.811367,
      NULL,
      NULL,
      NULL,
      0.672829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607203,
      NULL,
      NULL,
      NULL,
      0.575551,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232242,
      NULL,
      NULL,
      NULL,
      0,
      393,
      373,
      0.946977,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.151360,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.237089,
      NULL,
      1,
      106,
      NULL,
      0.819193,
      1,
      0,
      NULL,
      1,
      0,
      1.537172,
      1,
      0.199376,
      0,
      NULL,
      1,
      0.754902,
      0,
      NULL,
      1,
      0.004812,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.657068,
      NULL,
      NULL,
      NULL,
      1.707884,
      NULL,
      3.849583,
      4.281901,
      2.509912,
      1.871738,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.219641,
      NULL,
      0,
      2.515677,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.034743,
      1.052063,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.350014,
      NULL,
      1.054992,
      1,
      NULL,
      3.485964,
      1.986294,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.425376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295637,
      NULL,
      1.755360,
      NULL,
      0,
      NULL,
      NULL,
      2.754269,
      10.782756,
      0.321167,
      1,
      NULL,
      54,
      4.302971,
      0,
      NULL,
      NULL,
      '24003',
      '',
      '',
      1.375807,
      '',
      NULL,
      '',
      NULL,
      '1213',
      NULL,
      '');
commit;
end;
/


