set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7821767';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '1441212',
      3.113089,
      0,
      0,
      0,
      '2431',
      1.486642,
      2,
      4.352598,
      9,
      '11-13-1993',
      11,
      NULL,
      4,
      1,
      0.655226,
      ' 7- 7-1989',
      NULL,
      0,
      314.478634,
      118.477423,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      19,
      3,
      NULL,
      5,
      3,
      NULL,
      2.266072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.722714,
      1,
      1.430547,
      0,
      NULL,
      0.675003,
      NULL,
      1.772265,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.141475,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.217280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.186595,
      NULL,
      1.538192,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0.716332,
      0.483023,
      NULL,
      NULL,
      0.030415,
      NULL,
      1.895595,
      1.935247,
      0,
      NULL,
      1.523144,
      4,
      0.016843,
      0,
      1.493108,
      1.826291,
      1.175792,
      5,
      0,
      NULL,
      1.082545,
      0,
      0.488103,
      3.170251,
      1.232780,
      1,
      3.167048,
      5,
      6,
      0.905741,
      NULL,
      4.944275,
      3.034733,
      2.756708,
      NULL,
      0.520910,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.323819,
      1.460276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.771071,
      NULL,
      1.684296,
      0,
      0.245436,
      1.333148,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.766884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.887225,
      3.344426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.816874,
      0,
      0.787625,
      0,
      1,
      1.310208,
      1,
      0,
      NULL,
      2,
      1.406877,
      NULL,
      NULL,
      NULL,
      2.113782,
      0.560656,
      0,
      3.970433,
      1,
      2.220554,
      0,
      NULL,
      1,
      NULL,
      3.036165,
      1,
      2,
      NULL,
      NULL,
      0.999361,
      3,
      0.584038,
      0,
      1.090777,
      NULL,
      1,
      0,
      0.007968,
      1.844735,
      NULL,
      0.862159,
      1.933876,
      0.019362,
      NULL,
      2.821360,
      0.133115,
      10.719099,
      9,
      2.781223,
      5,
      6,
      1.813168,
      5,
      NULL,
      7,
      2,
      3.880555,
      1,
      17,
      1,
      1,
      8.558855,
      NULL,
      NULL,
      NULL,
      2.917327,
      0,
      2,
      NULL,
      '',
      '',
      1.648757,
      '',
      NULL,
      NULL,
      0.147861,
      '',
      '',
      '',
      3.536806,
      7.604360,
      80,
      22.958656,
      3.995900,
      30,
      1.715405,
      0,
      0.698353,
      1.165573,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0.158183,
      1,
      NULL,
      NULL,
      2.874796,
      1.748444,
      1,
      0.442414,
      NULL,
      NULL,
      0.670253,
      1,
      1.300437,
      1.379772,
      NULL,
      NULL,
      1,
      NULL,
      1.646480,
      1.412834,
      NULL,
      NULL,
      8.600868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.153462,
      1,
      1.727694,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      2.269479,
      16.751128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.651080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.760570,
      1,
      0.233779,
      3.745331,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.485584,
      2,
      2,
      NULL,
      NULL,
      NULL,
      3.685307,
      1.209048,
      0,
      NULL,
      1.615491,
      0,
      0,
      NULL,
      NULL,
      0.943028,
      0,
      1.902675,
      NULL,
      NULL,
      NULL,
      1.595437,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665905,
      NULL,
      NULL,
      1.097139,
      NULL,
      NULL,
      1.855704,
      NULL,
      NULL,
      0.049042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.013979,
      3.670052,
      2.244788,
      NULL,
      NULL,
      7.664507,
      NULL,
      1.095833,
      0,
      3.101725,
      NULL,
      0.689686,
      NULL,
      NULL,
      1.106212,
      NULL,
      NULL,
      2,
      1.844065,
      0,
      NULL,
      1,
      1.699873,
      7.322499,
      2,
      NULL,
      3.365466,
      2.010830,
      NULL,
      NULL,
      NULL,
      1.924616,
      NULL,
      NULL,
      NULL,
      1.222878,
      1.586827,
      NULL,
      5.024269,
      NULL,
      0.522274,
      5,
      1,
      3.640293,
      3.455914,
      NULL,
      5,
      0,
      1,
      0.927483,
      0.110734,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193946,
      NULL,
      NULL,
      1.229230,
      NULL,
      NULL,
      2.537957,
      NULL,
      NULL,
      2.028698,
      NULL,
      NULL,
      0.282802,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.490904,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      0.450063,
      2,
      1,
      1,
      0.178360,
      1,
      2.587713,
      1,
      NULL,
      NULL,
      2,
      3,
      NULL,
      856.463927,
      1899.804607,
      3.413337,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.766629,
      0.475809,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846706,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.111474,
      NULL,
      0.688009,
      1.445541,
      NULL,
      NULL,
      1.918082,
      0.767035,
      1.445919,
      NULL,
      0.974357,
      1,
      0.100031,
      NULL,
      1.425353,
      3.333192,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      0.977951,
      2.124762,
      NULL,
      1,
      NULL,
      0.302047,
      NULL,
      1.324906,
      1.509504,
      1.054700,
      NULL,
      0.256680,
      1.741326,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      11.610895,
      1.782693,
      1,
      NULL,
      0.573017,
      NULL,
      0,
      7,
      2,
      NULL,
      16,
      0.502251,
      NULL,
      NULL,
      0,
      NULL,
      0.945544,
      1.045960,
      NULL,
      NULL,
      3.667368,
      4,
      0,
      1.647166,
      NULL,
      NULL,
      0.387798,
      27,
      NULL,
      2473,
      NULL,
      1.759499,
      1.031105,
      NULL,
      1.757066,
      1.419937,
      0,
      0.460615,
      0.022040,
      1,
      NULL,
      1.329144,
      1.255037,
      0,
      0,
      1,
      NULL,
      0.201007,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      6.306370,
      16.661301,
      2,
      0.403445,
      NULL,
      NULL,
      0.301165,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.026608,
      NULL,
      1.173775,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677139,
      NULL,
      NULL,
      1.486516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.501920,
      3.408803,
      NULL,
      1,
      0,
      3.445078,
      5.036794,
      0.098153,
      NULL,
      1,
      1.074306,
      1.547250,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      0,
      0,
      0,
      1,
      1.388917,
      NULL,
      1,
      3.376833,
      0.709006,
      NULL,
      2,
      0,
      0.223046,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1.582090,
      1,
      NULL,
      1,
      0.522479,
      0,
      1,
      2.547747,
      0.666146,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.754311,
      0.583331,
      0.307365,
      0.356648,
      NULL,
      1.748695,
      NULL,
      NULL,
      NULL,
      NULL,
      56,
      57.520541,
      6.832458,
      NULL,
      0.458716,
      '22001',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


