set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7913233';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1,
      '1122',
      NULL,
      0,
      NULL,
      NULL,
      ' 6- 6-1976',
      57.100488,
      NULL,
      5.906986,
      3,
      1,
      ' 1-15-1989',
      24,
      2,
      171.748908,
      6,
      3,
      ' 5- 7-1996',
      '10- 4-1985',
      '11-10-1989',
      2,
      1.548235,
      NULL,
      3.312867,
      1,
      0.185584,
      2,
      0.037964,
      NULL,
      NULL,
      NULL,
      7.169098,
      1,
      12,
      19,
      0.835538,
      8.449212,
      3,
      0.047741,
      0.940721,
      1.480458,
      NULL,
      NULL,
      NULL,
      1.176338,
      1,
      1,
      1.855835,
      0.016884,
      5.698980,
      NULL,
      1,
      3,
      1.477494,
      1.211012,
      7.134343,
      0,
      0.599506,
      0,
      0.906064,
      0.158826,
      5,
      0,
      1,
      1.129863,
      NULL,
      1,
      3.098575,
      0,
      1.739681,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.861293,
      NULL,
      NULL,
      0,
      2.602976,
      2.833209,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013314,
      1.624992,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.347919,
      NULL,
      0.649901,
      1,
      1.757879,
      NULL,
      1.143312,
      0,
      1.894054,
      NULL,
      1.768537,
      NULL,
      NULL,
      0,
      NULL,
      0.972985,
      NULL,
      NULL,
      2.578308,
      0.005444,
      NULL,
      3,
      NULL,
      4,
      6.984517,
      NULL,
      6.383019,
      2.740946,
      1,
      4,
      NULL,
      NULL,
      5,
      1,
      7.585579,
      5,
      3,
      NULL,
      6.666869,
      3.459987,
      0,
      2.718114,
      2.178082,
      1.290670,
      0.295653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.680765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587830,
      1.245759,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391070,
      1.480312,
      4,
      NULL,
      NULL,
      0,
      0.752123,
      NULL,
      NULL,
      NULL,
      0.392051,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169489,
      1,
      0,
      0,
      0.094452,
      0.655648,
      0.823027,
      1,
      1497,
      0,
      1.897829,
      NULL,
      NULL,
      NULL,
      1,
      0.945936,
      NULL,
      2,
      NULL,
      2,
      2,
      2.539594,
      3,
      2.724644,
      0.480039,
      0.426402,
      NULL,
      0,
      NULL,
      2.425676,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.703363,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      7,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.245482,
      0.070626,
      3,
      NULL,
      NULL,
      78,
      67,
      3,
      1,
      2.397884,
      '40124',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      3.967889,
      26.602037,
      126,
      38.470241,
      NULL,
      14,
      36,
      NULL,
      5.839717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.774265,
      0,
      NULL,
      NULL,
      NULL,
      0.214118,
      2,
      1,
      2.030368,
      3.108466,
      1,
      0,
      NULL,
      NULL,
      3.072626,
      2.042112,
      0,
      1,
      NULL,
      NULL,
      0.847138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.669523,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.955373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288825,
      NULL,
      NULL,
      2,
      2.590179,
      1,
      0.775609,
      NULL,
      NULL,
      NULL,
      3.123968,
      1.581399,
      9,
      NULL,
      3.253398,
      1.909800,
      1.507328,
      0,
      NULL,
      1.075679,
      0.632028,
      6.591775,
      1.120925,
      NULL,
      1.415717,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.232475,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.372995,
      NULL,
      3,
      1.988134,
      5.438748,
      5,
      NULL,
      7.058837,
      10.033300,
      1.679760,
      3,
      0,
      1.158742,
      3.457383,
      2.894651,
      NULL,
      2.269511,
      3.279686,
      2.356904,
      1.438660,
      NULL,
      NULL,
      0.693103,
      NULL,
      0.721048,
      1.247163,
      1.731506,
      0,
      NULL,
      0.321439,
      1,
      0.675402,
      0,
      1.994575,
      1,
      3,
      3.845878,
      5,
      6.036312,
      NULL,
      5.752412,
      1,
      5.223297,
      8.780173,
      1,
      NULL,
      1,
      NULL,
      0.537673,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915380,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.001458,
      NULL,
      NULL,
      0.265731,
      NULL,
      NULL,
      1.192718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252275,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.755919,
      0.491729,
      0.244724,
      0.868991,
      3,
      0.663169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477562,
      NULL,
      NULL,
      0.488158,
      1.273099,
      NULL,
      NULL,
      1.417890,
      0.637407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.211270,
      0.862201,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      0.634408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.289146,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      NULL,
      0.174747,
      NULL,
      NULL,
      NULL,
      1.240238,
      341.791435,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      189.596054,
      53,
      0.598418,
      NULL,
      1.003246,
      1.599977,
      0.152023,
      0,
      0.965746,
      2.050653,
      1,
      NULL,
      0.534101,
      1,
      0.190974,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.801133,
      2.044846,
      1.571475,
      0.699299,
      NULL,
      NULL,
      1,
      1.387233,
      NULL,
      40,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.792465,
      3.925801,
      NULL,
      1.652794,
      0.318520,
      NULL,
      1.117322,
      0,
      NULL,
      0,
      1.117963,
      0.535189,
      0,
      NULL,
      NULL,
      2,
      0,
      0.053305,
      1.781117,
      1.639958,
      3.385203,
      1.621388,
      1,
      0.366345,
      1,
      1.763187,
      1.450265,
      NULL,
      0.520991,
      0,
      1,
      3,
      0.306692,
      NULL,
      NULL,
      2,
      NULL,
      0.217600,
      NULL,
      64.873295,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.754356,
      NULL,
      0.433454,
      NULL,
      1.193922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.021827,
      NULL,
      6,
      NULL,
      1,
      NULL,
      0.086340,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.283299,
      NULL,
      0.999195,
      NULL,
      287.759016,
      NULL,
      NULL,
      NULL,
      2.998786,
      NULL,
      NULL,
      NULL,
      0,
      1.247352,
      3.958332,
      NULL,
      2.731083,
      NULL,
      1.953515,
      NULL,
      16,
      NULL,
      1.758799,
      NULL,
      1,
      NULL,
      1.157504,
      NULL,
      0,
      0,
      2,
      NULL,
      2.169886,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.466476,
      NULL,
      NULL,
      NULL,
      1.444386,
      NULL,
      30,
      NULL,
      8,
      0.153199,
      0.971785,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      783,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.016044,
      1,
      3.456510,
      0,
      NULL,
      1.027898,
      0.225933,
      2,
      2,
      0,
      0.183900,
      NULL,
      1.513352,
      1,
      3,
      2.105801,
      4,
      5.085120,
      1.417916,
      NULL,
      2.706361,
      0,
      NULL,
      1.985341,
      0.081483,
      1,
      0.285573,
      0.053130,
      3.105812,
      0.341589,
      1.239228,
      NULL,
      0,
      1,
      2,
      1.781192,
      NULL,
      2,
      3.468594,
      NULL,
      2.269887,
      3.278886,
      0,
      0,
      1,
      1.241692,
      1,
      1.794803,
      1.038812,
      NULL,
      NULL,
      0,
      3,
      2,
      0.149892,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.494887,
      NULL,
      0.661624,
      NULL,
      NULL,
      NULL,
      1.332538,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.782946,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.308067,
      23.856524,
      3,
      NULL,
      0,
      0.027962,
      1.720583,
      2,
      NULL,
      NULL,
      0,
      0.232482,
      NULL,
      2,
      2,
      1,
      18.744877,
      16,
      4.437930,
      NULL,
      4.546481,
      '20341',
      '32221',
      '02333',
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


