set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9317219';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      0.251879,
      1.730048,
      2,
      NULL,
      '1424',
      3,
      1,
      NULL,
      NULL,
      ' 4- 6-1980',
      8,
      NULL,
      4,
      0.098211,
      0,
      '10-22-1993',
      12,
      3.700585,
      50.944105,
      NULL,
      NULL,
      '11-11-1991',
      NULL,
      ' 9-13-1975',
      1.450081,
      NULL,
      2.489910,
      3.906178,
      0,
      0.852749,
      2.920782,
      0,
      0.724863,
      9,
      0.140620,
      NULL,
      7.539679,
      25.402563,
      19,
      2,
      10,
      2.205426,
      6,
      4,
      0,
      4.368078,
      0.191757,
      1.748884,
      0,
      NULL,
      0,
      NULL,
      1.888474,
      NULL,
      0.791659,
      2,
      1,
      0,
      NULL,
      6.420605,
      0.405529,
      3.767735,
      0.579598,
      0.489581,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      4.639252,
      0.268433,
      3,
      NULL,
      1,
      0.314741,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      0.969208,
      0,
      1.078259,
      NULL,
      NULL,
      3.033877,
      NULL,
      2,
      2,
      1,
      1,
      NULL,
      3.686027,
      1,
      NULL,
      3.545686,
      1.630517,
      1,
      0.812561,
      0.538135,
      NULL,
      7.710593,
      1.773387,
      1,
      1.893056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610644,
      1,
      3,
      1,
      2,
      NULL,
      1.650785,
      0.397033,
      0.792937,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1.989953,
      1,
      1.514955,
      NULL,
      1,
      0.156051,
      1,
      NULL,
      0,
      1,
      0,
      4.446355,
      2.334533,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      1,
      8,
      7.977069,
      8.966226,
      8.498323,
      4,
      NULL,
      8,
      8.845731,
      NULL,
      5.271323,
      2.591675,
      0,
      ' 6-10-1981',
      3.201134,
      NULL,
      12.105079,
      0,
      1.315534,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.761552,
      0.813083,
      0.430175,
      1.254477,
      0.237138,
      0.649931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2.642266,
      2,
      NULL,
      1,
      0,
      NULL,
      0.650553,
      5.380001,
      2,
      1,
      2.507443,
      3.442665,
      1.988803,
      0,
      0,
      1.917158,
      5.184405,
      5,
      0,
      1.916509,
      NULL,
      1.910255,
      NULL,
      NULL,
      2,
      0,
      1.529962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.374121,
      NULL,
      1.096213,
      1,
      1,
      0.831708,
      0,
      60,
      1.720928,
      1,
      NULL,
      NULL,
      NULL,
      2.034382,
      3,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      1.705750,
      0.291369,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999503,
      1,
      1.680745,
      1,
      0.076078,
      1,
      0.496472,
      1.541166,
      0.367257,
      1.970606,
      1,
      2,
      0,
      NULL,
      NULL,
      10.566158,
      3.707921,
      0.360301,
      7,
      NULL,
      7.168538,
      5,
      NULL,
      5,
      0,
      2.340839,
      NULL,
      63,
      0,
      0,
      NULL,
      26.236960,
      NULL,
      67.677924,
      3.613405,
      0.849445,
      5.384012,
      '23134',
      '41134',
      '',
      1.213873,
      '',
      '',
      '',
      1.215103,
      '',
      '',
      '',
      1,
      39,
      13,
      1,
      2.687587,
      15,
      1,
      3.397912,
      4.727927,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      1.877833,
      NULL,
      NULL,
      0.882691,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.630318,
      0,
      1.325782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.163781,
      1,
      3,
      0.698656,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.832690,
      2.343845,
      0.009901,
      1,
      NULL,
      NULL,
      NULL,
      0.628630,
      0,
      2.980898,
      1,
      NULL,
      3,
      3.803205,
      1,
      NULL,
      2.023510,
      1,
      0,
      0,
      0.524873,
      1,
      2.142512,
      1,
      3.182190,
      1,
      NULL,
      NULL,
      2.202886,
      1.606321,
      1.287747,
      0,
      NULL,
      NULL,
      9,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.771323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.794780,
      3,
      0.446967,
      NULL,
      NULL,
      3.026720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.102812,
      NULL,
      NULL,
      1.373455,
      NULL,
      NULL,
      0.758686,
      NULL,
      NULL,
      1.471859,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.000197,
      NULL,
      NULL,
      NULL,
      NULL,
      2.559326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      5.510631,
      0.297935,
      NULL,
      NULL,
      1.289342,
      0.634076,
      NULL,
      2.707239,
      1.062464,
      0,
      3,
      1,
      0,
      4.603036,
      0,
      8,
      NULL,
      0,
      0,
      2.030834,
      NULL,
      1.585707,
      1.877999,
      0,
      NULL,
      3,
      0,
      3,
      NULL,
      0,
      0.848471,
      3.354920,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.381999,
      1.378525,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.283990,
      NULL,
      NULL,
      0.214559,
      NULL,
      NULL,
      1.642993,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.509833,
      1.324428,
      3,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      19.489351,
      NULL,
      NULL,
      NULL,
      1.913207,
      NULL,
      NULL,
      0.796122,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.894102,
      NULL,
      NULL,
      NULL,
      2.174361,
      NULL,
      NULL,
      NULL,
      3.789648,
      0,
      NULL,
      NULL,
      0.293828,
      0.539572,
      NULL,
      NULL,
      1.035992,
      1.447996,
      NULL,
      NULL,
      0.470721,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0.475340,
      NULL,
      NULL,
      1.454203,
      0.884291,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      6,
      2.746420,
      NULL,
      NULL,
      NULL,
      6,
      2.799298,
      1.284105,
      3,
      5.787554,
      4.212261,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.445420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002453,
      NULL,
      NULL,
      0,
      NULL,
      1,
      315.072552,
      7,
      NULL,
      1.837800,
      0,
      3,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.691231,
      1,
      2,
      1,
      1.049410,
      0.881835,
      0,
      0.372042,
      1,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2.066356,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      38,
      NULL,
      5,
      18,
      49,
      3.239817,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.504973,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.865630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606640,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.787890,
      2.850777,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.523029,
      1.990445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.587023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.553973,
      NULL,
      1.301175,
      NULL,
      0,
      NULL,
      1.507632,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.067184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524639,
      1.670881,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.398760,
      0.049744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410381,
      0.141940,
      3,
      3,
      0.659222,
      1,
      NULL,
      0,
      0.561016,
      2,
      2.986148,
      NULL,
      NULL,
      1.413038,
      0,
      0.680977,
      1.327941,
      NULL,
      0.189857,
      0,
      0.836099,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      1.388508,
      1.120554,
      0.542712,
      NULL,
      0.295019,
      1.351776,
      0,
      NULL,
      1,
      NULL,
      3.972660,
      3.456810,
      1,
      0,
      1.359581,
      0,
      0.070242,
      1,
      1.136427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.914409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.944342,
      0.521070,
      1.472947,
      NULL,
      NULL,
      4,
      NULL,
      0.858583,
      NULL,
      NULL,
      38.512765,
      95.914939,
      3,
      1.158874,
      5,
      '04232',
      '22041',
      '',
      1.121349,
      '',
      '',
      '',
      1.429786,
      '',
      '',
      NULL);
commit;
end;
/


