set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8603761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '2012342',
      1,
      0.261410,
      2,
      2,
      NULL,
      2,
      0.626923,
      NULL,
      NULL,
      ' 0-29-2001',
      2,
      NULL,
      3.136307,
      NULL,
      0,
      '11-10-1979',
      NULL,
      1,
      221.088138,
      NULL,
      2,
      NULL,
      ' 7- 1-1985',
      NULL,
      3,
      2,
      NULL,
      0.022162,
      1,
      3,
      3.682465,
      1.470224,
      1.361633,
      4.477602,
      6,
      4,
      2.328263,
      65,
      100.901710,
      1.903133,
      32.030810,
      5,
      3.765843,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.453460,
      5.114123,
      0.381654,
      1,
      0.884311,
      1,
      0,
      NULL,
      1,
      1.636528,
      NULL,
      1.882142,
      0,
      0.659126,
      NULL,
      3.924532,
      0.159114,
      2,
      0.112045,
      2.029415,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.221443,
      NULL,
      0.354162,
      0.460991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940948,
      NULL,
      7.372103,
      7,
      NULL,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.886677,
      NULL,
      1,
      1,
      0,
      8,
      0,
      0,
      0.445494,
      0.195377,
      4.843702,
      4,
      1,
      6,
      0,
      0.476440,
      0,
      1.821980,
      0,
      NULL,
      0.865251,
      1.822960,
      NULL,
      4,
      1,
      7.666006,
      NULL,
      NULL,
      1.020244,
      1,
      1,
      0.545110,
      NULL,
      5,
      0.325229,
      1,
      3,
      1.621931,
      0,
      3,
      5.194355,
      1,
      NULL,
      3.708218,
      1.103621,
      0,
      0.204203,
      0.197325,
      NULL,
      1313,
      ' 2- 9-1980',
      1745,
      0.260578,
      0,
      0,
      2.546489,
      0.768904,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079734,
      6,
      1.491452,
      2.100817,
      2,
      0.767329,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.690092,
      0.170800,
      1,
      2,
      NULL,
      0.373515,
      5,
      0.455641,
      1,
      1,
      1,
      6,
      1,
      NULL,
      NULL,
      NULL,
      1.381624,
      4,
      0.858586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.414060,
      3.673258,
      1,
      NULL,
      3,
      0,
      NULL,
      2.016803,
      16,
      3.153896,
      0.616942,
      NULL,
      NULL,
      NULL,
      2.687551,
      0.328971,
      NULL,
      0.820989,
      2,
      3.079285,
      NULL,
      3,
      0,
      3.084189,
      3,
      2.094094,
      0,
      NULL,
      NULL,
      1.277591,
      2.563916,
      0.062706,
      0,
      2.904885,
      1.808938,
      1,
      NULL,
      1,
      0.204748,
      1,
      1,
      NULL,
      0.552142,
      0.120227,
      2.822045,
      0,
      3.211675,
      8.211331,
      1,
      NULL,
      NULL,
      3,
      5.327507,
      1,
      2.146768,
      0,
      3.890755,
      1.382686,
      NULL,
      1.270166,
      2.807876,
      NULL,
      31,
      34.455964,
      16.786666,
      5,
      1,
      NULL,
      NULL,
      '',
      NULL,
      0.904750,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      22,
      109,
      NULL,
      2,
      8,
      10,
      24.976535,
      1,
      2,
      NULL,
      1.136013,
      1.736976,
      NULL,
      NULL,
      2.210368,
      NULL,
      2,
      NULL,
      1,
      1.644984,
      0,
      0,
      3.538146,
      0.673517,
      2.772765,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.817821,
      1,
      2,
      1.221531,
      1,
      NULL,
      0.731490,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.235879,
      1.549635,
      5,
      1,
      NULL,
      1,
      1.069336,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.430564,
      1.519673,
      1,
      1.141810,
      2,
      1.415196,
      0,
      NULL,
      NULL,
      0,
      0.698121,
      0.842478,
      2,
      0.621049,
      1,
      0.920119,
      NULL,
      2,
      2.444735,
      2,
      1,
      1,
      1,
      0.201049,
      NULL,
      2,
      1.817246,
      1,
      3,
      0,
      1,
      NULL,
      3,
      2.871709,
      NULL,
      1,
      1.413225,
      2.745575,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.987822,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      6.466869,
      1,
      NULL,
      NULL,
      2.282584,
      3,
      2,
      NULL,
      1,
      8,
      5.783268,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.433875,
      NULL,
      NULL,
      1.102599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.057504,
      1,
      0,
      2.603786,
      0,
      5,
      2.691035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.385417,
      3.435333,
      1.684226,
      NULL,
      3.838659,
      1,
      2,
      2,
      1.857678,
      NULL,
      1,
      0.113498,
      NULL,
      NULL,
      1.498825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.304613,
      9,
      NULL,
      0.460528,
      0,
      6,
      1,
      0.724523,
      0.573211,
      1,
      1.243034,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.719553,
      NULL,
      NULL,
      0.816086,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.314089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.441845,
      NULL,
      NULL,
      3.463063,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.601438,
      NULL,
      NULL,
      3.382078,
      NULL,
      NULL,
      1.783616,
      NULL,
      NULL,
      6.022806,
      NULL,
      NULL,
      1,
      NULL,
      0.554655,
      1.953403,
      1,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.201428,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218723,
      NULL,
      NULL,
      NULL,
      0.146407,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      315.486783,
      7,
      3,
      21,
      0.566212,
      1,
      NULL,
      NULL,
      3,
      4.624526,
      1,
      1.432263,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.054944,
      NULL,
      4370,
      130,
      0,
      NULL,
      0.507132,
      1.718857,
      NULL,
      1.769341,
      1.743529,
      3.094879,
      NULL,
      NULL,
      0.424678,
      0.934617,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.977934,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.942047,
      3,
      0,
      0.128296,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.055999,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0.797309,
      NULL,
      1,
      0.600126,
      NULL,
      1.652128,
      0,
      NULL,
      0,
      1.015358,
      NULL,
      3,
      NULL,
      1.704703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680870,
      0,
      NULL,
      0.143736,
      3,
      22.154775,
      17.477059,
      5.230536,
      NULL,
      3.110945,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


