set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8622293';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      1.308221,
      0,
      1,
      3,
      NULL,
      3.350866,
      0.066342,
      NULL,
      NULL,
      ' 5-18-1998',
      53,
      NULL,
      5,
      2,
      1.716615,
      ' 8-23-1994',
      24.095124,
      2,
      323.454186,
      8,
      NULL,
      ' 9-19-1975',
      NULL,
      ' 5- 4-1985',
      0,
      2,
      NULL,
      0.550120,
      0.178868,
      2.791460,
      0,
      NULL,
      1,
      39.480737,
      5,
      9.835173,
      1,
      NULL,
      10,
      7.726442,
      7,
      1.611904,
      4.984863,
      0.629740,
      0,
      1.906611,
      0.059662,
      1.101392,
      1,
      1,
      NULL,
      1,
      1.341428,
      1.872714,
      NULL,
      NULL,
      6.143809,
      5.193914,
      2.103842,
      6,
      NULL,
      0,
      4.737379,
      0,
      NULL,
      0.650632,
      0,
      1.220330,
      NULL,
      0,
      1.901088,
      4.441000,
      NULL,
      5.870238,
      0,
      1.593799,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      0,
      0.278461,
      1,
      1,
      1.496194,
      2.603065,
      NULL,
      0,
      1.384808,
      3.726354,
      NULL,
      1,
      2.535305,
      1.187072,
      2.607331,
      1.205313,
      NULL,
      1,
      0.923409,
      1.001435,
      5,
      2.858055,
      NULL,
      1,
      3.104349,
      NULL,
      NULL,
      NULL,
      0.006391,
      NULL,
      NULL,
      3,
      NULL,
      9,
      1,
      6.453268,
      9,
      NULL,
      0,
      3,
      6,
      1.555422,
      0,
      1.213189,
      0.021099,
      1,
      1,
      0,
      0.982170,
      1,
      NULL,
      NULL,
      0.160343,
      8,
      1.706490,
      1,
      0,
      2.013743,
      1.725343,
      0,
      5,
      1.321110,
      4,
      5,
      NULL,
      6.758005,
      0.401276,
      NULL,
      5,
      1.307757,
      7,
      4,
      6.859041,
      4,
      3,
      6,
      7.046981,
      NULL,
      2,
      NULL,
      NULL,
      ' 4-24-1980',
      NULL,
      NULL,
      0.290571,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.532102,
      NULL,
      1.053277,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.202737,
      1.573475,
      3.868884,
      2.313742,
      NULL,
      NULL,
      NULL,
      1,
      7.165716,
      1,
      1.671355,
      1,
      1,
      0.482316,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.452496,
      1.000839,
      0.065240,
      0,
      1,
      2.802400,
      0.614859,
      1.878806,
      325.861984,
      0.098186,
      0.184212,
      NULL,
      NULL,
      NULL,
      3,
      1.956557,
      0,
      1.445416,
      3,
      0.085941,
      3.137269,
      2.322105,
      NULL,
      2.852960,
      1.892594,
      2.210955,
      1.457300,
      NULL,
      2,
      NULL,
      4.771635,
      0,
      0,
      7.999354,
      0,
      0.263280,
      NULL,
      NULL,
      1.599348,
      0,
      NULL,
      NULL,
      0,
      1,
      0.608641,
      1,
      5.400212,
      1,
      5,
      4.128058,
      NULL,
      3.510280,
      0.583234,
      0.763460,
      6.375526,
      1.107562,
      2.036812,
      3,
      NULL,
      0.155183,
      1.162475,
      NULL,
      62.273402,
      NULL,
      12.438761,
      NULL,
      1,
      1.417280,
      '34044',
      '44312',
      '',
      NULL,
      '21133',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      36.432059,
      86,
      9,
      0.597291,
      NULL,
      3,
      48.603400,
      7,
      1.566757,
      1.729292,
      2,
      1.094289,
      NULL,
      NULL,
      1.316100,
      NULL,
      NULL,
      3.457010,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.824180,
      NULL,
      NULL,
      NULL,
      1.264357,
      NULL,
      NULL,
      0.305815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      6.927908,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.233445,
      0,
      0,
      0,
      NULL,
      NULL,
      0.300797,
      NULL,
      NULL,
      0,
      3,
      0.702454,
      NULL,
      NULL,
      0.530979,
      NULL,
      0,
      1,
      0.743210,
      NULL,
      1,
      0.127914,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.578202,
      0.494926,
      0,
      1,
      6.934804,
      4.989132,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.531793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.931583,
      NULL,
      NULL,
      NULL,
      2.544312,
      0.510254,
      NULL,
      NULL,
      3.988193,
      7.763139,
      11,
      2,
      0.477420,
      0.732863,
      0.236477,
      NULL,
      NULL,
      7,
      7.031428,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.046437,
      NULL,
      NULL,
      1.432493,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.055958,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.218646,
      NULL,
      NULL,
      9,
      2.199971,
      NULL,
      NULL,
      7,
      6,
      0.461893,
      NULL,
      7.613991,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.428499,
      1.870794,
      1.162546,
      2.092876,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0.636213,
      NULL,
      2.640573,
      11.345587,
      11,
      9,
      7,
      8,
      4,
      1,
      NULL,
      3,
      1.724089,
      1,
      0.768237,
      1.864971,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204485,
      NULL,
      NULL,
      1.070217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169069,
      NULL,
      NULL,
      1.742362,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.599249,
      NULL,
      NULL,
      1.963257,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.126051,
      2.874408,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879122,
      NULL,
      NULL,
      NULL,
      0.295025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.354291,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455851,
      NULL,
      NULL,
      NULL,
      0.476718,
      NULL,
      NULL,
      NULL,
      2.769966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      34.358014,
      NULL,
      7,
      2.524478,
      0,
      NULL,
      NULL,
      3,
      3.634480,
      0,
      1.593218,
      1.029501,
      0.762578,
      3,
      11.788845,
      1,
      1.680069,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.146023,
      0.710458,
      NULL,
      1,
      NULL,
      0.551872,
      3.212827,
      0.658458,
      3.660033,
      1.917953,
      0.768430,
      1.471287,
      0,
      0.714049,
      0.961092,
      1.703523,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      12.388860,
      NULL,
      NULL,
      12.327122,
      18,
      1.338813,
      0,
      NULL,
      NULL,
      1.714480,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.551766,
      NULL,
      1.837704,
      NULL,
      1.245057,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      3.279401,
      NULL,
      0.670855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.752313,
      1,
      NULL,
      1.851997,
      NULL,
      0.792154,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.787248,
      0.714443,
      2,
      NULL,
      0.247476,
      NULL,
      0.238957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.750493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592649,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.695365,
      3.986030,
      NULL,
      1,
      NULL,
      3,
      NULL,
      487,
      NULL,
      2.678651,
      NULL,
      1.413148,
      NULL,
      NULL,
      1.396005,
      2.767918,
      13,
      20,
      1,
      NULL,
      NULL,
      NULL,
      1.620441,
      2.585557,
      NULL,
      5,
      NULL,
      4,
      NULL,
      3,
      2.834367,
      0,
      0,
      1,
      1,
      1.704217,
      NULL,
      0.670716,
      1.800943,
      NULL,
      NULL,
      0,
      NULL,
      0.207533,
      1.076520,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010507,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1.916489,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.126678,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564274,
      NULL,
      0,
      NULL,
      1.962308,
      NULL,
      9.863411,
      10.529496,
      5,
      2,
      NULL,
      NULL,
      12.785342,
      17,
      0.211590,
      1,
      NULL,
      '20042',
      '21230',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


