set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132604';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '4024123',
      1.117861,
      1.086367,
      0,
      NULL,
      '1220',
      3.902958,
      NULL,
      0,
      NULL,
      ' 2- 6-1995',
      72.114117,
      NULL,
      5,
      2.456819,
      1,
      ' 7-13-1978',
      63.382232,
      NULL,
      279,
      43.638972,
      5,
      NULL,
      NULL,
      NULL,
      0,
      0.969669,
      NULL,
      0.630908,
      NULL,
      3,
      11.745808,
      NULL,
      1,
      NULL,
      10,
      7.686567,
      2,
      13.800562,
      1,
      9.748117,
      13.257576,
      5,
      NULL,
      NULL,
      1,
      1,
      0.642037,
      NULL,
      0,
      0.322214,
      1,
      0,
      1,
      0,
      169.022775,
      5,
      NULL,
      4,
      NULL,
      1,
      0,
      1.435341,
      1,
      0,
      0,
      0,
      1,
      3.052220,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.692698,
      0,
      NULL,
      0.070503,
      0.990623,
      NULL,
      1.115914,
      NULL,
      1.131354,
      1,
      0,
      1.894663,
      0,
      1.471431,
      NULL,
      0.344871,
      1,
      1,
      1.553808,
      1.145962,
      1,
      1.267927,
      NULL,
      0.700772,
      1.198971,
      1,
      NULL,
      NULL,
      1.729520,
      NULL,
      NULL,
      0.585001,
      0.676940,
      7,
      0,
      4.668817,
      5.863194,
      1,
      5.353721,
      5,
      NULL,
      0.778543,
      NULL,
      0,
      4.412895,
      1.374654,
      1.801700,
      1,
      NULL,
      0.264434,
      NULL,
      NULL,
      2,
      3,
      3,
      5,
      NULL,
      4.574985,
      3,
      NULL,
      4.768206,
      5.127958,
      NULL,
      0,
      2.360250,
      1,
      1.929098,
      5,
      7,
      2,
      1.690155,
      0,
      1.759060,
      0.707579,
      3,
      6.076222,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1.746256,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298974,
      NULL,
      NULL,
      NULL,
      NULL,
      0.482892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.592795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460147,
      NULL,
      0,
      NULL,
      1.388228,
      1.864021,
      1.193035,
      NULL,
      NULL,
      NULL,
      1.582227,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205432,
      0,
      NULL,
      1,
      0.985841,
      0.149416,
      2,
      801.011245,
      2.292015,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.882172,
      2,
      0.256546,
      3,
      3,
      4,
      2.732360,
      NULL,
      1.514439,
      3,
      1.040213,
      0,
      0.374740,
      NULL,
      2,
      0.521637,
      0,
      6.466474,
      0.241315,
      2,
      NULL,
      1.136046,
      0,
      2.701071,
      1,
      0.475415,
      4.716098,
      12,
      NULL,
      0,
      NULL,
      0,
      0.028903,
      0,
      NULL,
      1.158669,
      4,
      2,
      6,
      3.176996,
      1.722758,
      0,
      20,
      0.257542,
      1.027853,
      64,
      NULL,
      NULL,
      NULL,
      4,
      1.303825,
      1.427922,
      '02120',
      '',
      NULL,
      1.234276,
      '',
      '',
      '',
      3,
      '4332',
      '',
      '',
      1.022787,
      32,
      NULL,
      37.168732,
      1.465496,
      46,
      NULL,
      92.338916,
      1.519933,
      3.185828,
      0,
      0,
      1.452890,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      2,
      1,
      1.406328,
      NULL,
      NULL,
      3,
      0,
      1.110598,
      1.126101,
      3.986294,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.647038,
      NULL,
      NULL,
      1.676292,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      5,
      NULL,
      3.969236,
      1.833251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541318,
      2,
      0.503909,
      1.173606,
      NULL,
      0,
      0,
      0.407719,
      1,
      NULL,
      0,
      1.258625,
      0.133551,
      2,
      NULL,
      3.288871,
      0.233125,
      NULL,
      1,
      NULL,
      0.446293,
      1,
      0,
      0,
      0.334248,
      NULL,
      NULL,
      NULL,
      0.977474,
      NULL,
      NULL,
      1,
      NULL,
      1.241720,
      NULL,
      10,
      1,
      0.604502,
      1.193806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.550717,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      8.294014,
      5,
      NULL,
      3,
      0,
      1.396780,
      0,
      NULL,
      NULL,
      1,
      1.587408,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018493,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.815772,
      NULL,
      NULL,
      1.074020,
      NULL,
      NULL,
      1.943988,
      3,
      1.279601,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.478013,
      4.380518,
      3.954587,
      11,
      1.207547,
      3.958643,
      0.982476,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.499699,
      0.076343,
      0,
      5.271414,
      2,
      1,
      2.904649,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      2.855363,
      1.578398,
      3,
      0.699135,
      1,
      3.444472,
      0.124267,
      6.898032,
      2.274666,
      NULL,
      0.053926,
      2.018734,
      1.933088,
      9.189180,
      NULL,
      1,
      0,
      1,
      0,
      0.056077,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154056,
      NULL,
      NULL,
      0.984648,
      NULL,
      NULL,
      1.165710,
      NULL,
      NULL,
      2.574077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127757,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370549,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.046526,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.871408,
      1.231991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.275010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.726489,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0,
      0.695528,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      763.817209,
      NULL,
      0,
      NULL,
      NULL,
      1.016982,
      NULL,
      NULL,
      2,
      115.177451,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.349929,
      1,
      NULL,
      1,
      NULL,
      0.724348,
      0,
      1.481204,
      0.627532,
      1.905546,
      1.995896,
      1.494921,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2.297200,
      NULL,
      0,
      1.325961,
      1.843633,
      1.263972,
      1.940354,
      NULL,
      4,
      NULL,
      0,
      NULL,
      11,
      NULL,
      3.155566,
      0.880133,
      NULL,
      14,
      13.167238,
      2,
      3.385480,
      1.560023,
      3.886372,
      3.171810,
      1.950520,
      0.299999,
      NULL,
      1,
      NULL,
      0.213129,
      0.148092,
      NULL,
      3.042363,
      2,
      2,
      3,
      3,
      NULL,
      3.168741,
      0.212496,
      3.226198,
      3.617165,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.726690,
      1,
      0,
      NULL,
      0,
      NULL,
      5,
      2.671301,
      1.135965,
      1,
      NULL,
      51,
      64,
      5,
      NULL,
      1,
      '30041',
      '',
      NULL,
      1.762203,
      '',
      '',
      '',
      NULL,
      '3230',
      '3030',
      '0342');
commit;
end;
/


