set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0141275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      3,
      3.753725,
      NULL,
      NULL,
      1,
      NULL,
      '124',
      '3',
      20.982166,
      NULL,
      NULL,
      NULL,
      1.044494,
      6,
      2,
      '4311',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      32.550622,
      NULL,
      NULL,
      0.020174,
      ' 5-12-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      4.870842,
      NULL,
      NULL,
      ' 9-20-1998',
      2.491906,
      1,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      0.476929,
      0.766020,
      NULL,
      17,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267580,
      1.533609,
      NULL,
      NULL,
      0.102869,
      NULL,
      1,
      0,
      1,
      1,
      1.421366,
      1,
      0.000510,
      1.474227,
      3.276837,
      3,
      4,
      2.870876,
      NULL,
      1.643190,
      1.026404,
      3.795232,
      0.682978,
      3.824999,
      8,
      3.328754,
      0,
      1.691508,
      0,
      1,
      5,
      1,
      1.368434,
      2.465734,
      0.632109,
      NULL,
      NULL,
      NULL,
      1.476566,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.334537,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      5,
      NULL,
      NULL,
      3,
      2,
      1.019726,
      0,
      0,
      1.547491,
      NULL,
      1.415630,
      3,
      NULL,
      NULL,
      0,
      0.765193,
      1,
      NULL,
      0.558792,
      0,
      0,
      2,
      0.278914,
      NULL,
      0,
      0.219700,
      NULL,
      0,
      1.458151,
      5.592767,
      1.720006,
      0,
      0.524109,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      9,
      4.272174,
      7,
      6,
      6.133188,
      0,
      ' 2- 3-1981',
      NULL,
      ' 2-11-1987',
      26.211530,
      2,
      2.300981,
      0.288568,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.902311,
      1.430359,
      0.238042,
      NULL,
      0.013916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.784703,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0.299584,
      1.449183,
      NULL,
      1.256320,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931201,
      0.039504,
      0.928723,
      3,
      0,
      0.310375,
      1.097714,
      1,
      23,
      0.638777,
      1.738659,
      NULL,
      NULL,
      NULL,
      3,
      0.446585,
      3.873954,
      3,
      1.860610,
      2,
      3.186137,
      3.620456,
      3.366372,
      1,
      NULL,
      2,
      2,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293895,
      0.355071,
      1,
      NULL,
      NULL,
      0.908900,
      1.755553,
      2.962547,
      1,
      10,
      7.158900,
      2,
      5,
      2,
      7,
      2,
      0.378085,
      NULL,
      3,
      0.553042,
      0.416816,
      NULL,
      2.368420,
      1,
      20,
      NULL,
      NULL,
      NULL,
      1.943736,
      2.433329,
      2,
      '30013',
      '',
      NULL,
      1.230194,
      NULL,
      NULL,
      '',
      1,
      '22132',
      '',
      '',
      NULL,
      38.288379,
      6,
      52.547373,
      0.947282,
      42.560502,
      NULL,
      0.752564,
      0.380136,
      0,
      0,
      3.676950,
      0,
      NULL,
      NULL,
      0.284697,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.703780,
      3,
      2.963806,
      NULL,
      3,
      1.114906,
      NULL,
      NULL,
      0.252489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.646803,
      NULL,
      NULL,
      4,
      3,
      2.974984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.631902,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291400,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2,
      NULL,
      NULL,
      2,
      NULL,
      4.285637,
      4.625962,
      0,
      3.600260,
      2.065328,
      2,
      2,
      0.507933,
      NULL,
      4.693030,
      4,
      5.073283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109572,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119664,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2.405733,
      5,
      2.328299,
      3.674590,
      2.491690,
      1.285512,
      3,
      1.373020,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      3.124362,
      1.328397,
      3,
      0.391668,
      1,
      NULL,
      2,
      0,
      0,
      NULL,
      0.495656,
      3,
      0.031747,
      3,
      NULL,
      3.632633,
      1.667663,
      1.565363,
      3.383117,
      5,
      3.659291,
      4.854502,
      NULL,
      NULL,
      6,
      1,
      2.784530,
      1.175482,
      NULL,
      NULL,
      0.464374,
      1,
      1,
      2.087043,
      NULL,
      NULL,
      0.252431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993388,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.704788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.357272,
      0,
      NULL,
      0.702667,
      0.133117,
      0.796967,
      NULL,
      NULL,
      NULL,
      0.663714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.497230,
      NULL,
      NULL,
      NULL,
      0.003245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850144,
      NULL,
      NULL,
      NULL,
      1.416834,
      NULL,
      NULL,
      NULL,
      1.252457,
      NULL,
      NULL,
      NULL,
      0.028531,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.550731,
      NULL,
      NULL,
      NULL,
      1.431360,
      NULL,
      NULL,
      NULL,
      2.965121,
      17.662765,
      3,
      1,
      3,
      1.704528,
      0.766483,
      NULL,
      NULL,
      2.500115,
      1,
      1.271860,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.896204,
      NULL,
      1,
      15,
      13,
      NULL,
      0,
      1,
      0.472040,
      1,
      1.533011,
      1.063491,
      1.116143,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0.415845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.653188,
      NULL,
      1.559814,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.585780,
      NULL,
      0.636553,
      NULL,
      1.803318,
      NULL,
      0,
      0.406174,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.182513,
      1.416443,
      1.015587,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.519389,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493404,
      1,
      0,
      1,
      1.122015,
      1.324868,
      0.086489,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.202682,
      NULL,
      0,
      2.465661,
      NULL,
      0,
      0.837558,
      NULL,
      0,
      2,
      NULL,
      1.413057,
      1,
      NULL,
      1,
      1.075120,
      NULL,
      NULL,
      0,
      NULL,
      0.630664,
      0.386128,
      NULL,
      0.880068,
      0,
      NULL,
      NULL,
      0.030836,
      NULL,
      0,
      NULL,
      1.004577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449356,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.473357,
      1,
      2,
      NULL,
      NULL,
      NULL,
      30.349723,
      80.658067,
      5.408525,
      2.052191,
      0,
      '34401',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      2,
      '20201',
      '',
      '');
commit;
end;
/


