set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8530746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '2104200',
      3.902874,
      1,
      3,
      2,
      NULL,
      2.209041,
      0.476139,
      NULL,
      NULL,
      '11- 5-1997',
      17.974832,
      NULL,
      1,
      3,
      0.724516,
      ' 8-23-1974',
      35.033720,
      1.325627,
      347,
      10,
      2,
      ' 5-28-2002',
      ' 9-15-1997',
      NULL,
      NULL,
      0,
      2,
      1,
      1.498291,
      3.681590,
      1.473619,
      0.603411,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      21,
      NULL,
      NULL,
      5,
      6,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.353654,
      1,
      3.437973,
      1.120423,
      0,
      5.475056,
      NULL,
      6,
      1,
      2,
      0.916566,
      7.853192,
      1.234051,
      0,
      1.318366,
      4,
      NULL,
      0.472607,
      NULL,
      0.968118,
      0.966417,
      NULL,
      NULL,
      1.559878,
      4,
      NULL,
      0.539574,
      0,
      1.518396,
      3,
      NULL,
      NULL,
      0.224331,
      3.627407,
      0.247169,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.546842,
      1,
      NULL,
      1.579156,
      1,
      NULL,
      1,
      NULL,
      3,
      3,
      0,
      1.652119,
      NULL,
      NULL,
      NULL,
      NULL,
      2.838232,
      2,
      0,
      NULL,
      4.794721,
      NULL,
      3.592455,
      3,
      3.920612,
      0.041836,
      0.387039,
      2,
      4.037143,
      1.984899,
      0.802352,
      6.941799,
      1.962686,
      1.990462,
      0.793315,
      NULL,
      0,
      NULL,
      0,
      4.475043,
      NULL,
      0.002580,
      8,
      0,
      4.793169,
      5,
      0,
      6,
      4,
      5,
      7.390915,
      NULL,
      0,
      NULL,
      8.125331,
      9.017739,
      7.123027,
      2.025722,
      5,
      11,
      NULL,
      7,
      8.766373,
      3.204342,
      NULL,
      NULL,
      ' 7-29-1974',
      159,
      ' 6-29-1990',
      NULL,
      0.528451,
      3,
      1,
      NULL,
      1.270110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.154327,
      0,
      1,
      1.020413,
      NULL,
      2.499265,
      3.696906,
      1.927394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      8.400932,
      1,
      0.210966,
      3.470376,
      0.550314,
      1.346086,
      3.835685,
      2.693511,
      NULL,
      4,
      0,
      2.738728,
      1,
      2.708343,
      2,
      8.010404,
      1.805599,
      7,
      NULL,
      NULL,
      0.496037,
      2.768030,
      0.930391,
      NULL,
      NULL,
      0.459046,
      5.908067,
      2,
      4.440006,
      NULL,
      1.618547,
      6.750998,
      ' 5- 7-1982',
      60.273981,
      ' 5-24-1975',
      NULL,
      1,
      0.248328,
      NULL,
      0,
      1.945427,
      0.430765,
      2,
      0,
      1,
      1,
      1.038966,
      1.540177,
      0.054260,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      3,
      0,
      0.606199,
      1.307837,
      2.330186,
      3,
      0,
      0.191670,
      1,
      2.176525,
      1,
      2.009998,
      0,
      3.942779,
      NULL,
      1.187852,
      1,
      NULL,
      NULL,
      0.621177,
      0.690377,
      NULL,
      1.432555,
      NULL,
      1.784165,
      0.327601,
      0.603576,
      5.074869,
      1,
      5.090912,
      5.423124,
      3,
      1.226138,
      1,
      6,
      0,
      3,
      4.145053,
      0,
      1.355915,
      1,
      44.297012,
      NULL,
      2,
      NULL,
      NULL,
      4.444455,
      NULL,
      1,
      0.080381,
      NULL,
      '42024',
      '',
      NULL,
      NULL,
      '23432',
      NULL,
      '',
      NULL,
      NULL,
      '13210',
      '',
      1.820341,
      NULL,
      NULL,
      NULL,
      1,
      39,
      3.412461,
      0,
      2,
      NULL,
      0,
      0.339070,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.971029,
      NULL,
      NULL,
      0.777156,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1.221705,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.600294,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406824,
      1.934633,
      0.666634,
      NULL,
      NULL,
      NULL,
      0,
      1.018844,
      1.931240,
      NULL,
      1,
      NULL,
      NULL,
      0.145719,
      NULL,
      NULL,
      0.106614,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.517993,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.190059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800024,
      NULL,
      NULL,
      0.540058,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.732306,
      2.800495,
      1.861513,
      0,
      1.694986,
      NULL,
      NULL,
      6,
      3.976746,
      NULL,
      4.651410,
      3,
      0.847550,
      NULL,
      NULL,
      1,
      NULL,
      0.296398,
      0,
      NULL,
      0.533548,
      1.701533,
      0.299552,
      0,
      3.763531,
      3.156300,
      1.089404,
      1,
      NULL,
      NULL,
      NULL,
      1.891748,
      3,
      0,
      2.157742,
      0.667779,
      1.788268,
      3,
      2.347514,
      3.727904,
      6,
      2.930809,
      4.551163,
      3.672644,
      4,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.007625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.866687,
      1,
      NULL,
      NULL,
      8.016971,
      NULL,
      NULL,
      NULL,
      26.785749,
      NULL,
      NULL,
      NULL,
      2.781040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.474425,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.542172,
      NULL,
      NULL,
      NULL,
      3.386458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403115,
      NULL,
      1.136475,
      1.241910,
      2,
      0.758802,
      2,
      4,
      2.324490,
      3,
      6,
      3.810619,
      1.066014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.967082,
      NULL,
      1.889285,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      41,
      0.237059,
      0.934037,
      1.424940,
      0.610871,
      0.507006,
      1.279913,
      1,
      1.062621,
      0,
      1.427926,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0.357995,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.924844,
      0.328293,
      1.565384,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1.060318,
      1,
      0.262944,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.454846,
      1,
      NULL,
      1.265880,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674086,
      NULL,
      NULL,
      0.646208,
      NULL,
      NULL,
      0.076477,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.646149,
      NULL,
      0.661549,
      NULL,
      3.322488,
      NULL,
      0,
      NULL,
      1.929796,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.749536,
      NULL,
      2,
      NULL,
      0.444678,
      NULL,
      NULL,
      1.622996,
      NULL,
      1.735288,
      NULL,
      1.597979,
      NULL,
      1.035938,
      NULL,
      1.090273,
      3,
      3,
      NULL,
      NULL,
      NULL,
      5,
      109.432252,
      1,
      NULL,
      4.688342,
      '13024',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      1.959595,
      '03021',
      '03310',
      NULL);
commit;
end;
/


