set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7007504';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '0424021',
      2.727366,
      1.634302,
      3,
      3,
      '1212',
      3.117617,
      0.136538,
      NULL,
      NULL,
      ' 5-18-1995',
      69.692544,
      NULL,
      5,
      NULL,
      0,
      ' 7- 6-1975',
      16,
      3,
      1203.086428,
      1992,
      3,
      ' 1- 3-1986',
      ' 0- 1-2000',
      ' 9- 0-1983',
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.907257,
      8,
      32.976631,
      10.084397,
      3,
      NULL,
      3,
      3.960068,
      2,
      0.031594,
      NULL,
      1.101365,
      0,
      1,
      1.825850,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      5,
      0.616689,
      1.927583,
      1.869351,
      0.225778,
      1,
      1.363305,
      1.563249,
      0.636783,
      7.485867,
      0,
      NULL,
      0.920189,
      0.811324,
      1.553108,
      3.619827,
      0.483389,
      0,
      0.367928,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.962675,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712295,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.276677,
      8,
      0,
      1,
      4,
      5.142486,
      0.266009,
      1.824184,
      NULL,
      0.834606,
      NULL,
      0,
      7.922093,
      1.252368,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1.336848,
      NULL,
      0,
      1,
      0.692479,
      1.985578,
      0,
      NULL,
      NULL,
      0.927320,
      0.807532,
      1,
      1.598812,
      5,
      1,
      7,
      0.144177,
      2,
      1,
      NULL,
      3,
      0,
      2,
      0,
      0.926687,
      0,
      0.804296,
      ' 9- 4-1992',
      1794,
      ' 4-29-1983',
      820.879418,
      0,
      0.983375,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.534703,
      1,
      1.106944,
      0.904193,
      0.828759,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1.734376,
      NULL,
      1.420752,
      0.491745,
      0.571484,
      NULL,
      NULL,
      NULL,
      0.618249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.636203,
      1.889060,
      1.315680,
      0.575847,
      0.009713,
      1.836476,
      NULL,
      56,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.982917,
      0.340344,
      3.237982,
      0.002535,
      1,
      0,
      1,
      NULL,
      3.556146,
      3.971459,
      3,
      1.458510,
      2,
      NULL,
      19,
      NULL,
      124.685807,
      NULL,
      52,
      168,
      NULL,
      NULL,
      0,
      1.441820,
      0,
      0,
      0,
      1,
      13,
      2,
      0,
      8,
      3.868909,
      6,
      4.648141,
      0.441325,
      4,
      5,
      NULL,
      5,
      2.679788,
      3,
      3.244807,
      40,
      2,
      2.610332,
      NULL,
      48.179871,
      13.114861,
      33,
      5,
      0,
      2,
      '21114',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0.360678,
      NULL,
      '',
      '',
      3.701483,
      16,
      339.657647,
      7,
      1,
      42,
      9.590858,
      NULL,
      7,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.484484,
      NULL,
      NULL,
      2.268411,
      1.312501,
      1.881610,
      1,
      NULL,
      NULL,
      1.483630,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.218109,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.041017,
      NULL,
      NULL,
      1.610896,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.728434,
      NULL,
      NULL,
      0.119715,
      NULL,
      NULL,
      1.069662,
      NULL,
      NULL,
      1.750783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649820,
      NULL,
      NULL,
      0.980422,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.494166,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.639177,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.625922,
      3,
      1,
      NULL,
      2.542297,
      1,
      1,
      NULL,
      NULL,
      8,
      NULL,
      1,
      1,
      3,
      2.985310,
      0,
      NULL,
      NULL,
      2,
      4,
      1.264448,
      0.888681,
      NULL,
      NULL,
      1.900283,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.420112,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.435187,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.918432,
      NULL,
      NULL,
      7.497252,
      4.342245,
      4.243637,
      1.641175,
      3,
      4.979015,
      1.303391,
      2.551681,
      2,
      0,
      NULL,
      NULL,
      0.280685,
      NULL,
      NULL,
      6,
      1.151886,
      NULL,
      1,
      2,
      2.812750,
      NULL,
      0.595125,
      NULL,
      3.846631,
      1.862756,
      NULL,
      1,
      0.154602,
      3.868373,
      0.139873,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.696574,
      NULL,
      0.099723,
      NULL,
      1.278823,
      0,
      NULL,
      0.658527,
      3.982043,
      NULL,
      NULL,
      1.288584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496639,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.245357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331395,
      0,
      0,
      0.839666,
      0.721486,
      3.624181,
      NULL,
      NULL,
      NULL,
      1.615551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.643439,
      NULL,
      NULL,
      NULL,
      1.744873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.405322,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      321.976644,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.124689,
      NULL,
      NULL,
      2,
      40,
      10.584786,
      1.996108,
      NULL,
      NULL,
      NULL,
      53.454023,
      1,
      2933.643026,
      1.908132,
      0,
      0.064932,
      0,
      1.710592,
      1,
      1.883729,
      0.101659,
      1.211802,
      1.854762,
      1,
      1,
      0,
      0.733956,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.623270,
      0,
      1.948342,
      1,
      NULL,
      1.966532,
      0,
      NULL,
      1.437866,
      0,
      NULL,
      1,
      0.889756,
      NULL,
      NULL,
      3.851112,
      NULL,
      1,
      0.363755,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.667677,
      0.039412,
      NULL,
      0.959734,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3.717558,
      NULL,
      1.342973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228942,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      15.029514,
      2,
      NULL,
      2.116427,
      17,
      3.327106,
      NULL,
      1.581180,
      2,
      '44444',
      '',
      NULL,
      1.236566,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


