set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8917132';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3222420',
      0.943881,
      0.753153,
      3,
      2,
      '4010',
      3.633931,
      0,
      NULL,
      NULL,
      ' 3-12-1992',
      21,
      NULL,
      5,
      0,
      3,
      NULL,
      NULL,
      NULL,
      46.606226,
      NULL,
      2,
      ' 6-11-2002',
      ' 7-24-1998',
      '11- 3-1986',
      1.964653,
      NULL,
      0,
      1,
      0.619938,
      3.106180,
      2,
      1,
      NULL,
      NULL,
      NULL,
      6.605617,
      5.804700,
      9.047053,
      19.736819,
      NULL,
      6,
      5,
      4,
      6,
      0.277074,
      NULL,
      1,
      0,
      1,
      0.262851,
      0.768329,
      1,
      1.035879,
      NULL,
      0,
      NULL,
      2,
      1,
      2,
      3,
      1,
      0.509768,
      1,
      0,
      3.649870,
      0.715148,
      1.613875,
      0,
      1.369058,
      1.528517,
      0,
      2.564389,
      0,
      3.300976,
      0,
      NULL,
      0.232810,
      NULL,
      NULL,
      1.265508,
      NULL,
      NULL,
      0,
      0.346883,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.634738,
      0.190701,
      0,
      1.219125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.777536,
      1.449027,
      1,
      NULL,
      1.772191,
      1.061996,
      2.185658,
      0,
      0,
      1,
      1,
      NULL,
      1.903193,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1.663573,
      0,
      NULL,
      0,
      0.697723,
      0,
      2.596666,
      NULL,
      4.629130,
      0.530320,
      NULL,
      NULL,
      0,
      NULL,
      0.171987,
      5,
      1.253730,
      3,
      3.423233,
      5.012488,
      1,
      2.265199,
      NULL,
      5,
      4,
      2,
      NULL,
      NULL,
      ' 9-11-1980',
      33.502658,
      ' 3-17-1982',
      9.496075,
      NULL,
      1.908112,
      NULL,
      6.629259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496290,
      NULL,
      2.633555,
      1.122937,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3.051197,
      NULL,
      0.743692,
      NULL,
      0.332864,
      0.075660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.870772,
      1,
      0,
      2,
      0,
      5.247600,
      0.597317,
      1,
      NULL,
      NULL,
      1.552805,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.221373,
      NULL,
      1,
      0.120527,
      0.935413,
      0.864224,
      2.995849,
      17,
      NULL,
      1.738876,
      NULL,
      NULL,
      NULL,
      3,
      0.734525,
      0.837743,
      3.838602,
      NULL,
      1,
      1,
      2.513558,
      0.267344,
      0.920524,
      0,
      NULL,
      NULL,
      2.436321,
      1.788719,
      0,
      3.280334,
      1.876220,
      1,
      3,
      1,
      0,
      0.508520,
      0.735309,
      0,
      1,
      1.789299,
      0.342129,
      1.298261,
      0.617040,
      NULL,
      0.491045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.344899,
      NULL,
      37.129674,
      17.051168,
      75,
      1.129896,
      1,
      NULL,
      '40300',
      NULL,
      '',
      1.534279,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      3.430209,
      29.343881,
      21,
      NULL,
      2.734215,
      1,
      2,
      0,
      4,
      NULL,
      3.947164,
      0.094261,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.606405,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.427835,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.596919,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.116491,
      0.241679,
      NULL,
      3,
      NULL,
      1.359609,
      1.319980,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738007,
      NULL,
      NULL,
      0.026160,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.038470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.349284,
      0,
      3.368874,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.410488,
      2,
      1.916695,
      1.860927,
      2.638888,
      0,
      1,
      NULL,
      NULL,
      3.105357,
      1.272080,
      1.987927,
      1,
      2.625558,
      NULL,
      NULL,
      NULL,
      1.515700,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.826795,
      NULL,
      NULL,
      1.216198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.148748,
      1,
      0,
      NULL,
      NULL,
      3,
      2.602998,
      0,
      2,
      1,
      NULL,
      3.398118,
      NULL,
      NULL,
      1.885745,
      NULL,
      NULL,
      3,
      3,
      1.071110,
      1,
      3.398516,
      0.842563,
      0,
      5.894762,
      1,
      NULL,
      3.253804,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      6.440378,
      1.674737,
      0,
      4.181463,
      NULL,
      NULL,
      NULL,
      1,
      0.534304,
      1,
      0,
      1,
      1,
      2,
      NULL,
      NULL,
      0.687557,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831458,
      NULL,
      NULL,
      1.002610,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1.341989,
      NULL,
      3,
      0.180225,
      NULL,
      3.765790,
      1,
      NULL,
      NULL,
      0.544895,
      NULL,
      3,
      1,
      NULL,
      2,
      0,
      NULL,
      12,
      1.947833,
      NULL,
      1,
      NULL,
      NULL,
      0.551720,
      0.380539,
      NULL,
      0,
      3.515415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.309128,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.876679,
      0.958455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639631,
      0,
      NULL,
      NULL,
      1.176068,
      0.477701,
      NULL,
      NULL,
      2.760360,
      1.916214,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.911429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.962492,
      0,
      NULL,
      NULL,
      2.939980,
      2.756966,
      NULL,
      NULL,
      1.835672,
      0,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3.265386,
      0.884590,
      NULL,
      NULL,
      12,
      6.509916,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.326239,
      43,
      1.268359,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.989453,
      NULL,
      NULL,
      3.632665,
      16.065372,
      NULL,
      0.898746,
      NULL,
      NULL,
      0.869816,
      NULL,
      1.579350,
      175,
      0.103102,
      NULL,
      0,
      0,
      3.723158,
      1,
      0,
      1,
      NULL,
      0.594333,
      2,
      1,
      NULL,
      NULL,
      0.439737,
      0,
      0,
      1,
      2.391980,
      NULL,
      3.478127,
      NULL,
      0.656560,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.901897,
      NULL,
      92,
      NULL,
      1.702307,
      12.474032,
      19,
      NULL,
      1.460430,
      NULL,
      NULL,
      0.400929,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.050359,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.761127,
      NULL,
      0.619894,
      NULL,
      1.806151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.875048,
      0,
      3.224112,
      3,
      3.388515,
      NULL,
      2,
      0,
      2,
      NULL,
      NULL,
      0.587199,
      0,
      0,
      1.875364,
      NULL,
      0.139550,
      1.751022,
      2.213565,
      0.106653,
      1.266576,
      1,
      NULL,
      3,
      2,
      1,
      1.456257,
      1,
      0,
      1,
      0.533926,
      3.922747,
      0.061882,
      3.766790,
      0.853856,
      0,
      0.203787,
      0,
      0,
      1,
      1.431348,
      0.156765,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975838,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0.332224,
      1.070832,
      1.612624,
      1,
      5,
      5,
      0.002492,
      NULL,
      NULL,
      67,
      88,
      2,
      NULL,
      2,
      '43200',
      '14132',
      '10141',
      NULL,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '');
commit;
end;
/


