set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5205713';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      0.544458,
      0,
      0,
      1,
      '3404',
      0,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1981',
      0.439895,
      NULL,
      NULL,
      NULL,
      0.583587,
      ' 9- 2-1988',
      88,
      5,
      NULL,
      NULL,
      NULL,
      '10- 5-1988',
      ' 5- 6-2001',
      ' 6-20-1975',
      3,
      0.341753,
      1.078996,
      1.797312,
      0.834568,
      2.210713,
      NULL,
      1,
      1.663028,
      837.422943,
      NULL,
      7.406708,
      4,
      2.680063,
      17.448815,
      NULL,
      3,
      7,
      3,
      9.492129,
      1.359639,
      1.122131,
      1.783712,
      0.780049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      25,
      5,
      NULL,
      3.744134,
      2.217132,
      6.293383,
      2,
      1,
      2,
      1.194543,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.699800,
      0.036802,
      5,
      0.277915,
      5,
      2,
      1.435105,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.863788,
      0,
      1.494359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.581254,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.913203,
      0.842215,
      NULL,
      1.254597,
      4,
      3,
      NULL,
      3,
      0.061661,
      NULL,
      1.418169,
      0.303125,
      0.502177,
      3.422101,
      1,
      NULL,
      0,
      0.367796,
      NULL,
      NULL,
      0,
      1,
      4.907132,
      NULL,
      3.667093,
      2.584712,
      6,
      1,
      0,
      0.525339,
      5,
      0,
      0,
      6.474013,
      8.344562,
      3,
      NULL,
      6,
      4.615026,
      1,
      1.245205,
      5,
      6,
      5,
      7,
      4,
      6.706011,
      3,
      NULL,
      NULL,
      ' 2- 5-1978',
      1366,
      3.131353,
      0,
      1.803247,
      NULL,
      0.964970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.665587,
      0,
      1.382802,
      2.178342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.246477,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856450,
      NULL,
      NULL,
      0.606299,
      NULL,
      1,
      NULL,
      NULL,
      14068.213790,
      0,
      NULL,
      NULL,
      289.879907,
      1274.199932,
      2.349636,
      1,
      0,
      0.172712,
      2.361305,
      1,
      2.667410,
      0,
      3.343293,
      0.942033,
      3,
      0.074141,
      3.953781,
      0,
      3.992794,
      NULL,
      0.597084,
      0.696970,
      1.452121,
      2.824350,
      0.568751,
      1.112978,
      NULL,
      0,
      1,
      1,
      0.391631,
      0.724037,
      1,
      NULL,
      NULL,
      1,
      4.249960,
      1,
      NULL,
      10.703579,
      6.105649,
      5,
      1.629275,
      NULL,
      7.225368,
      NULL,
      3,
      3,
      21.642226,
      NULL,
      0.614133,
      NULL,
      NULL,
      21,
      3.948426,
      1.577280,
      1.359377,
      1,
      NULL,
      '',
      '',
      0.351078,
      '',
      NULL,
      NULL,
      7,
      '32142',
      '33031',
      '31010',
      3.573644,
      NULL,
      NULL,
      NULL,
      1.172845,
      12.192499,
      1,
      552.266399,
      NULL,
      3.886406,
      NULL,
      1.705487,
      0.735097,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.732999,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299162,
      3.400783,
      2.545133,
      3.546433,
      0,
      NULL,
      NULL,
      1.793412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.096937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.799148,
      6,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.569036,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      1.905635,
      NULL,
      NULL,
      2.432979,
      1.989419,
      1.680930,
      3.423097,
      3.384968,
      1,
      2.573463,
      2,
      3.881676,
      0.711217,
      3,
      1.830471,
      0,
      1.689916,
      1.533584,
      0.794218,
      NULL,
      2,
      0,
      2,
      NULL,
      1.800194,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.949490,
      1,
      0.244155,
      1.133204,
      NULL,
      0.955453,
      0,
      2,
      1.664186,
      0.413995,
      NULL,
      NULL,
      NULL,
      2.736524,
      0,
      2,
      1,
      0.408151,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4,
      0.939854,
      NULL,
      NULL,
      0.546976,
      NULL,
      NULL,
      0.130730,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.253814,
      NULL,
      NULL,
      NULL,
      0.270030,
      NULL,
      2.361721,
      5,
      6,
      3,
      3.981633,
      5.593996,
      NULL,
      6,
      4,
      3.157110,
      3.444222,
      3,
      3,
      0,
      2,
      2.677869,
      0.476882,
      0.985423,
      4,
      NULL,
      2.941200,
      3,
      1,
      3.458758,
      NULL,
      NULL,
      NULL,
      2.342994,
      1.540656,
      1.902505,
      NULL,
      0,
      NULL,
      8,
      5,
      NULL,
      NULL,
      0.774056,
      NULL,
      1.328503,
      2.306894,
      2.136862,
      0.176801,
      0,
      NULL,
      0.558874,
      0.795840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683508,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.759354,
      1.520724,
      0.163338,
      0.434369,
      NULL,
      0.795937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.176021,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.740928,
      NULL,
      NULL,
      NULL,
      2.136115,
      NULL,
      NULL,
      NULL,
      1.371332,
      NULL,
      NULL,
      NULL,
      0.367079,
      407,
      NULL,
      0,
      NULL,
      NULL,
      0.177844,
      NULL,
      NULL,
      3.117421,
      151,
      77.580388,
      0.265449,
      NULL,
      NULL,
      0.774815,
      18,
      9,
      2.406283,
      5.560985,
      2,
      347.871933,
      15.514842,
      1.521188,
      NULL,
      0.295083,
      0.474842,
      1.759341,
      0,
      0,
      1,
      0,
      0.871331,
      1.149252,
      NULL,
      1,
      0.321386,
      1.753580,
      0.334963,
      NULL,
      0.101472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.816152,
      3.368337,
      11,
      1.285243,
      NULL,
      4,
      5,
      NULL,
      1,
      1,
      0,
      1.795166,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.957376,
      NULL,
      NULL,
      1.606755,
      NULL,
      NULL,
      0.400983,
      0,
      NULL,
      0.822907,
      1,
      NULL,
      1,
      2.613989,
      NULL,
      0,
      1.752856,
      NULL,
      1.137916,
      1.022378,
      NULL,
      0.262822,
      2,
      NULL,
      1,
      0,
      NULL,
      2.320576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.187285,
      NULL,
      1.554887,
      NULL,
      6.731459,
      12.256880,
      3,
      3.568679,
      0.621027,
      NULL,
      51.194211,
      20,
      2,
      NULL,
      NULL,
      '43110',
      '',
      '',
      1,
      NULL,
      '',
      '',
      6.315152,
      NULL,
      '20103',
      NULL);
commit;
end;
/


