set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829625';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3201200',
      NULL,
      NULL,
      4,
      0,
      '4331',
      NULL,
      2.001534,
      2,
      44,
      NULL,
      22.365305,
      NULL,
      3,
      NULL,
      7.457194,
      '10-13-2001',
      39.970996,
      1.900155,
      25.336377,
      130,
      1.378465,
      ' 0-26-1983',
      ' 0- 6-1998',
      ' 6-21-1978',
      0.129772,
      NULL,
      NULL,
      3.522944,
      1,
      2,
      NULL,
      2.501393,
      NULL,
      NULL,
      NULL,
      8.215564,
      3,
      14.760455,
      22,
      NULL,
      5,
      8.881875,
      7,
      1,
      0.051949,
      NULL,
      0.570741,
      0,
      1,
      1.881603,
      0,
      NULL,
      NULL,
      3,
      0.422580,
      NULL,
      1.406099,
      0,
      1.614673,
      9.746721,
      1,
      0,
      NULL,
      2,
      NULL,
      0,
      1.493801,
      NULL,
      NULL,
      1.409272,
      1.343063,
      9.247598,
      0.313479,
      0,
      3.811398,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.278521,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874803,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298196,
      5.522404,
      4,
      1,
      NULL,
      7,
      NULL,
      1.755937,
      NULL,
      1,
      0.264732,
      0.394207,
      0.157695,
      1.119528,
      1,
      0.560550,
      0.473905,
      0.239632,
      1,
      NULL,
      0.768121,
      1.777328,
      NULL,
      0.281792,
      2.598865,
      NULL,
      1,
      7.984340,
      4.738513,
      NULL,
      0.552091,
      1.766803,
      0,
      2.753405,
      3.458253,
      0,
      4.146361,
      4.814296,
      5,
      NULL,
      3.508102,
      NULL,
      2,
      4,
      5.043354,
      7.486194,
      6.141390,
      2,
      NULL,
      425,
      NULL,
      29.080353,
      1,
      1.201362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.198816,
      1.348087,
      0,
      2,
      1.524005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.969176,
      NULL,
      14.223797,
      2.327930,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.944876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.683127,
      NULL,
      2.852930,
      NULL,
      3,
      7.848914,
      0.623026,
      NULL,
      NULL,
      1,
      1.727288,
      0.167567,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.974287,
      NULL,
      3,
      0.705461,
      1,
      1.842780,
      1.061323,
      1.497387,
      77.636031,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      3,
      NULL,
      0.642120,
      2,
      2.560232,
      0.052112,
      1,
      1.172250,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.440460,
      0.370299,
      1.745718,
      5,
      NULL,
      0,
      NULL,
      0,
      0,
      0.820416,
      1.916520,
      0.669138,
      0.901942,
      1.700708,
      3,
      NULL,
      1,
      2.154355,
      7,
      7,
      9.976881,
      7,
      3.314761,
      NULL,
      NULL,
      0.965818,
      NULL,
      NULL,
      NULL,
      1.868591,
      NULL,
      NULL,
      63.303984,
      24,
      57,
      2.182019,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '34411',
      '',
      '',
      2,
      NULL,
      164.550067,
      40,
      2,
      NULL,
      2.594474,
      7,
      0.484731,
      NULL,
      1,
      2.488446,
      0.139337,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.781316,
      1,
      1,
      NULL,
      NULL,
      0.351385,
      NULL,
      NULL,
      3.017997,
      2,
      0.697673,
      NULL,
      NULL,
      NULL,
      0.309444,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.795682,
      NULL,
      NULL,
      0.439323,
      NULL,
      NULL,
      NULL,
      7.797032,
      1.703332,
      1,
      0.710086,
      NULL,
      NULL,
      NULL,
      1.301688,
      NULL,
      NULL,
      NULL,
      17.398937,
      NULL,
      NULL,
      0.804439,
      NULL,
      NULL,
      1.585995,
      NULL,
      NULL,
      0.664155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.775001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.358542,
      2.415657,
      3.333837,
      NULL,
      NULL,
      NULL,
      NULL,
      1.932410,
      NULL,
      3,
      1.678381,
      2,
      0.042021,
      1,
      NULL,
      NULL,
      NULL,
      5.269710,
      1,
      1.381868,
      NULL,
      NULL,
      0.053321,
      NULL,
      NULL,
      1.647847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.246504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863985,
      2,
      2.912736,
      4.340606,
      3.116317,
      3.248823,
      0,
      2.444130,
      NULL,
      0,
      1,
      0,
      1.919425,
      NULL,
      NULL,
      NULL,
      3.412217,
      1,
      3.614634,
      1,
      0.675857,
      NULL,
      1.025353,
      5.067091,
      3,
      NULL,
      1,
      0.323408,
      NULL,
      NULL,
      3.634959,
      2,
      1,
      3,
      NULL,
      2,
      NULL,
      2.373341,
      3.855375,
      NULL,
      NULL,
      4.069180,
      0,
      2,
      3,
      NULL,
      0.023222,
      0,
      1.110959,
      1.097274,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889190,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.844131,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      0,
      0,
      1.531175,
      1.787277,
      0.365282,
      1.825564,
      2,
      NULL,
      NULL,
      1,
      2.991522,
      NULL,
      NULL,
      10.320081,
      496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.538732,
      NULL,
      NULL,
      0.287806,
      NULL,
      NULL,
      NULL,
      2.522190,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.683663,
      2,
      NULL,
      NULL,
      NULL,
      0.826144,
      NULL,
      NULL,
      1.842322,
      0,
      NULL,
      NULL,
      0.917334,
      1.372581,
      NULL,
      NULL,
      1.404439,
      3,
      NULL,
      NULL,
      0.467487,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.276006,
      0,
      NULL,
      NULL,
      2.354604,
      2.951566,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.599324,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      11,
      8,
      NULL,
      NULL,
      3.235104,
      NULL,
      3.335297,
      3.853082,
      1.844484,
      11,
      1,
      NULL,
      0.503253,
      1,
      3,
      29,
      2,
      0.762096,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.699872,
      NULL,
      NULL,
      1.399948,
      NULL,
      0.311341,
      148.708594,
      0,
      NULL,
      1.115809,
      1,
      0,
      1.061926,
      1,
      0.725378,
      0.731351,
      0.513362,
      0.947122,
      1,
      1.548993,
      1,
      0,
      0,
      1.772446,
      0.350466,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.745537,
      NULL,
      1.488052,
      NULL,
      1.152126,
      NULL,
      1.099122,
      NULL,
      0.773879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225200,
      0.624536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416182,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182800,
      2.367089,
      NULL,
      2,
      NULL,
      1.950189,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.420819,
      NULL,
      0,
      NULL,
      0,
      0,
      1.476229,
      NULL,
      2,
      NULL,
      1.190660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580898,
      NULL,
      0.520307,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.863619,
      NULL,
      1.558435,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.876843,
      1.756915,
      NULL,
      1,
      NULL,
      0,
      NULL,
      326.678138,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      20,
      6,
      1,
      0.023491,
      3.244369,
      1.222800,
      NULL,
      3,
      NULL,
      7.087165,
      3.028900,
      5,
      3.334857,
      3.051662,
      NULL,
      3,
      3,
      NULL,
      1.525414,
      NULL,
      1.706624,
      2,
      3.902338,
      NULL,
      1.259198,
      3,
      3.068824,
      1.158251,
      1,
      NULL,
      3.770052,
      0.941032,
      3,
      0,
      2,
      0.464354,
      0,
      3.929492,
      0,
      3,
      1.677431,
      NULL,
      1.979403,
      2.028173,
      0.121621,
      1,
      3,
      1,
      0,
      0,
      1,
      3.364011,
      0.095824,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.940663,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.229990,
      NULL,
      3.030820,
      NULL,
      2,
      NULL,
      3.540832,
      NULL,
      NULL,
      NULL,
      NULL,
      1.952106,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133814,
      1.752857,
      1,
      3.604286,
      NULL,
      2.620420,
      2.498282,
      2,
      1,
      0,
      0.026737,
      2.965181,
      1,
      2,
      NULL,
      3.227436,
      3,
      3,
      1.863949,
      3.085834,
      3.592602,
      2.130843,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      3,
      NULL,
      NULL,
      3.139080,
      NULL,
      10.220909,
      0,
      3.887241,
      0,
      85,
      87,
      0.850177,
      1,
      NULL,
      '23102',
      '02433',
      NULL,
      2.832240,
      NULL,
      '',
      '',
      0,
      '21314',
      '',
      '');
commit;
end;
/


