set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8902037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '2433322',
      3,
      0.851842,
      0,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      ' 6- 2-1993',
      20,
      NULL,
      1,
      2.545611,
      1.189620,
      '10- 0-1986',
      2.684840,
      2.628834,
      314.803458,
      98,
      5.544272,
      NULL,
      NULL,
      ' 2-27-1982',
      1.892325,
      0,
      0.738984,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      32.730990,
      30,
      3,
      NULL,
      1.868431,
      1,
      0.798021,
      0,
      1.459368,
      NULL,
      0,
      NULL,
      1.768887,
      NULL,
      0,
      0.915517,
      3,
      1.849680,
      1.823073,
      3,
      2,
      1,
      2,
      0.946378,
      NULL,
      0.603907,
      1,
      1,
      0,
      0.859747,
      1,
      0.865136,
      1.120564,
      0,
      3,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.399032,
      NULL,
      NULL,
      4.323935,
      NULL,
      0,
      1,
      0.508673,
      1.328200,
      0,
      1.406933,
      0.742020,
      1,
      NULL,
      1,
      0.305717,
      1.466489,
      NULL,
      1.238366,
      1,
      1.805654,
      0,
      3.694077,
      5,
      0,
      5,
      0,
      1,
      0.825133,
      1.545902,
      NULL,
      NULL,
      1.495100,
      NULL,
      NULL,
      1,
      1.907131,
      2,
      0.557764,
      1.230009,
      NULL,
      2,
      NULL,
      0,
      4.347828,
      4,
      1,
      0.212893,
      3,
      0,
      1,
      0,
      0,
      1.179562,
      NULL,
      1.043843,
      1.218834,
      0,
      0.657389,
      0.530049,
      1,
      1.522674,
      0.841919,
      1.930995,
      0,
      3,
      0.658251,
      0,
      2.429098,
      3,
      1,
      3,
      6.627336,
      3.158353,
      7.520079,
      NULL,
      NULL,
      NULL,
      5.086225,
      2.445119,
      0.555402,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.564893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      4,
      2.689669,
      7,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.439746,
      1.745390,
      3.122098,
      2.358914,
      1,
      2.644530,
      0,
      1,
      0,
      NULL,
      NULL,
      1.664136,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.993084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      3,
      2,
      0.098535,
      0.159835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.245590,
      1,
      1,
      0,
      1.354100,
      0,
      3,
      1.076621,
      1,
      2.286294,
      NULL,
      0.643366,
      3,
      1,
      2.568170,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      0.363731,
      0,
      1,
      0.328599,
      0,
      1,
      0,
      0,
      3.102475,
      2.883252,
      3,
      6.662935,
      5,
      NULL,
      2,
      2.702014,
      NULL,
      NULL,
      2,
      1.959282,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.067225,
      1,
      1.962940,
      '43433',
      '',
      NULL,
      0.868020,
      '',
      '',
      NULL,
      0.375607,
      '',
      '',
      '',
      2.156093,
      32.135264,
      22.682148,
      24,
      NULL,
      NULL,
      NULL,
      4,
      3.403718,
      2.772044,
      2,
      0.557881,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.164394,
      3.584901,
      2.874368,
      0,
      NULL,
      NULL,
      3.760885,
      1.897040,
      0.965045,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.437597,
      5.902876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.716200,
      0.855925,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.424748,
      1,
      NULL,
      NULL,
      9.817051,
      NULL,
      1.892968,
      NULL,
      0.849922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.477145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782975,
      1.716856,
      0,
      NULL,
      NULL,
      2.518570,
      2.939630,
      0,
      2.681960,
      3,
      2,
      NULL,
      3,
      NULL,
      NULL,
      4.744984,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.486629,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.540180,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.015144,
      NULL,
      2.004478,
      1.725494,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      3,
      1,
      8,
      2.666196,
      3.612584,
      NULL,
      2.733486,
      0.304267,
      3.763022,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680097,
      0,
      1,
      1.431283,
      4.184294,
      4,
      4,
      4.083941,
      0.542937,
      1.832820,
      3.503500,
      2,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.517528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371640,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.773288,
      NULL,
      1,
      2.963608,
      1,
      3.011759,
      NULL,
      5,
      NULL,
      0.310989,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.118380,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.604534,
      NULL,
      3,
      NULL,
      1.005338,
      NULL,
      1,
      NULL,
      3.105293,
      NULL,
      0,
      NULL,
      3.844001,
      NULL,
      0.829745,
      NULL,
      0.688877,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      12.079892,
      NULL,
      2,
      NULL,
      NULL,
      2.911798,
      3.066866,
      3.649539,
      0,
      3.980984,
      34,
      1,
      2,
      2.932892,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      24,
      8,
      3.864972,
      NULL,
      6.283709,
      0.821098,
      NULL,
      0.173599,
      52,
      5.545354,
      1,
      1,
      1,
      0,
      0.168697,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      3.519443,
      0.543919,
      1.117243,
      0,
      0.050915,
      2,
      NULL,
      0.701493,
      NULL,
      0,
      0.239421,
      0,
      NULL,
      0.438894,
      0,
      0,
      0,
      NULL,
      0,
      0,
      1.208845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.623951,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988360,
      1.222074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.096137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.804669,
      2.749359,
      NULL,
      0.531801,
      NULL,
      0.390943,
      NULL,
      NULL,
      NULL,
      1.950218,
      NULL,
      1,
      NULL,
      0,
      0,
      0.595696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.962551,
      NULL,
      NULL,
      0,
      1,
      0.546855,
      3.858443,
      0,
      0.445623,
      0.368268,
      3.961623,
      NULL,
      1,
      1,
      0,
      1.673484,
      2.836901,
      1.281297,
      0,
      0.147262,
      0,
      1.470725,
      0.515841,
      0.023136,
      NULL,
      NULL,
      1.560636,
      NULL,
      0.693212,
      1.495258,
      1.621302,
      0,
      NULL,
      1,
      0.964350,
      1,
      1,
      1.374964,
      NULL,
      0.624325,
      0.306834,
      NULL,
      0,
      NULL,
      1.136623,
      NULL,
      0.723125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      2,
      1,
      5,
      1.240385,
      NULL,
      NULL,
      99,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


