set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7526922';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1982-1-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2412001',
      2,
      0,
      NULL,
      2,
      '4100',
      NULL,
      0,
      NULL,
      NULL,
      '10-18-1982',
      13,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      1004,
      1505,
      0,
      ' 8- 9-1982',
      '11-20-2003',
      ' 3- 1-1996',
      NULL,
      3,
      NULL,
      0.072855,
      0.995105,
      2.688209,
      2.791727,
      0,
      1,
      3.543675,
      4,
      16,
      NULL,
      58,
      NULL,
      5.623527,
      20.841021,
      0.090372,
      2,
      7.192945,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      1.914699,
      0,
      1,
      1,
      3.975098,
      NULL,
      NULL,
      1,
      0,
      1.347217,
      2,
      1.426237,
      4,
      1,
      6.827846,
      NULL,
      0,
      NULL,
      4,
      2,
      3.230952,
      1.574682,
      NULL,
      0.856169,
      NULL,
      NULL,
      NULL,
      NULL,
      0.663221,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.382540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325205,
      0.303322,
      0,
      3.512224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      2.638166,
      NULL,
      5.503909,
      0,
      1,
      6.990130,
      1,
      0,
      1.885986,
      5,
      NULL,
      0.191065,
      NULL,
      0.448600,
      1.339095,
      NULL,
      1.141992,
      0.437136,
      3,
      0.510032,
      NULL,
      1,
      3,
      0.169900,
      0.630800,
      1,
      0.529461,
      1.124499,
      1,
      5.567577,
      5.498105,
      0.681893,
      5,
      3,
      1,
      3,
      0,
      2,
      4.914563,
      NULL,
      0,
      1.006455,
      1.717056,
      NULL,
      NULL,
      351.871774,
      NULL,
      327,
      NULL,
      NULL,
      1,
      2.075959,
      0.394280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.758796,
      NULL,
      NULL,
      1.998916,
      NULL,
      NULL,
      1.307481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.511722,
      0.941567,
      9,
      0.215322,
      1.369960,
      NULL,
      NULL,
      NULL,
      0.415707,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.083445,
      1.836196,
      NULL,
      0,
      0.809720,
      1,
      NULL,
      7,
      3,
      0.027591,
      NULL,
      NULL,
      NULL,
      2.831886,
      0,
      1.952870,
      0.693805,
      NULL,
      3,
      1.786356,
      2,
      3,
      0,
      3,
      1.976786,
      3.871263,
      0.204168,
      0,
      0,
      0,
      3.078962,
      0.461506,
      1,
      0.867353,
      NULL,
      1,
      0,
      0.336786,
      1.586646,
      NULL,
      NULL,
      1,
      1,
      4,
      0.231314,
      0,
      NULL,
      3.761112,
      7,
      2.920682,
      7.599615,
      0.614805,
      1,
      7,
      3,
      NULL,
      NULL,
      40,
      1,
      0.027827,
      NULL,
      NULL,
      79,
      11.482820,
      3.614973,
      1,
      2,
      '43300',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.620192,
      '',
      '',
      '',
      2.286239,
      27,
      49.957909,
      NULL,
      0,
      7.033750,
      NULL,
      0.331348,
      1,
      0,
      1.100823,
      1.484274,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      NULL,
      NULL,
      0.460477,
      NULL,
      3.814891,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.480597,
      3,
      10,
      12,
      1,
      NULL,
      18.781891,
      NULL,
      0.103098,
      NULL,
      1,
      2,
      14.619967,
      0,
      2.230196,
      NULL,
      6.632111,
      NULL,
      3.195477,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9.271090,
      1.135247,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.767841,
      1,
      1,
      NULL,
      1.061922,
      1.759080,
      1,
      0.237483,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0.801302,
      0.717919,
      0,
      NULL,
      NULL,
      0.932409,
      NULL,
      NULL,
      0.945723,
      NULL,
      NULL,
      7,
      2,
      2.017917,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.566905,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.447756,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.543148,
      0,
      0.625993,
      1,
      NULL,
      NULL,
      2.586802,
      4.992478,
      1.629599,
      0,
      NULL,
      NULL,
      0.106334,
      NULL,
      NULL,
      1.071331,
      NULL,
      NULL,
      1.833088,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.564497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.321093,
      1.670137,
      1,
      3,
      4.735085,
      5,
      6,
      4.418889,
      7,
      8,
      8.495759,
      1,
      0.115334,
      NULL,
      NULL,
      2,
      2,
      1.471103,
      1.660784,
      NULL,
      0.250277,
      NULL,
      NULL,
      1.004673,
      3.371439,
      2.893210,
      3,
      2.009191,
      3.930309,
      1.891081,
      2,
      0.987283,
      2.899341,
      3,
      2.742968,
      0,
      2.503053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996388,
      3,
      2,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.947478,
      1,
      1.694657,
      0.059449,
      1,
      NULL,
      0.436696,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      0.775797,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.263727,
      NULL,
      NULL,
      NULL,
      2.272661,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.705747,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      1.468877,
      29,
      11.139462,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.555039,
      NULL,
      0,
      12506.928061,
      1527,
      1,
      0.630527,
      0,
      1,
      NULL,
      1.830625,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1.028285,
      0,
      0,
      NULL,
      0.544720,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.592991,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.277439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774408,
      0.315928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690259,
      0.311243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.392616,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.571901,
      1.126054,
      1.970051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.417772,
      1.523558,
      0.105268,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.841848,
      4.357288,
      0,
      9.073175,
      1,
      3.401239,
      2,
      4,
      NULL,
      NULL,
      3.466218,
      0,
      0.575397,
      NULL,
      NULL,
      0.633954,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      1.253290,
      NULL,
      2.189460,
      0,
      NULL,
      1.672817,
      1,
      NULL,
      0.108907,
      1,
      NULL,
      NULL,
      3.320850,
      NULL,
      1.852529,
      1.782971,
      NULL,
      NULL,
      2.534540,
      NULL,
      1.947644,
      NULL,
      NULL,
      1.286947,
      1,
      3,
      2.182160,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.829844,
      NULL,
      2.103735,
      NULL,
      0.577270,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.053668,
      NULL,
      1.512234,
      NULL,
      0.359147,
      NULL,
      0.954251,
      NULL,
      NULL,
      0,
      NULL,
      1.966611,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.274160,
      NULL,
      0,
      NULL,
      0.699654,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.269618,
      NULL,
      2,
      NULL,
      2.497929,
      NULL,
      2,
      NULL,
      80.482269,
      NULL,
      NULL,
      1.922323,
      NULL,
      0,
      NULL,
      0.343161,
      NULL,
      1.772587,
      0.927095,
      NULL,
      0,
      NULL,
      NULL,
      61,
      NULL,
      1.880249,
      0.648352,
      2,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL);
commit;
end;
/


