set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7526922';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '3330111',
      1.145787,
      0.530570,
      0,
      NULL,
      '3034',
      0.929298,
      0,
      NULL,
      NULL,
      ' 6-20-1990',
      5.521928,
      NULL,
      4,
      1.835027,
      NULL,
      '10-29-1982',
      50,
      5,
      189.835025,
      89,
      2,
      ' 9- 4-2001',
      ' 5-23-1999',
      '11-28-1998',
      0.765258,
      0.777378,
      3,
      NULL,
      1.235564,
      2,
      3,
      0,
      1.115582,
      222,
      10,
      NULL,
      7.408525,
      5,
      9.702944,
      7.424351,
      25.202528,
      NULL,
      0,
      1.700552,
      0.017660,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1.349506,
      10,
      7,
      NULL,
      6,
      1.736385,
      4,
      1.410888,
      10,
      1,
      3,
      0,
      9.380047,
      4.268254,
      1.645517,
      NULL,
      1.565363,
      2,
      4,
      NULL,
      1,
      2,
      0.357684,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.049494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049592,
      0.244239,
      1.799234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.849002,
      0.899934,
      0,
      NULL,
      1.760828,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      1.280171,
      1.218223,
      1.521636,
      1.604425,
      0.306008,
      NULL,
      NULL,
      0.735925,
      NULL,
      1,
      1.303047,
      2.331689,
      5,
      2.529447,
      0.914858,
      0,
      1.118714,
      1,
      0.993787,
      5,
      1,
      1,
      NULL,
      6.766178,
      7.766976,
      2.495625,
      4.915503,
      NULL,
      7,
      1,
      3.832787,
      NULL,
      1,
      2.665208,
      ' 3- 8-1976',
      884,
      NULL,
      107.290613,
      1.149423,
      1.135016,
      0,
      6,
      1.821205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.255691,
      NULL,
      NULL,
      0.018113,
      0,
      1.937074,
      1.800339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.743885,
      NULL,
      11.306868,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.515255,
      8.215355,
      0.086999,
      6,
      2.639257,
      NULL,
      3,
      NULL,
      2,
      1,
      1,
      NULL,
      0.784697,
      NULL,
      4,
      NULL,
      ' 9-11-1975',
      222,
      NULL,
      9,
      3,
      NULL,
      0.244351,
      0.014924,
      NULL,
      0.646041,
      0.214668,
      NULL,
      NULL,
      0.732063,
      3,
      0.060882,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.102850,
      3,
      NULL,
      NULL,
      1.893588,
      3,
      0.880169,
      3.696980,
      3.670039,
      2.561440,
      1.759857,
      0,
      3.957467,
      1,
      1,
      2,
      0,
      2.805180,
      NULL,
      1,
      1,
      0,
      1.649786,
      NULL,
      0.747408,
      1,
      1.396917,
      1.076685,
      4,
      0,
      4.497877,
      7.135991,
      4,
      11.101257,
      8,
      1.331930,
      5.379668,
      NULL,
      2,
      1.238547,
      3.627073,
      2,
      19.272307,
      NULL,
      2.103537,
      NULL,
      33,
      1.247878,
      45.766006,
      0.248436,
      1,
      2.664267,
      '22312',
      '',
      '',
      2.825484,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.530221,
      37.746921,
      303.229222,
      28,
      3,
      20,
      6.946625,
      12.486651,
      1,
      1.946735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.160590,
      NULL,
      NULL,
      0.598411,
      2,
      1,
      0,
      3.560077,
      1,
      0.212741,
      NULL,
      NULL,
      3.369820,
      NULL,
      1,
      2,
      0.427093,
      0.531204,
      NULL,
      NULL,
      NULL,
      1.104849,
      4.631112,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.866818,
      0.462388,
      0.238958,
      1,
      1,
      NULL,
      1.448228,
      NULL,
      NULL,
      NULL,
      0.612064,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1.464628,
      NULL,
      0.748164,
      NULL,
      NULL,
      NULL,
      0.366285,
      1,
      NULL,
      NULL,
      1.808544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264508,
      NULL,
      1,
      0.386614,
      NULL,
      NULL,
      0,
      NULL,
      0.074729,
      0.328481,
      1.860572,
      0,
      0.316773,
      NULL,
      NULL,
      4.436011,
      0.966393,
      NULL,
      0.249079,
      NULL,
      NULL,
      0.473563,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766221,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3,
      NULL,
      0.713534,
      1,
      NULL,
      NULL,
      2.655595,
      0,
      1.600122,
      2,
      2,
      1.541006,
      1.809621,
      1.930051,
      1,
      2.939923,
      6.936818,
      4,
      2.761285,
      1.258797,
      0.323808,
      3.692622,
      2.278369,
      2,
      0,
      2,
      NULL,
      0.238088,
      3,
      3.844803,
      10.760726,
      3.893597,
      8.994894,
      NULL,
      NULL,
      NULL,
      0.640807,
      2.178401,
      8,
      1,
      0.882980,
      1.779139,
      NULL,
      1.280439,
      1.399455,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.193580,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.861501,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954564,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.080625,
      0,
      1.258774,
      3,
      1,
      NULL,
      7.485510,
      3.457695,
      335.615271,
      NULL,
      4.760991,
      NULL,
      2.485475,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.614936,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167562,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754862,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.277801,
      0.651339,
      0.906593,
      NULL,
      2,
      0,
      0.714089,
      NULL,
      1,
      1,
      2.499623,
      NULL,
      3.713086,
      1.008503,
      0.759676,
      NULL,
      1,
      1,
      1.803647,
      NULL,
      3,
      1,
      5.962582,
      NULL,
      6.158222,
      NULL,
      7.476106,
      NULL,
      3,
      1.917757,
      10.398254,
      8,
      0.008282,
      NULL,
      104,
      1,
      48,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0.702757,
      18792.335659,
      1.242976,
      1.654046,
      1.488561,
      1,
      1.989285,
      0.655048,
      0.110959,
      1,
      NULL,
      0.177287,
      1.647408,
      0.789570,
      NULL,
      NULL,
      1,
      NULL,
      1.301249,
      1.724076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.342384,
      0.754664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.282989,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.687959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.455888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.630578,
      NULL,
      1,
      0,
      0.560206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7.839891,
      NULL,
      8.371117,
      4.136223,
      3.005085,
      4.745598,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.676382,
      NULL,
      2.504105,
      NULL,
      NULL,
      1,
      1,
      0,
      1.892776,
      1.515293,
      1,
      2.573067,
      0.125149,
      NULL,
      NULL,
      NULL,
      NULL,
      2.160071,
      0.754377,
      3,
      1.532589,
      1.326716,
      1,
      0.385572,
      0,
      2.059008,
      2,
      0,
      1.036979,
      1.245131,
      3.570892,
      3,
      0.678127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.417109,
      1.751232,
      0,
      0,
      NULL,
      0,
      0.946699,
      1,
      2,
      3,
      2.018265,
      0.972006,
      0.927392,
      NULL,
      2,
      3.288490,
      3.520945,
      NULL,
      1.441853,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.822706,
      1.368064,
      1,
      27,
      0,
      NULL,
      1,
      1,
      2.916859,
      0,
      NULL,
      NULL,
      1.436909,
      1,
      NULL,
      0,
      3,
      NULL,
      42.950543,
      3,
      3.313874,
      0,
      NULL,
      '22440',
      '',
      '',
      3,
      '12110',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


