set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8612598';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '1141420',
      2,
      0.089401,
      0,
      2,
      '1101',
      0.242199,
      0.922764,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      0,
      ' 1-25-2002',
      42.010751,
      2,
      NULL,
      77.220206,
      2.035691,
      ' 9-18-1989',
      NULL,
      ' 0-13-1974',
      2,
      NULL,
      1,
      2.273116,
      NULL,
      2,
      9.084982,
      0.542779,
      1.877574,
      14.334137,
      8,
      11,
      7,
      21,
      2,
      NULL,
      18.456226,
      9,
      1.758820,
      1.551507,
      1.971786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.358225,
      1,
      1.586659,
      0.528766,
      1,
      1,
      0.407139,
      4,
      8.292786,
      2.813680,
      5,
      0,
      1,
      NULL,
      0.085710,
      4.577288,
      0,
      1.946581,
      1.382956,
      1,
      NULL,
      NULL,
      NULL,
      3,
      5.271064,
      1,
      1,
      1,
      1,
      1.617822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.465647,
      0.003861,
      5.311482,
      NULL,
      1.322086,
      1,
      1.276574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.054190,
      NULL,
      6,
      1.502711,
      NULL,
      NULL,
      2.194515,
      1.890345,
      NULL,
      6.464706,
      NULL,
      1,
      0,
      5,
      0,
      0.381886,
      1,
      0,
      1,
      NULL,
      0.302724,
      NULL,
      3.689174,
      1.137474,
      1,
      1,
      NULL,
      0.507135,
      1.389854,
      1.448888,
      NULL,
      1,
      0,
      1.369957,
      2,
      2.131192,
      0,
      6.932988,
      6.577016,
      NULL,
      3.957955,
      5,
      4.937281,
      10.851749,
      NULL,
      0,
      0.011735,
      3.898604,
      ' 7- 6-1988',
      NULL,
      ' 3-27-1990',
      15.427761,
      1,
      NULL,
      NULL,
      5.671278,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.372843,
      0.883950,
      0,
      NULL,
      7.293107,
      1.941671,
      1.727463,
      1.748558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      3,
      3,
      NULL,
      1.107864,
      0.625886,
      1.877661,
      3,
      7.672117,
      9.522700,
      1.791129,
      NULL,
      NULL,
      1,
      1,
      0,
      3.759419,
      0.594958,
      NULL,
      6.996040,
      1.522002,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356351,
      0,
      3,
      1.548212,
      NULL,
      NULL,
      3.295385,
      ' 5-24-1982',
      3,
      ' 6-24-1990',
      9,
      1,
      0.777630,
      NULL,
      3.320357,
      0,
      1.913163,
      3.225995,
      NULL,
      1,
      1,
      2,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.171538,
      NULL,
      2.322129,
      3.026377,
      1,
      NULL,
      2,
      2.244393,
      2,
      2,
      3,
      2.151965,
      0.777435,
      1.415586,
      3,
      0,
      2,
      3,
      0,
      5.096289,
      NULL,
      0.346870,
      NULL,
      0.159733,
      0,
      0,
      0.024150,
      1,
      0,
      1,
      0.559453,
      1.974040,
      11.548923,
      10.265127,
      4,
      NULL,
      10,
      NULL,
      2.409109,
      3,
      4,
      3.670977,
      0,
      2,
      17.125746,
      3,
      1,
      NULL,
      47,
      53,
      29.183478,
      4,
      1.100835,
      0,
      '',
      '',
      '',
      NULL,
      '43310',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0.671441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.648834,
      3.833173,
      1.339155,
      0,
      1.504205,
      1.041699,
      0.315715,
      NULL,
      NULL,
      2,
      25,
      6.768176,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.076181,
      NULL,
      NULL,
      786.656243,
      1,
      0.497392,
      1.846349,
      0.237747,
      1.524238,
      1,
      NULL,
      1,
      0.958898,
      1,
      1,
      0.753688,
      0,
      1,
      0,
      0,
      0,
      0,
      1.792939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.493498,
      2,
      NULL,
      0,
      0.090197,
      1.869253,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1.253087,
      NULL,
      NULL,
      0,
      1.991938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.582822,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.053134,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.670729,
      NULL,
      0,
      NULL,
      1.091869,
      NULL,
      1.152828,
      0,
      0.057600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.129254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      2,
      0.819424,
      NULL,
      NULL,
      NULL,
      1,
      1.853578,
      1,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      6.548811,
      1,
      5,
      1,
      1,
      11,
      2.592097,
      NULL,
      0,
      NULL,
      1.477557,
      0.170044,
      1,
      0.829780,
      1,
      0.266833,
      3.229004,
      1.581513,
      1.827996,
      0,
      NULL,
      3.146691,
      2,
      0.804500,
      2.781467,
      0,
      2.583439,
      3,
      0,
      0,
      NULL,
      NULL,
      0.220030,
      NULL,
      NULL,
      1.432233,
      2.940785,
      3.107241,
      2.681893,
      1.906918,
      0,
      1,
      0,
      3,
      0.189853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.210325,
      0.196859,
      2.623964,
      NULL,
      0,
      NULL,
      1.175081,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.050970,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.102035,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      55,
      NULL,
      NULL,
      1.305907,
      1,
      1,
      1,
      1,
      1,
      5.390150,
      4.081090,
      3.515569,
      0.144650,
      1.710789,
      1,
      26,
      NULL,
      0.097496,
      0.419884,
      NULL,
      '',
      '',
      '',
      3.130838,
      '21200',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


