set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6110735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-9-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '2401442',
      2.486150,
      1,
      3,
      3,
      '1444',
      1,
      0.348834,
      NULL,
      NULL,
      ' 4-25-1975',
      2,
      NULL,
      2.264960,
      2,
      1,
      ' 7-20-1991',
      17,
      1,
      119,
      35.249650,
      NULL,
      ' 7-16-1986',
      ' 0-28-2000',
      ' 4- 5-1988',
      2,
      NULL,
      1.666354,
      1,
      1.343058,
      0.367935,
      NULL,
      NULL,
      0,
      302,
      6.633216,
      NULL,
      3,
      1.919559,
      26,
      NULL,
      9,
      NULL,
      1.284022,
      0,
      0.847279,
      1.601304,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.721768,
      1.694915,
      0,
      135,
      9.420431,
      7,
      3.000518,
      0.239797,
      3,
      5.257798,
      1,
      0,
      0,
      0,
      5,
      0.909163,
      3.937542,
      0,
      NULL,
      0.179970,
      NULL,
      1.954678,
      0,
      0.009105,
      NULL,
      0.293978,
      NULL,
      NULL,
      0.960152,
      NULL,
      NULL,
      2,
      NULL,
      0.487670,
      0.960562,
      0,
      1.394812,
      0,
      NULL,
      NULL,
      1.412000,
      1,
      2.501057,
      1,
      1,
      1,
      2,
      1,
      0.185584,
      0,
      1,
      1.932199,
      0,
      4.880886,
      1.094371,
      5.749413,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.440132,
      1,
      0.625852,
      0,
      0,
      4.838076,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.209871,
      NULL,
      NULL,
      1.864452,
      1.659225,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      0.723905,
      0.923130,
      1,
      1.688334,
      1.291691,
      1,
      NULL,
      4,
      NULL,
      1.584939,
      2.391028,
      3,
      3,
      NULL,
      NULL,
      8.947737,
      6.029317,
      5.549339,
      0,
      4,
      6.055617,
      8,
      NULL,
      4,
      2,
      '11-26-1984',
      94.413790,
      '11-13-1984',
      376,
      2.064046,
      1,
      0,
      6.886935,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.872684,
      1.792229,
      0.022890,
      NULL,
      0.783062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.615923,
      1,
      NULL,
      NULL,
      1,
      0.344756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260308,
      0.049187,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.393534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.401475,
      0.111193,
      1.075347,
      0.327121,
      NULL,
      NULL,
      NULL,
      4001,
      NULL,
      1,
      76,
      1226.819458,
      1973.603271,
      0.867045,
      NULL,
      1,
      2,
      2.159460,
      7,
      NULL,
      3.368004,
      0.767063,
      4.042917,
      2,
      2.478131,
      2.200956,
      2,
      NULL,
      1.369769,
      3,
      1,
      0.589849,
      NULL,
      0,
      0.152434,
      NULL,
      NULL,
      1.234432,
      1,
      1.752972,
      0,
      0.109117,
      0,
      0.089457,
      1,
      8.216120,
      9,
      1.918049,
      7,
      6.113693,
      NULL,
      2,
      NULL,
      4.556273,
      NULL,
      1.161377,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5,
      NULL,
      2.651253,
      NULL,
      0,
      '03340',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      6.102395,
      127,
      32,
      3.274626,
      12,
      28.133183,
      NULL,
      6.268291,
      NULL,
      2.947390,
      NULL,
      3,
      NULL,
      1.389645,
      3.598802,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.004092,
      NULL,
      NULL,
      0.835996,
      NULL,
      NULL,
      3.727407,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      3.006886,
      NULL,
      1,
      NULL,
      1.710167,
      0,
      3.020217,
      NULL,
      2,
      NULL,
      1.985276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.022642,
      0.304869,
      3,
      1,
      NULL,
      3.151767,
      1,
      1.813227,
      NULL,
      1.311150,
      1,
      1.160655,
      2.938003,
      1.183566,
      NULL,
      1,
      NULL,
      1.004418,
      1.033339,
      3.658311,
      1,
      2.670716,
      NULL,
      0,
      1.869124,
      1.750197,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.550887,
      NULL,
      NULL,
      8.429806,
      1.218667,
      NULL,
      0.275096,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254838,
      NULL,
      NULL,
      1.418671,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.085405,
      NULL,
      NULL,
      1,
      3,
      1.551249,
      0.465025,
      0,
      2.182713,
      1,
      2.038668,
      1.640669,
      NULL,
      NULL,
      0.083183,
      NULL,
      NULL,
      1.854418,
      NULL,
      NULL,
      0.541931,
      NULL,
      NULL,
      1.606118,
      NULL,
      NULL,
      1.579751,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.495241,
      2,
      3,
      4,
      3.215880,
      3.306014,
      6,
      3,
      2.601583,
      6,
      1.147510,
      1.715596,
      NULL,
      0,
      3.904046,
      3,
      2,
      3.364929,
      0,
      NULL,
      1,
      NULL,
      0.135000,
      NULL,
      3,
      2,
      0.601831,
      2.892951,
      0.655064,
      3,
      3,
      0.425996,
      1.760581,
      0.557304,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.626617,
      3.437666,
      8,
      1.911613,
      3,
      1.865637,
      1.365171,
      NULL,
      0.737962,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.200131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.918896,
      1.630245,
      1,
      0.161071,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.739311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.064177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.916925,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      163.970410,
      88.055405,
      1.032397,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673951,
      NULL,
      NULL,
      1.436812,
      NULL,
      NULL,
      1,
      NULL,
      0.078053,
      16077,
      NULL,
      1.462927,
      1.307533,
      0.024082,
      0.086296,
      1,
      0.334562,
      0,
      2.796079,
      0,
      2,
      1,
      2.562628,
      1,
      1.231607,
      1.566843,
      1,
      0.923844,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102624,
      1,
      NULL,
      1.545595,
      NULL,
      0.127597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.197965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.394481,
      3.498845,
      NULL,
      NULL,
      NULL,
      1.875553,
      NULL,
      61,
      NULL,
      0.158873,
      NULL,
      1.199105,
      NULL,
      0.962412,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.008524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.003092,
      NULL,
      1,
      NULL,
      3,
      NULL,
      14.634827,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.322956,
      NULL,
      NULL,
      1.706871,
      37,
      1.711965,
      1.694852,
      0,
      3.153255,
      2,
      3,
      2,
      NULL,
      1.538974,
      1.767573,
      2,
      2,
      9,
      0,
      0,
      0.437063,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.017945,
      NULL,
      0,
      1,
      NULL,
      0,
      1.316809,
      NULL,
      0.376975,
      NULL,
      NULL,
      0.158087,
      0.889461,
      NULL,
      NULL,
      1.477096,
      NULL,
      NULL,
      1.302782,
      NULL,
      0.961468,
      NULL,
      NULL,
      0.103882,
      2,
      NULL,
      0,
      1.513015,
      0.761558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.726932,
      NULL,
      NULL,
      NULL,
      4.920593,
      NULL,
      1.402038,
      6,
      1.109559,
      2.310173,
      0.739289,
      3,
      35,
      NULL,
      5.746100,
      0,
      1,
      '23141',
      '00101',
      NULL,
      0.117087,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      NULL);
commit;
end;
/


