set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7010603';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '32',
      '04',
      20,
      28,
      '4402330',
      NULL,
      1.083283,
      2,
      2,
      '4310',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      50.299158,
      6,
      NULL,
      0.914196,
      NULL,
      ' 8-16-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      1.553569,
      NULL,
      NULL,
      ' 5- 1-1999',
      1.098365,
      2.680503,
      0,
      NULL,
      NULL,
      1,
      NULL,
      3.562519,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      0,
      0,
      2,
      1,
      1.439354,
      0,
      NULL,
      0.604352,
      NULL,
      1.975274,
      NULL,
      NULL,
      0,
      1.916219,
      2,
      5.192073,
      NULL,
      1.273362,
      4.910272,
      0,
      1,
      0,
      NULL,
      0,
      0.546050,
      NULL,
      1,
      2,
      0.695567,
      3.533936,
      NULL,
      0,
      0.507662,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.946194,
      1.511083,
      1.548148,
      0.050923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.023489,
      0,
      1.055891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      1.223734,
      7,
      0,
      NULL,
      0,
      0.800271,
      6,
      5.324041,
      0.713131,
      1.179062,
      NULL,
      0,
      1,
      1.742014,
      1,
      1,
      NULL,
      1.537143,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.910283,
      2.397900,
      0.058527,
      1.479241,
      0.635444,
      0.180183,
      NULL,
      5.203352,
      NULL,
      1,
      3,
      4,
      4,
      3.215372,
      2,
      4.033733,
      7,
      NULL,
      1,
      0,
      1,
      0,
      '10-23-1999',
      153,
      ' 8-20-1984',
      104.185955,
      2,
      1,
      1.731722,
      1.174343,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055868,
      0,
      1.968736,
      0.613703,
      1.655579,
      0,
      NULL,
      1,
      0.882777,
      1.774379,
      1.483048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.437528,
      1.653146,
      1,
      1.309876,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1.027314,
      1,
      1,
      0,
      NULL,
      2.255206,
      0.429584,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.027116,
      NULL,
      2,
      2,
      NULL,
      3.374255,
      1.974057,
      2,
      3.072364,
      NULL,
      0,
      2,
      0.188459,
      1.725143,
      2,
      NULL,
      0,
      NULL,
      1.160944,
      1.021295,
      NULL,
      1,
      1.136703,
      3,
      NULL,
      1.393373,
      0,
      0,
      NULL,
      NULL,
      11.725074,
      2.661395,
      5.741043,
      9,
      0,
      4.197157,
      0.765303,
      3.335994,
      4,
      2,
      2,
      3,
      NULL,
      3,
      0,
      16.006246,
      NULL,
      NULL,
      NULL,
      0,
      4.532575,
      1,
      '21400',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.816458,
      0,
      186.219017,
      58.363754,
      0.985465,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.000380,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.717715,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.226181,
      NULL,
      NULL,
      1.395420,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423768,
      NULL,
      NULL,
      1.129010,
      NULL,
      NULL,
      1.585046,
      NULL,
      NULL,
      4,
      7.457745,
      9.413239,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.508956,
      NULL,
      NULL,
      1.821783,
      NULL,
      NULL,
      0.986356,
      NULL,
      NULL,
      1.683561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.810707,
      NULL,
      NULL,
      1.270711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.785528,
      2.434590,
      3.481308,
      1.389216,
      1,
      NULL,
      NULL,
      0,
      0,
      4,
      1.304747,
      NULL,
      3.176464,
      0,
      NULL,
      NULL,
      6,
      3,
      NULL,
      0.031477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.545812,
      NULL,
      NULL,
      0.563759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.011538,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.989887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.515703,
      3,
      0.582669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.663207,
      5.753553,
      NULL,
      2.202562,
      NULL,
      3.125010,
      0.286234,
      NULL,
      NULL,
      0.749491,
      NULL,
      0.058576,
      NULL,
      NULL,
      NULL,
      4.118555,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.343654,
      2.081833,
      1.320399,
      1.436934,
      1.522619,
      1.082179,
      0.659330,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399740,
      NULL,
      NULL,
      0.539373,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.270231,
      NULL,
      NULL,
      0,
      0,
      0.113446,
      0,
      1,
      NULL,
      0.955853,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.826404,
      NULL,
      NULL,
      NULL,
      1.974492,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.864958,
      NULL,
      NULL,
      NULL,
      1.616016,
      NULL,
      NULL,
      NULL,
      1.618143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783693,
      2,
      1,
      0.612136,
      NULL,
      NULL,
      0.497204,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.892387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      741.124229,
      NULL,
      0,
      1.290897,
      1,
      1.770156,
      0.928971,
      1.554766,
      0,
      0.364558,
      0,
      0,
      0,
      1.171503,
      1.426216,
      0,
      0.845630,
      1,
      0,
      1.063071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250142,
      1,
      1.345657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487415,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574055,
      0.487692,
      2.183451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.958128,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.591466,
      1.269002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      11.384739,
      2.373602,
      1.710234,
      1,
      3.464914,
      12,
      1.774085,
      NULL,
      0.650185,
      0.096077,
      0,
      NULL,
      1,
      2.598896,
      NULL,
      1.914105,
      3,
      NULL,
      1.775788,
      1,
      NULL,
      0.710234,
      2.853985,
      NULL,
      0,
      0,
      NULL,
      1.201767,
      NULL,
      NULL,
      0.290135,
      1,
      NULL,
      NULL,
      0.121365,
      NULL,
      0.551572,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.997427,
      0.494638,
      1.412338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400724,
      NULL,
      0.129545,
      NULL,
      1,
      NULL,
      3,
      0,
      6.377157,
      NULL,
      NULL,
      NULL,
      54.567166,
      54,
      3,
      0.348002,
      NULL,
      '04234',
      '',
      '',
      0.963369,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


