set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9904910';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      5.654807,
      3.072609,
      2,
      NULL,
      2,
      3.508713,
      3,
      '320',
      '10404130',
      67,
      64,
      NULL,
      3,
      NULL,
      2,
      2,
      '4013',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      30.035775,
      32,
      NULL,
      NULL,
      0,
      ' 1-16-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 8- 6-1997',
      1.801846,
      0.386493,
      3,
      1.723814,
      0.112220,
      0,
      0.637287,
      NULL,
      NULL,
      NULL,
      NULL,
      3.976277,
      7.243337,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      NULL,
      0.215050,
      2.493829,
      0,
      1.213358,
      0,
      0,
      0,
      3,
      1.643190,
      0,
      0,
      1.374670,
      NULL,
      4.230607,
      NULL,
      1.933705,
      NULL,
      0.580801,
      1,
      1.365932,
      1,
      6.263625,
      1,
      2,
      1,
      4,
      1.301655,
      4,
      0,
      2.295914,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.136270,
      NULL,
      NULL,
      0.566547,
      0.238169,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.284418,
      2.921665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1.272634,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      5.933966,
      0,
      1,
      1.412739,
      1,
      7,
      4.712538,
      NULL,
      NULL,
      0.092255,
      3.998087,
      0.668194,
      3.585777,
      2,
      2,
      5,
      1,
      NULL,
      NULL,
      1.991018,
      NULL,
      9,
      1,
      2,
      7.629052,
      0.575168,
      2.347969,
      ' 5- 8-1982',
      28.830369,
      '11-22-1979',
      155.097059,
      NULL,
      NULL,
      0.390724,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.130170,
      1.906800,
      NULL,
      1.098783,
      5.707787,
      1,
      0.745078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712010,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3,
      1.512159,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.636500,
      4,
      0,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.677419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.421288,
      0,
      1,
      0.282534,
      1,
      1,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.238995,
      0,
      0,
      1,
      3,
      NULL,
      3.567302,
      2.580950,
      3,
      1,
      2.598996,
      NULL,
      0,
      0,
      3.166287,
      2,
      0,
      3,
      0.106647,
      3.134847,
      0.557311,
      1.344378,
      0,
      1,
      1,
      0.552266,
      0.951217,
      NULL,
      0.405418,
      1.932802,
      0.807700,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988383,
      39,
      NULL,
      NULL,
      NULL,
      3.093938,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      2,
      20,
      36,
      20,
      NULL,
      3.617363,
      3,
      5.801015,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.432380,
      0.768104,
      1.474845,
      NULL,
      NULL,
      0.887497,
      0.031892,
      3,
      0.310616,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      5.827129,
      4.987813,
      4,
      2.492642,
      NULL,
      NULL,
      NULL,
      NULL,
      0.683645,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.946176,
      3,
      1,
      0.481074,
      NULL,
      NULL,
      1.461628,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.635550,
      0,
      1,
      2.831277,
      NULL,
      2.153779,
      1.924459,
      1.875958,
      NULL,
      0.782330,
      NULL,
      NULL,
      1.373658,
      NULL,
      NULL,
      NULL,
      1.147834,
      2.808497,
      9,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.239607,
      NULL,
      3.934639,
      NULL,
      0.772655,
      0.989665,
      3.610498,
      3,
      3,
      9.215919,
      NULL,
      0,
      NULL,
      3.277181,
      1.457197,
      0.339819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519715,
      NULL,
      NULL,
      1.547501,
      NULL,
      NULL,
      0.819782,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.854476,
      0.901752,
      3,
      0,
      NULL,
      NULL,
      10,
      4.564437,
      4.640426,
      1,
      0,
      0.677158,
      NULL,
      4,
      NULL,
      2,
      2,
      0,
      NULL,
      NULL,
      1.933417,
      3.440634,
      2,
      3,
      9,
      2,
      7.502334,
      NULL,
      1.565183,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.258580,
      0,
      NULL,
      2,
      5,
      1,
      9,
      NULL,
      3.154530,
      NULL,
      4.017946,
      0,
      0,
      NULL,
      0.285755,
      NULL,
      2,
      NULL,
      NULL,
      0.966553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.677195,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.335759,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.663769,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.550950,
      NULL,
      NULL,
      0,
      NULL,
      1.382717,
      NULL,
      1.824068,
      0.337676,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.714923,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.453108,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512583,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.696092,
      NULL,
      NULL,
      NULL,
      0.054173,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269581,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.569971,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.562077,
      NULL,
      NULL,
      0,
      NULL,
      0.749602,
      0.324997,
      1.392358,
      1.597554,
      1,
      NULL,
      0.648276,
      1,
      0.797923,
      0.546512,
      0.641993,
      NULL,
      1,
      1,
      1.495399,
      NULL,
      0.325350,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.900674,
      0.868430,
      NULL,
      1,
      3.100947,
      NULL,
      1,
      0.127972,
      NULL,
      0.522175,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.876080,
      3.888619,
      NULL,
      1.995162,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.250665,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.094380,
      NULL,
      1,
      NULL,
      0.094088,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2,
      136,
      0,
      5.042086,
      2,
      '24130',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.888963,
      '',
      '',
      '');
commit;
end;
/


