set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7923058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.187198,
      3,
      2,
      '0203',
      1.552235,
      0,
      NULL,
      NULL,
      ' 8- 0-1997',
      NULL,
      NULL,
      3,
      3.630722,
      0,
      ' 5-17-1991',
      50.191669,
      1,
      264,
      47,
      3,
      NULL,
      NULL,
      ' 8-21-1980',
      3,
      1.624081,
      2.795387,
      0.482874,
      0.974841,
      2,
      0,
      1,
      1,
      NULL,
      11,
      NULL,
      NULL,
      2.605482,
      0,
      NULL,
      16.524433,
      0,
      2.253856,
      NULL,
      0,
      1,
      2.291697,
      1.758150,
      0.547254,
      0,
      3.046398,
      0.730557,
      0.757591,
      1,
      1,
      2,
      1,
      2,
      0.595169,
      0.079050,
      1.051558,
      1.352085,
      NULL,
      0,
      1,
      0,
      1,
      1.448107,
      1.375145,
      0.531554,
      NULL,
      1.632487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396175,
      1.369627,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816520,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.948588,
      1,
      1.966901,
      1,
      0,
      1.618058,
      1,
      1,
      0.929885,
      NULL,
      0,
      1,
      0,
      1.536489,
      1.687190,
      0,
      0,
      0.445737,
      NULL,
      0.929189,
      1.367284,
      0.556665,
      1,
      NULL,
      NULL,
      0,
      4.521808,
      1,
      1,
      0,
      NULL,
      0.950458,
      0,
      1.334760,
      0.083513,
      0.594286,
      0.364340,
      NULL,
      1.187464,
      2,
      1,
      0,
      0.645326,
      0.571918,
      0,
      1.806011,
      1.129539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.241205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      1.199274,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.976313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.993878,
      NULL,
      1,
      4,
      NULL,
      1.090230,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.653846,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.122784,
      0.670189,
      NULL,
      NULL,
      NULL,
      3.117012,
      NULL,
      2.986017,
      NULL,
      2,
      1.091632,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      1.731601,
      1,
      2,
      1,
      3.585071,
      0,
      1,
      NULL,
      0.092984,
      1.459013,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      10,
      6,
      6.476339,
      3.374247,
      3.606386,
      2.959826,
      NULL,
      0.595949,
      2.308697,
      2,
      3,
      44,
      NULL,
      NULL,
      0.394156,
      NULL,
      NULL,
      NULL,
      1.723568,
      NULL,
      0.417710,
      '10443',
      '',
      '',
      1.791812,
      '',
      '',
      '',
      1.460119,
      '',
      '',
      '',
      0.816043,
      11,
      197,
      0,
      0,
      5.510664,
      1,
      85,
      1,
      1.994940,
      NULL,
      NULL,
      1.635099,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.556320,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.289658,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.846442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364060,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.535103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.541288,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.499390,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.470494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.478656,
      NULL,
      NULL,
      1.053225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.666050,
      NULL,
      NULL,
      9.739444,
      3.208920,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.101521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883958,
      NULL,
      NULL,
      0.774500,
      3,
      1,
      3.101691,
      0.253128,
      0.599705,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.809529,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.103973,
      0.133735,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.992077,
      1.098356,
      NULL,
      0,
      1.817409,
      0.712248,
      1,
      NULL,
      NULL,
      NULL,
      0.276531,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376108,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.688147,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.109459,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.756136,
      NULL,
      NULL,
      NULL,
      1.700678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.646439,
      465,
      38.352512,
      0,
      NULL,
      NULL,
      1.880610,
      NULL,
      NULL,
      1.039160,
      228,
      11.358673,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      73,
      2.393935,
      NULL,
      1838.378584,
      1,
      1,
      NULL,
      2,
      0,
      NULL,
      0,
      2,
      0.117222,
      2.557732,
      NULL,
      3.770222,
      1,
      1,
      1,
      1,
      1.326479,
      NULL,
      NULL,
      0.138310,
      NULL,
      3.324399,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      66.181730,
      NULL,
      0.906837,
      31,
      38,
      3.310562,
      0,
      2.755406,
      NULL,
      0.242525,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.550551,
      NULL,
      0.041684,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.792969,
      NULL,
      1,
      NULL,
      0.385610,
      NULL,
      1,
      NULL,
      1.935764,
      0.929586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.651485,
      1.017288,
      4,
      0.657135,
      0.651228,
      1,
      0.310309,
      1.073671,
      1,
      3.572268,
      3,
      0.341362,
      1.226696,
      0.274696,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.585218,
      1,
      1.269673,
      0.932659,
      1,
      0.807511,
      0,
      NULL,
      NULL,
      0.705593,
      0,
      1,
      0,
      0.840949,
      0,
      0.438411,
      NULL,
      1,
      1,
      1.848367,
      1,
      1,
      1,
      NULL,
      NULL,
      2.577183,
      NULL,
      NULL,
      1,
      NULL,
      1.010562,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.577750,
      NULL,
      NULL,
      NULL,
      1.223572,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      35.996553,
      1,
      NULL,
      1.052863,
      0,
      3.867766,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.119784,
      NULL,
      0.434684,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.980855,
      NULL,
      1.657020,
      NULL,
      0.034794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      20,
      0,
      34.848036,
      1,
      1.144316,
      NULL,
      0.064382,
      NULL,
      1.907178,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      32.114115,
      NULL,
      NULL,
      1,
      NULL,
      '30130',
      '01042',
      '',
      NULL,
      '',
      '',
      '',
      0.381493,
      '1341',
      '',
      '');
commit;
end;
/


