set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8704594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '4243001',
      NULL,
      0,
      1,
      2,
      '4343',
      2.439385,
      1,
      NULL,
      NULL,
      ' 8- 4-1987',
      25.770624,
      NULL,
      NULL,
      3.215538,
      NULL,
      ' 1-19-1994',
      45,
      2.200749,
      168.269925,
      133.616942,
      3,
      ' 8- 0-1994',
      ' 5-14-1977',
      ' 1- 7-1977',
      3.833538,
      NULL,
      2,
      NULL,
      0.931108,
      0.409233,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812830,
      18,
      29.556703,
      0.517913,
      12,
      0.410924,
      NULL,
      5.013746,
      1,
      3.246294,
      1,
      NULL,
      NULL,
      0.314419,
      1,
      0,
      0.851223,
      NULL,
      1.951651,
      2,
      4,
      1.958686,
      1,
      4.535613,
      0,
      1,
      7,
      0,
      0,
      8,
      0,
      1,
      0,
      0,
      1,
      0.214822,
      1.481008,
      1.738150,
      0,
      0.521948,
      1.811487,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.581005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.807815,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      2.168631,
      2.320652,
      7.281581,
      3,
      0,
      1,
      6,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0.704952,
      0.237086,
      0,
      1.590665,
      1.533014,
      NULL,
      4.926025,
      0,
      NULL,
      0,
      1.596818,
      1.217369,
      NULL,
      1.513010,
      9,
      NULL,
      0.401467,
      0,
      3,
      5.629726,
      8,
      3.616088,
      2.125112,
      6.782400,
      NULL,
      3,
      1.361938,
      NULL,
      ' 2-10-1981',
      NULL,
      '10-20-1998',
      NULL,
      0.373082,
      1.224811,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.446294,
      5.759159,
      3,
      0.658223,
      NULL,
      2.957029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129342,
      NULL,
      NULL,
      NULL,
      NULL,
      0.953539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.440427,
      3.971175,
      3.819512,
      0.887695,
      1.817002,
      0,
      NULL,
      1,
      1.058732,
      NULL,
      1.247569,
      0,
      NULL,
      NULL,
      NULL,
      0.590571,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897416,
      0,
      0.505860,
      1.036510,
      NULL,
      1,
      0.852826,
      1.459548,
      6,
      NULL,
      1.349780,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.801296,
      NULL,
      1.395929,
      1,
      0.516335,
      1,
      1,
      0.407658,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.894542,
      1.108029,
      1.105540,
      0,
      0.231713,
      1,
      1,
      1,
      0,
      0,
      1.945333,
      0.353953,
      0,
      0,
      2,
      NULL,
      0,
      2,
      1.541490,
      10.800227,
      7.847164,
      0.154283,
      0,
      3.642834,
      NULL,
      1,
      0,
      NULL,
      27.077208,
      1,
      1,
      NULL,
      45.786625,
      NULL,
      41.689300,
      0,
      2.021004,
      NULL,
      '34140',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.961436,
      '',
      '',
      NULL,
      0.551435,
      12,
      31,
      35,
      0.261812,
      16,
      3.403921,
      0,
      0.367528,
      0.268199,
      1.944745,
      0.181452,
      0.524164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.452035,
      0.615508,
      NULL,
      NULL,
      1.851246,
      NULL,
      NULL,
      3.142968,
      NULL,
      2.421394,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.557634,
      NULL,
      NULL,
      1.184005,
      6.858904,
      1.773703,
      0,
      0.620990,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392394,
      3,
      3,
      NULL,
      0,
      0.389296,
      0,
      NULL,
      NULL,
      1.648446,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.388021,
      NULL,
      NULL,
      0.478102,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455907,
      NULL,
      NULL,
      2,
      0,
      1.158297,
      3.224635,
      1.957779,
      0.790995,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      3.865626,
      0.916607,
      NULL,
      2.339556,
      1,
      NULL,
      2,
      5.696543,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.438591,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.010468,
      NULL,
      NULL,
      3.912467,
      NULL,
      2.754354,
      1,
      1,
      3.353447,
      6.141030,
      0.437085,
      NULL,
      1.728798,
      NULL,
      NULL,
      3.045222,
      2.743290,
      1,
      0.250084,
      3,
      2.648756,
      NULL,
      3.874950,
      1.337704,
      7,
      0,
      2.032827,
      3.708287,
      0,
      0.696295,
      2,
      3.085272,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.642604,
      1.981679,
      1.490646,
      7,
      0,
      NULL,
      0.942734,
      NULL,
      0.463592,
      6,
      0,
      1,
      1.150559,
      1.825866,
      1.767293,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.221803,
      NULL,
      NULL,
      0.403713,
      NULL,
      NULL,
      1.156325,
      NULL,
      NULL,
      1.563672,
      NULL,
      NULL,
      0.491873,
      NULL,
      NULL,
      2.242119,
      1.807744,
      0,
      1,
      3,
      1,
      0.760892,
      NULL,
      4,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.523979,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.192674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860404,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.607007,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3.686567,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.321964,
      NULL,
      0,
      NULL,
      1.137044,
      NULL,
      0.166652,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.235242,
      NULL,
      1.082667,
      NULL,
      1.209674,
      NULL,
      2.727114,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.764049,
      NULL,
      3,
      NULL,
      6.340196,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      10.123888,
      0,
      0.399892,
      NULL,
      1,
      0.324382,
      NULL,
      NULL,
      0.971219,
      NULL,
      NULL,
      0.194484,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.164414,
      0.494187,
      7,
      3,
      3.881724,
      NULL,
      0.429168,
      1.682892,
      0.497945,
      1.387687,
      1,
      NULL,
      0,
      3.143600,
      0.745212,
      NULL,
      0.447527,
      1.946513,
      NULL,
      3.599310,
      2.792151,
      1.869241,
      1.449913,
      0.410624,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.140788,
      1,
      0.397929,
      1.186235,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.235042,
      1,
      1.779901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941068,
      1.253585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.651171,
      0.410977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870173,
      1.565820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.179510,
      1.669386,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.809146,
      0,
      1,
      1.159593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.223137,
      4,
      3.061049,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.374132,
      1,
      1.436608,
      0,
      NULL,
      0.983243,
      0.790031,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3,
      2.306529,
      NULL,
      NULL,
      1,
      NULL,
      0.176506,
      NULL,
      NULL,
      1.606296,
      1.147689,
      NULL,
      NULL,
      0.101990,
      NULL,
      NULL,
      0.780957,
      NULL,
      1.048906,
      NULL,
      NULL,
      NULL,
      0.848217,
      0.836120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.566832,
      NULL,
      1,
      NULL,
      6,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      111,
      5.542862,
      0,
      3,
      '31232',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


