set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8704594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      '00',
      16,
      14.391430,
      NULL,
      1,
      1.677127,
      0,
      0,
      '3433',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.045872,
      1.381155,
      ' 9-24-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      1.756929,
      NULL,
      ' 1-14-1985',
      ' 5- 0-1974',
      1.699235,
      0.374505,
      0.610970,
      1.185355,
      1,
      0,
      3.173836,
      NULL,
      1.767474,
      NULL,
      1.661131,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.601962,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.810701,
      1.878202,
      0,
      1.566427,
      0,
      NULL,
      NULL,
      16.827536,
      NULL,
      3.044369,
      0.237230,
      2.615890,
      1.456497,
      0,
      0.704940,
      1.267253,
      NULL,
      0,
      2.771431,
      0.973315,
      1.677271,
      1,
      0,
      1.683499,
      1.892500,
      0,
      0.133945,
      0,
      1.565522,
      NULL,
      NULL,
      NULL,
      0.349504,
      NULL,
      NULL,
      NULL,
      1,
      0.531307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.520387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657936,
      NULL,
      NULL,
      1,
      1,
      4.609027,
      0,
      1.923774,
      NULL,
      2,
      1.328398,
      NULL,
      0,
      2,
      NULL,
      1,
      1,
      1,
      0.369512,
      NULL,
      1,
      0,
      0,
      0.985214,
      1.223103,
      NULL,
      NULL,
      2.654925,
      1,
      NULL,
      1.919179,
      0.075032,
      0.940725,
      1.647758,
      3,
      2,
      NULL,
      6.491540,
      3,
      NULL,
      6,
      NULL,
      0,
      3.349000,
      0,
      0.632407,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.664248,
      NULL,
      1.647631,
      1.298338,
      0,
      1.658756,
      1.839501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.565690,
      1.202710,
      1.369256,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092952,
      1.803391,
      1,
      1.402873,
      0,
      0.648203,
      NULL,
      NULL,
      NULL,
      0.263446,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.882827,
      1,
      0,
      1.965554,
      0,
      1.414788,
      1,
      3,
      1,
      1.147314,
      NULL,
      NULL,
      NULL,
      2.006554,
      1,
      NULL,
      3,
      0,
      3.709017,
      3.019819,
      0.635617,
      0.924821,
      2,
      NULL,
      3,
      0,
      3,
      NULL,
      2.394791,
      3,
      0.021184,
      NULL,
      1.157563,
      1.899320,
      NULL,
      1.682360,
      NULL,
      NULL,
      0.679344,
      0,
      1.046307,
      1,
      0.312981,
      3.467894,
      NULL,
      6.345606,
      NULL,
      0,
      9,
      7,
      4,
      2.309472,
      1.080857,
      1,
      2,
      2.521320,
      2,
      NULL,
      1,
      NULL,
      6.706575,
      NULL,
      57,
      66,
      0,
      2,
      NULL,
      '30333',
      '',
      '',
      1.602211,
      '',
      NULL,
      NULL,
      1.864622,
      '',
      '',
      '',
      NULL,
      NULL,
      46,
      4.460930,
      0,
      30,
      NULL,
      3,
      3,
      0.710785,
      1.893916,
      1.175536,
      1,
      NULL,
      NULL,
      0.888449,
      NULL,
      NULL,
      0.614200,
      2.314652,
      2,
      0.379741,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.711745,
      NULL,
      NULL,
      1.439846,
      NULL,
      NULL,
      1.121942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.947969,
      NULL,
      2.636864,
      0.404530,
      NULL,
      NULL,
      NULL,
      NULL,
      1.021337,
      NULL,
      1.814618,
      1.375794,
      1.798805,
      2,
      0,
      0.231348,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.856449,
      3.994483,
      1,
      0.644846,
      3,
      1,
      1.752921,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2.157158,
      NULL,
      NULL,
      3,
      0.145134,
      4.109745,
      2,
      2.980054,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.153953,
      NULL,
      NULL,
      1.675767,
      NULL,
      NULL,
      1.872575,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.990240,
      NULL,
      3,
      NULL,
      4,
      3.274571,
      NULL,
      2,
      0.323913,
      4.409045,
      3.007027,
      NULL,
      NULL,
      0.711654,
      1.887847,
      3,
      1.956265,
      2.706003,
      NULL,
      1.970431,
      3.745321,
      3.877062,
      0,
      0.594255,
      0.474192,
      3.514329,
      NULL,
      0.680734,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      NULL,
      1,
      9.873926,
      9.339816,
      NULL,
      5.082916,
      1,
      1.403611,
      NULL,
      4,
      0.820362,
      1.857043,
      NULL,
      0.849293,
      1.933079,
      1.762462,
      NULL,
      NULL,
      NULL,
      1.323662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.265623,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.372122,
      NULL,
      NULL,
      1.920455,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      0.638250,
      2.310061,
      4.529481,
      NULL,
      19,
      3.559614,
      NULL,
      NULL,
      0.963836,
      0,
      2.890198,
      NULL,
      2,
      3,
      1,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.506105,
      2.883654,
      NULL,
      1.579804,
      NULL,
      1.884788,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.618965,
      1.516031,
      0,
      NULL,
      0.836359,
      2,
      0.976314,
      NULL,
      1,
      2.378597,
      0.449675,
      NULL,
      0.279451,
      0.060596,
      2.245531,
      NULL,
      2.817070,
      1.171497,
      2.937103,
      NULL,
      1,
      1.358125,
      1.604745,
      NULL,
      NULL,
      0.715971,
      1.579088,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.039622,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.354317,
      2,
      1.389161,
      5,
      1,
      NULL,
      35.629757,
      4.186160,
      3,
      4,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848714,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      971,
      NULL,
      0,
      NULL,
      1,
      2.246363,
      1,
      0,
      0.633724,
      1,
      1.683858,
      NULL,
      1,
      0,
      1,
      0.751577,
      1,
      1.019890,
      0.056024,
      1,
      NULL,
      1,
      NULL,
      0.064288,
      NULL,
      NULL,
      NULL,
      3.646755,
      NULL,
      1.773460,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.177821,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643114,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501541,
      0.728992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173038,
      1.850027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.369199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.243328,
      0.036289,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.643547,
      1.334032,
      2.886490,
      0.640342,
      NULL,
      3.050905,
      NULL,
      3,
      7,
      3,
      1.290391,
      3.013574,
      1.345789,
      0.794523,
      NULL,
      NULL,
      1,
      1.910137,
      1,
      0.584388,
      NULL,
      1.300169,
      1.378131,
      NULL,
      NULL,
      NULL,
      3.136870,
      0.325610,
      1.719307,
      0.753798,
      0,
      1,
      1.011760,
      1.173360,
      NULL,
      1.940333,
      0.857167,
      1,
      1.034565,
      NULL,
      0,
      NULL,
      0.870385,
      NULL,
      0.147608,
      2.215302,
      0.644839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.851888,
      NULL,
      0,
      0.788733,
      1.194468,
      2.046734,
      3.743658,
      NULL,
      0,
      NULL,
      NULL,
      50,
      NULL,
      0,
      2.602614,
      0,
      '01233',
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


