set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9907503';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1.416315,
      5.746612,
      2.648725,
      2.649061,
      2,
      5.840855,
      1.571862,
      '111',
      '22020024',
      65,
      41.274964,
      '1011442',
      0,
      0,
      2,
      0,
      '3033',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      169.241673,
      75.083824,
      NULL,
      1.392149,
      NULL,
      ' 2-18-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      0.255912,
      ' 1- 7-2001',
      ' 4-26-1998',
      ' 7-28-1974',
      0,
      3.172767,
      0.628680,
      0,
      0.724520,
      2.791697,
      0.417431,
      NULL,
      1.692890,
      NULL,
      2,
      11,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.003718,
      NULL,
      0.953457,
      0.118853,
      1.736651,
      0.810745,
      0,
      NULL,
      0.377598,
      0.718608,
      1.341747,
      0.305273,
      NULL,
      15.358108,
      4,
      1,
      3,
      4.333263,
      0.941810,
      NULL,
      4,
      0.477821,
      NULL,
      4,
      1.295423,
      1,
      NULL,
      3,
      1,
      3,
      1,
      NULL,
      0,
      2.748494,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.784232,
      2.924627,
      NULL,
      0.193272,
      1,
      1,
      0.436149,
      3,
      NULL,
      NULL,
      3,
      3,
      1,
      2.543663,
      1.648463,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.581348,
      1,
      NULL,
      NULL,
      3.729628,
      5,
      0.355671,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      7.506264,
      NULL,
      1.993263,
      7.295951,
      1,
      1.292227,
      0,
      0.770769,
      0,
      NULL,
      1,
      NULL,
      0,
      0.198807,
      0.343502,
      NULL,
      NULL,
      NULL,
      1.993601,
      NULL,
      0.501136,
      6,
      0,
      1.683160,
      2.704342,
      NULL,
      1,
      0,
      4,
      NULL,
      1,
      NULL,
      0,
      7,
      4.394711,
      7,
      3.552364,
      0,
      4.360686,
      0.320752,
      6,
      5.566086,
      1.048392,
      0.036013,
      NULL,
      2.936457,
      NULL,
      234.953112,
      '10- 3-1981',
      66,
      2,
      NULL,
      3,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148871,
      0.793264,
      5,
      1.896002,
      2.055126,
      5.496339,
      1.382406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980859,
      1,
      0,
      0.287026,
      1,
      NULL,
      NULL,
      2.574992,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      2,
      0.803313,
      2.143844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.154242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.056392,
      1.073831,
      NULL,
      0.865538,
      NULL,
      0.591493,
      163,
      0,
      0.543611,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.754056,
      3,
      3.840713,
      3,
      2,
      3.362814,
      NULL,
      3,
      NULL,
      1.828614,
      0,
      NULL,
      NULL,
      0.362222,
      NULL,
      0.337487,
      1,
      0.090086,
      1,
      1,
      1.288595,
      0.259794,
      NULL,
      NULL,
      1.667766,
      1,
      0.164426,
      1.693147,
      1,
      1,
      11.297165,
      10,
      3,
      0,
      11.435307,
      4,
      5.546680,
      2.440343,
      4.483869,
      NULL,
      3.440897,
      NULL,
      18,
      3,
      NULL,
      NULL,
      NULL,
      38.576630,
      23,
      2.258233,
      3.408125,
      3,
      NULL,
      NULL,
      '',
      1.428396,
      '',
      NULL,
      NULL,
      0.610041,
      '',
      NULL,
      '',
      3.981760,
      31,
      77.851194,
      12,
      0,
      NULL,
      3.723981,
      6,
      5.508550,
      0,
      1.401525,
      1.692842,
      1.651534,
      NULL,
      NULL,
      1.905817,
      NULL,
      NULL,
      0,
      0,
      0.645211,
      1.490961,
      NULL,
      NULL,
      1.395134,
      NULL,
      NULL,
      2.947540,
      1.670214,
      1.139843,
      1.292385,
      1.971896,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.658868,
      NULL,
      NULL,
      9,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.328753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078352,
      0.917633,
      NULL,
      3,
      NULL,
      0.084422,
      2,
      NULL,
      1.129045,
      0.211087,
      1.484521,
      2,
      0,
      NULL,
      0.025134,
      3,
      NULL,
      NULL,
      3,
      0,
      1.266818,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.605266,
      NULL,
      NULL,
      4.790863,
      0.127511,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3.723019,
      1.417689,
      1.054528,
      NULL,
      NULL,
      2,
      0.308762,
      3.548691,
      1,
      NULL,
      NULL,
      5.776349,
      3,
      NULL,
      3.227511,
      0.849152,
      NULL,
      2.753053,
      1.753078,
      1,
      4,
      NULL,
      1.663161,
      0.820776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.315599,
      NULL,
      NULL,
      1.227171,
      1.702039,
      0.236484,
      1.606426,
      NULL,
      NULL,
      NULL,
      1,
      0.402711,
      0.500977,
      2.054464,
      2.249847,
      0.837639,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3,
      0,
      NULL,
      2,
      0.826211,
      2.510937,
      4,
      NULL,
      6,
      0,
      1.490217,
      2,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      NULL,
      7.585905,
      0,
      NULL,
      NULL,
      1.443120,
      1.081895,
      6.131014,
      0.331884,
      1,
      0.218518,
      1.167860,
      0,
      NULL,
      NULL,
      NULL,
      0.502399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347939,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1.472855,
      2.895984,
      0,
      0,
      0,
      0.752650,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.855433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.067689,
      NULL,
      1.547900,
      NULL,
      0.851321,
      NULL,
      1.438247,
      NULL,
      0.147202,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.372640,
      NULL,
      2,
      NULL,
      3.567562,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1.456657,
      NULL,
      1.901178,
      NULL,
      0.678914,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.385379,
      NULL,
      1,
      NULL,
      1.020569,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.030178,
      NULL,
      0,
      NULL,
      16,
      NULL,
      10,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.051502,
      NULL,
      1,
      1,
      3,
      0,
      NULL,
      1.100348,
      1,
      NULL,
      NULL,
      2.923700,
      1,
      1.822807,
      1,
      NULL,
      NULL,
      0.869483,
      NULL,
      NULL,
      1.221684,
      NULL,
      NULL,
      127.777336,
      5.145978,
      0,
      NULL,
      2.671004,
      1,
      1,
      1,
      2,
      NULL,
      1.288360,
      NULL,
      2,
      0.997387,
      NULL,
      0,
      1.240902,
      1,
      NULL,
      NULL,
      2.158780,
      NULL,
      3,
      NULL,
      0.114735,
      NULL,
      0.478559,
      NULL,
      NULL,
      NULL,
      106.241701,
      NULL,
      3,
      NULL,
      26,
      NULL,
      0.830869,
      2,
      2.370706,
      1.284289,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.879420,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.608225,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.626624,
      NULL,
      1.330061,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0.661482,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494518,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.719121,
      NULL,
      0.534382,
      NULL,
      1,
      NULL,
      0.062045,
      NULL,
      1,
      NULL,
      NULL,
      3.574138,
      NULL,
      81,
      NULL,
      NULL,
      NULL,
      0.746517,
      NULL,
      0.650674,
      NULL,
      0.440187,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126581,
      3.733283,
      NULL,
      3.207004,
      NULL,
      16.568083,
      NULL,
      NULL,
      NULL,
      1.509905,
      NULL,
      0,
      NULL,
      0.057666,
      1,
      21.085042,
      NULL,
      NULL,
      3.067065,
      0,
      18,
      0.862117,
      0,
      NULL,
      1.051378,
      3,
      3.596493,
      NULL,
      2.716928,
      0.096788,
      1.266840,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      NULL,
      1.746423,
      NULL,
      NULL,
      1.215476,
      NULL,
      NULL,
      0.443242,
      1.672456,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.131690,
      NULL,
      0,
      1.450154,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.986405,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.567825,
      NULL,
      NULL,
      0.383527,
      2,
      0,
      NULL,
      NULL,
      38.750614,
      39,
      2.149539,
      2.560375,
      5.497795,
      '20103',
      '03300',
      '01030',
      NULL,
      '',
      '',
      '',
      1.578223,
      '',
      '',
      '');
commit;
end;
/


