set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '4320330',
      1,
      1,
      1,
      1,
      '1442',
      0,
      NULL,
      NULL,
      NULL,
      ' 9-14-1984',
      43,
      NULL,
      2,
      3.387169,
      2.432301,
      '10-20-1974',
      39,
      NULL,
      NULL,
      131.693505,
      NULL,
      NULL,
      ' 9-18-1986',
      ' 5-15-2003',
      1,
      0.993958,
      2.036479,
      1,
      0.286731,
      0.612740,
      NULL,
      0,
      1,
      NULL,
      10,
      4,
      3,
      1.594263,
      23,
      NULL,
      22.578239,
      4.343008,
      3,
      1.630792,
      0,
      1,
      0,
      0,
      0.062927,
      0.684041,
      1.258181,
      0.900926,
      NULL,
      1.404087,
      NULL,
      NULL,
      4.912988,
      3,
      3,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.190531,
      1.890273,
      1,
      0,
      2.741154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.156985,
      0,
      1.051562,
      2,
      0.192550,
      3.342406,
      NULL,
      1,
      NULL,
      1,
      0.993765,
      1,
      0,
      1.825948,
      1.764935,
      0.667699,
      0,
      1.335253,
      0.359690,
      2.497998,
      0,
      2,
      2,
      1,
      0,
      NULL,
      0.002436,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.019183,
      1.692160,
      1,
      1,
      NULL,
      0,
      1,
      4.198185,
      2.200674,
      0.867376,
      0.460726,
      0,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.381969,
      6,
      0,
      2,
      0.693330,
      2,
      NULL,
      0.229974,
      3.433223,
      7,
      1.593858,
      1,
      3,
      5,
      2,
      4,
      4,
      NULL,
      NULL,
      2.827400,
      3,
      5,
      0.605395,
      5.530893,
      NULL,
      0,
      3.765153,
      NULL,
      NULL,
      ' 4-21-2000',
      8.361771,
      1,
      1,
      0.646050,
      6,
      4,
      NULL,
      11,
      0.493247,
      3,
      0,
      NULL,
      0,
      2.237718,
      1,
      2,
      0.007819,
      NULL,
      1.737321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.197739,
      2,
      NULL,
      0,
      3,
      0.518115,
      1.242061,
      1,
      1,
      3,
      7.899344,
      0.121599,
      0.527508,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.294082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.702117,
      NULL,
      NULL,
      0.947506,
      2.814320,
      37,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.778305,
      NULL,
      1,
      0.364716,
      1,
      3.379563,
      2,
      0.924274,
      3,
      1.647212,
      NULL,
      1.514775,
      1.504001,
      NULL,
      10.066277,
      154.456135,
      138,
      165.706519,
      87.733124,
      124,
      190.009603,
      1,
      1.150948,
      NULL,
      1.529738,
      0,
      0.646614,
      0.074206,
      16.684605,
      7,
      NULL,
      6.315801,
      9.751746,
      NULL,
      6,
      2,
      3.295663,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      37,
      1.849443,
      2.747524,
      NULL,
      42,
      45.037390,
      88,
      2,
      1.266551,
      4.495001,
      '20200',
      '01322',
      '21330',
      0,
      NULL,
      '',
      NULL,
      0.463428,
      '',
      '',
      '',
      2.769917,
      22,
      22,
      1.717868,
      2.515110,
      21,
      0.866469,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0.796868,
      NULL,
      NULL,
      0.304212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.272568,
      2,
      3.597144,
      17.391550,
      NULL,
      NULL,
      NULL,
      3.002202,
      NULL,
      0.288285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213234,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.208424,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.325156,
      NULL,
      NULL,
      1.780054,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319449,
      3.852760,
      0,
      0,
      1.703174,
      0.667281,
      0,
      NULL,
      NULL,
      6,
      4.133208,
      0.054542,
      NULL,
      2,
      0,
      0.934706,
      NULL,
      NULL,
      5.544975,
      6.864407,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.172729,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.253845,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.895354,
      0.003810,
      NULL,
      3,
      2,
      4.434769,
      2.900203,
      5.326979,
      NULL,
      5.491370,
      0,
      NULL,
      1,
      0,
      0.916693,
      NULL,
      NULL,
      1.354991,
      0,
      1,
      2,
      1.324407,
      1,
      5,
      0.244684,
      1.796518,
      3.709576,
      NULL,
      3.163985,
      1,
      1.218092,
      NULL,
      0.253200,
      3,
      1,
      2,
      3,
      3.965779,
      2,
      4.348670,
      3.263354,
      1.643484,
      NULL,
      5,
      2.695168,
      4,
      NULL,
      0,
      2,
      NULL,
      0.201918,
      0,
      2.698451,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.465386,
      NULL,
      NULL,
      1.322881,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.678150,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.592028,
      NULL,
      NULL,
      0.274989,
      NULL,
      NULL,
      0.239906,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.154836,
      NULL,
      NULL,
      1,
      1,
      1,
      1.363530,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3.934483,
      0.180649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.028834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.217342,
      0.716238,
      NULL,
      NULL,
      0.141591,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.098273,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      0.675581,
      NULL,
      NULL,
      1,
      1.937750,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.042237,
      0.745838,
      2.498478,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.892858,
      NULL,
      NULL,
      3,
      8.119734,
      3.225986,
      3.703096,
      1.585160,
      1.917371,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      1.623469,
      0.443196,
      0,
      NULL,
      1,
      2,
      0,
      0.604929,
      0.007506,
      3.846927,
      1,
      0.075811,
      0.517478,
      1.208546,
      1.018000,
      0.587323,
      NULL,
      3.604870,
      NULL,
      2,
      NULL,
      0.808099,
      NULL,
      1.806618,
      NULL,
      1.354532,
      NULL,
      10.345989,
      NULL,
      0,
      11,
      NULL,
      3.389176,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.131268,
      NULL,
      0.974623,
      NULL,
      3,
      NULL,
      0.305587,
      NULL,
      0.235989,
      NULL,
      2,
      NULL,
      0.679573,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.307136,
      NULL,
      1,
      NULL,
      0.225970,
      NULL,
      1,
      0.117823,
      1,
      3.617247,
      NULL,
      0,
      NULL,
      1.489501,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.161573,
      NULL,
      0.866295,
      NULL,
      0,
      1.988231,
      1.221927,
      NULL,
      1.524732,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.552709,
      NULL,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.067459,
      NULL,
      1.552108,
      NULL,
      2.053611,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      1.423354,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988636,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.415853,
      1.961534,
      1,
      NULL,
      0.578665,
      NULL,
      1,
      NULL,
      503.413812,
      NULL,
      3,
      NULL,
      1,
      NULL,
      2.430991,
      1.154628,
      2,
      12.450441,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.499774,
      0.283481,
      1,
      0,
      1,
      0,
      0.983158,
      0,
      0,
      1,
      NULL,
      2,
      1,
      0.131988,
      1,
      1.111678,
      0,
      3,
      1.165135,
      NULL,
      1.598106,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      2.288507,
      0.541468,
      1,
      1,
      0.183962,
      NULL,
      0.966002,
      0.452847,
      0.292371,
      NULL,
      1,
      2,
      0.868192,
      0.190623,
      0,
      NULL,
      3.886634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.722025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      2,
      3,
      3.839780,
      NULL,
      NULL,
      NULL,
      108.195909,
      NULL,
      5,
      0,
      7,
      '31430',
      '41432',
      '12310',
      1.773885,
      '',
      NULL,
      NULL,
      1.075972,
      '',
      '',
      '');
commit;
end;
/


