set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9755023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.323349,
      0.670812,
      NULL,
      3,
      NULL,
      2,
      NULL,
      '02',
      '10443301',
      49.064802,
      3,
      '3103430',
      2.459576,
      0.883573,
      2,
      NULL,
      '3321',
      3,
      1,
      NULL,
      NULL,
      ' 2- 6-1999',
      214,
      159,
      NULL,
      3.578739,
      3.615855,
      ' 8-22-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      0.541454,
      NULL,
      ' 6-10-2002',
      ' 1-24-1982',
      2,
      0.002691,
      1,
      2,
      0.298835,
      2.644350,
      1,
      2,
      NULL,
      NULL,
      NULL,
      10,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.088026,
      0.572113,
      NULL,
      1.919797,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.877732,
      0.097288,
      3,
      0.603202,
      1.845088,
      0,
      0.107788,
      6.850597,
      NULL,
      2.640738,
      NULL,
      NULL,
      4.811273,
      1.429159,
      NULL,
      NULL,
      NULL,
      1.468078,
      3,
      3,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      6.134414,
      3,
      0.759114,
      3,
      1,
      0.041583,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3.221208,
      1.297935,
      3.562834,
      2.365966,
      1,
      0.771601,
      1,
      7.929428,
      1.517937,
      1,
      2.450838,
      0.405748,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      3.079575,
      0.302102,
      4.114391,
      7,
      1.315980,
      5.317756,
      0.947235,
      3,
      0.198937,
      1.148321,
      0.103898,
      1,
      0.415078,
      NULL,
      1.551989,
      1,
      6.980557,
      1,
      6.489166,
      0.179776,
      2.792540,
      2.321338,
      1.000274,
      NULL,
      1.803964,
      5,
      4,
      NULL,
      9.045580,
      2.981588,
      NULL,
      0,
      9,
      NULL,
      6,
      3,
      NULL,
      6.844288,
      0.869336,
      5.410837,
      0.063167,
      0.417477,
      ' 2- 3-1976',
      219,
      ' 7- 1-1985',
      NULL,
      2.368249,
      0,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183077,
      0.288078,
      0.531979,
      1.532523,
      NULL,
      3,
      3.948562,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.809308,
      NULL,
      0,
      0.090885,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.635058,
      1.986055,
      3.892640,
      NULL,
      0.031871,
      1,
      2.479903,
      1.710198,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291826,
      0.935699,
      1.940604,
      2,
      1.719451,
      0,
      1.199143,
      0.042140,
      1.317704,
      2.988319,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.124361,
      2.546171,
      NULL,
      1,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.525943,
      NULL,
      NULL,
      0.026064,
      0.529909,
      0,
      2.905782,
      0,
      0,
      0.188981,
      0.009898,
      0.634437,
      0,
      1,
      NULL,
      0.954615,
      0.219820,
      0.203176,
      1,
      9.020798,
      6,
      6,
      2.276887,
      7,
      2,
      NULL,
      3,
      5.217473,
      3,
      2.873748,
      NULL,
      9.360520,
      2.356659,
      1.428080,
      NULL,
      NULL,
      NULL,
      NULL,
      5.303094,
      3,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      3,
      NULL,
      10,
      30.899330,
      1.552696,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.813382,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      3.898771,
      1,
      1.368126,
      1,
      0,
      1.307322,
      1,
      0.585404,
      1,
      2.757482,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4.915286,
      1.611525,
      1.644172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.038518,
      NULL,
      3,
      NULL,
      NULL,
      1.037033,
      3.273815,
      1.144193,
      3.034646,
      0,
      3,
      1.769284,
      0,
      1,
      1.702800,
      NULL,
      0,
      1.257058,
      1,
      0.631358,
      3.501906,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.135420,
      NULL,
      NULL,
      0,
      1.950101,
      6,
      1.716698,
      1.484602,
      NULL,
      NULL,
      NULL,
      1.287430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.583777,
      0,
      2,
      2.896240,
      NULL,
      0.005340,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      7.901887,
      0,
      5,
      NULL,
      NULL,
      NULL,
      0.657010,
      NULL,
      NULL,
      0.894221,
      NULL,
      NULL,
      1.376584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.340035,
      NULL,
      2,
      3.571572,
      0.300625,
      0.653858,
      4,
      1.972058,
      NULL,
      8,
      NULL,
      5.121234,
      5,
      NULL,
      1.337940,
      3,
      0.024238,
      1.236231,
      NULL,
      0,
      3.292616,
      NULL,
      1.811707,
      NULL,
      7.380163,
      1.958856,
      4.835465,
      NULL,
      3,
      0,
      0.357126,
      NULL,
      3.877726,
      2.826862,
      2,
      2.090629,
      NULL,
      3,
      1.201034,
      NULL,
      1.703149,
      1,
      NULL,
      5.753101,
      4.816013,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0.317765,
      NULL,
      NULL,
      1.042386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426421,
      NULL,
      NULL,
      2.963463,
      NULL,
      NULL,
      0.217041,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.532620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746337,
      1,
      3,
      NULL,
      0.480719,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.505693,
      NULL,
      NULL,
      NULL,
      0.860337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389704,
      NULL,
      NULL,
      NULL,
      2.972349,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.522443,
      NULL,
      NULL,
      NULL,
      2.509635,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0.835253,
      4,
      0.208699,
      40.228754,
      NULL,
      0.607801,
      NULL,
      NULL,
      1.056586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743141,
      1,
      0.592737,
      NULL,
      1.167677,
      1,
      0,
      NULL,
      NULL,
      1.410014,
      1.063063,
      1,
      1.690660,
      1.993136,
      1.235921,
      0,
      1,
      0.259657,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.540338,
      2.267546,
      2,
      NULL,
      NULL,
      2,
      3,
      0,
      3,
      3,
      NULL,
      2,
      0,
      NULL,
      0,
      3,
      NULL,
      0.015325,
      0,
      NULL,
      1.539703,
      2.449560,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3.463727,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.902031,
      NULL,
      0,
      3,
      NULL,
      0.117341,
      NULL,
      1.689821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.411043,
      NULL,
      NULL,
      NULL,
      3.080031,
      NULL,
      1.731745,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.524153,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.265996,
      NULL,
      3.196020,
      NULL,
      1,
      NULL,
      15.607244,
      0,
      1.833195,
      1.418205,
      NULL,
      0.269162,
      NULL,
      0.461138,
      NULL,
      5.789186,
      1.909078,
      0,
      1,
      NULL,
      NULL,
      60.130823,
      71.878121,
      2.207279,
      2.157625,
      3.768208,
      '4313',
      '',
      '',
      0,
      '',
      '',
      '',
      1.036684,
      NULL,
      '',
      '');
commit;
end;
/


