set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9755023';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      2,
      2.792707,
      0,
      0,
      3,
      3.486189,
      '133',
      '32444243',
      36.105732,
      31.294014,
      '3433332',
      NULL,
      NULL,
      3,
      0,
      '1201',
      5.888587,
      0.223690,
      NULL,
      NULL,
      ' 6- 9-1997',
      176,
      200.800580,
      NULL,
      2,
      1.031968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 1-2000',
      NULL,
      1,
      3,
      0.312245,
      1.311124,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      6.036454,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.678204,
      1,
      2,
      5,
      0.067994,
      NULL,
      5.939665,
      0.074472,
      1.893703,
      1.489783,
      0,
      0.419992,
      NULL,
      0,
      0.532516,
      4.414067,
      0,
      3,
      1.107610,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.045972,
      1,
      NULL,
      1,
      3.017062,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790761,
      NULL,
      0,
      3,
      1.559790,
      NULL,
      1,
      NULL,
      0.340812,
      0,
      7.429245,
      1.880776,
      3,
      0,
      1,
      NULL,
      NULL,
      1.499971,
      NULL,
      NULL,
      0.088063,
      1,
      NULL,
      1.744712,
      0,
      NULL,
      1.702637,
      NULL,
      0.687915,
      1.553045,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1.346536,
      0,
      1.853064,
      NULL,
      1.599721,
      1.577023,
      0,
      NULL,
      NULL,
      0.425432,
      5.583050,
      2,
      0,
      0,
      1.671625,
      1,
      NULL,
      2,
      1,
      1,
      1.952268,
      0,
      2.905909,
      5,
      NULL,
      5,
      4.049624,
      4,
      1,
      0,
      1.287355,
      1.539283,
      NULL,
      NULL,
      ' 3-21-1988',
      606,
      2,
      0,
      NULL,
      NULL,
      1.018159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912667,
      1,
      NULL,
      1.595970,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511761,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.156894,
      1.830555,
      1,
      1.274338,
      0.214332,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.898837,
      0.388901,
      1.733716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.495626,
      0,
      0.056795,
      1,
      1,
      NULL,
      NULL,
      1.656707,
      NULL,
      3.224845,
      1.821428,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.827903,
      NULL,
      3,
      0.984130,
      0,
      2,
      2.091311,
      1.505550,
      0,
      0.422340,
      0.601611,
      2.460087,
      1.251523,
      NULL,
      1,
      0,
      1,
      NULL,
      0.847264,
      0,
      0,
      0,
      1,
      1.754059,
      NULL,
      1,
      1,
      0.204980,
      NULL,
      NULL,
      9,
      11.348055,
      3.315591,
      7,
      3.826502,
      NULL,
      0,
      0.155987,
      1,
      3.363710,
      2,
      NULL,
      8.978195,
      0.133584,
      1.465974,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.571766,
      2,
      '41034',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '2412',
      '',
      '',
      3,
      27,
      63,
      NULL,
      1.153235,
      NULL,
      0.453541,
      1,
      4.487278,
      3,
      0,
      2,
      1.608102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      3,
      NULL,
      2,
      0,
      2,
      0,
      1,
      0.047535,
      0.817230,
      1,
      2.007900,
      0,
      NULL,
      3,
      0.353138,
      0,
      NULL,
      2,
      2.986875,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.819577,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      0,
      2,
      1.797057,
      0,
      2.952715,
      0.969947,
      NULL,
      0,
      1,
      2.650656,
      1.834401,
      1.150877,
      0,
      1.422571,
      NULL,
      NULL,
      3,
      1.420512,
      NULL,
      0,
      0.914228,
      2.331696,
      1.218829,
      NULL,
      NULL,
      1.675471,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2.686819,
      1.868825,
      1,
      NULL,
      NULL,
      NULL,
      0.420883,
      NULL,
      NULL,
      NULL,
      0.159956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.010882,
      NULL,
      3,
      NULL,
      1,
      5.686204,
      0.148228,
      0.427060,
      0.130515,
      NULL,
      2.219410,
      1,
      NULL,
      NULL,
      NULL,
      3.044209,
      4,
      1.972583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637856,
      NULL,
      NULL,
      1.540213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.107824,
      0.742276,
      0,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.322899,
      1.788251,
      1.798291,
      1.174328,
      3,
      1.440085,
      NULL,
      0.912972,
      NULL,
      3,
      2,
      NULL,
      7.476955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609517,
      2.307800,
      3.689423,
      2,
      1.635517,
      3.503855,
      3,
      3,
      1.248121,
      7.107213,
      1.642869,
      3,
      6.934475,
      1,
      2.238675,
      0.630467,
      NULL,
      2,
      NULL,
      1.524637,
      0.022389,
      0,
      0,
      2,
      NULL,
      NULL,
      1.435395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784588,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904292,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.932539,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649818,
      0.473589,
      NULL,
      NULL,
      1.054871,
      NULL,
      NULL,
      NULL,
      NULL,
      3.184406,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.419377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153037,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.959001,
      NULL,
      NULL,
      NULL,
      1.538136,
      NULL,
      NULL,
      NULL,
      2.541711,
      NULL,
      NULL,
      NULL,
      0.105890,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      1.876767,
      2,
      6,
      2.644564,
      NULL,
      1.258776,
      NULL,
      6.126529,
      2.676416,
      1.558640,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.993584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0.042915,
      1.104775,
      NULL,
      NULL,
      0.408004,
      1.372157,
      0.247205,
      1.331787,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1.423869,
      0.270563,
      1.467270,
      1.289835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.276408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.397453,
      1.226733,
      5,
      0.845561,
      NULL,
      2.728870,
      3,
      1,
      1.369833,
      1.074939,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3.015867,
      NULL,
      NULL,
      NULL,
      0.373813,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.229003,
      NULL,
      NULL,
      0.929911,
      1,
      NULL,
      0.005828,
      1.881754,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.325772,
      1.779507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.629868,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.626725,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.565341,
      NULL,
      1.339141,
      NULL,
      0.934359,
      NULL,
      0.414528,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.181379,
      1,
      NULL,
      3.931279,
      NULL,
      0.522657,
      NULL,
      NULL,
      6.740137,
      3.645299,
      0,
      NULL,
      NULL,
      74,
      33,
      1,
      NULL,
      NULL,
      '00421',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      3.597306,
      '4220',
      NULL,
      '');
commit;
end;
/


