set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9520988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '0213420',
      2.388595,
      0.111076,
      1,
      2,
      '2020',
      0,
      0.989652,
      NULL,
      NULL,
      ' 9- 9-2000',
      41.754552,
      NULL,
      NULL,
      0,
      3.980538,
      ' 9-19-1986',
      30.398817,
      NULL,
      4,
      88.645834,
      NULL,
      ' 4-24-1999',
      ' 4-15-1978',
      ' 4- 0-1982',
      1.760274,
      NULL,
      3,
      NULL,
      NULL,
      0.952591,
      2.120261,
      3,
      NULL,
      NULL,
      NULL,
      13,
      1,
      25.934682,
      0.899770,
      NULL,
      14,
      9,
      3,
      1,
      NULL,
      0.858636,
      NULL,
      NULL,
      0,
      1.897318,
      1,
      4.845490,
      NULL,
      1.913488,
      0.796060,
      0,
      5.515694,
      2,
      2.880264,
      2,
      0.140649,
      7.361868,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      0.411677,
      NULL,
      NULL,
      1,
      0.448870,
      5.610092,
      0.418900,
      0.286092,
      1.927659,
      NULL,
      NULL,
      0.545922,
      NULL,
      NULL,
      6,
      0.011767,
      4,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      2,
      3,
      1.681818,
      0,
      1,
      2.244113,
      1.153483,
      1,
      3,
      3.838566,
      0,
      0,
      2.855912,
      7,
      0.482617,
      0,
      5.305255,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.719055,
      3.164333,
      4,
      0.534726,
      0.385113,
      0,
      1,
      0.727803,
      1.004191,
      0.724066,
      1.580691,
      1.521493,
      1,
      1.412424,
      1.350488,
      0,
      0,
      1,
      1.049226,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0.646217,
      NULL,
      6,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      9,
      NULL,
      2.892980,
      3,
      5.967909,
      1,
      3.121613,
      9.729991,
      6,
      4,
      9,
      6,
      0.862682,
      '10-15-1995',
      NULL,
      '10-22-2001',
      69.449015,
      3,
      1,
      3.347255,
      2.021217,
      1.763881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781306,
      1.845649,
      1,
      NULL,
      1,
      0.121098,
      0,
      1.748286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.810314,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.163233,
      0.839607,
      3,
      4.859817,
      0.076970,
      3,
      0.034618,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.869526,
      0.012134,
      0,
      0,
      0,
      0.838930,
      2,
      6.802214,
      1.084627,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.786869,
      1.369159,
      1,
      2,
      NULL,
      1.394710,
      NULL,
      0.498498,
      NULL,
      2.253441,
      2,
      0,
      1.293119,
      1.526648,
      2,
      1.579230,
      2.414022,
      0.811139,
      0.742914,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.532329,
      NULL,
      0,
      NULL,
      2.484365,
      2.680727,
      1,
      2.526194,
      NULL,
      NULL,
      3.184649,
      1,
      NULL,
      NULL,
      3.960609,
      22.010688,
      1,
      0.002337,
      NULL,
      NULL,
      4,
      45.385612,
      0.076310,
      5.574684,
      4,
      NULL,
      '41300',
      '',
      1.418347,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2.625850,
      17,
      2,
      12.289518,
      3.094049,
      23.430927,
      5,
      0.155661,
      NULL,
      2.296044,
      1,
      NULL,
      0.749285,
      NULL,
      NULL,
      1.982316,
      2,
      0.022140,
      1.235488,
      3,
      0,
      2.270175,
      2.174768,
      2.180970,
      1.095713,
      1.374323,
      NULL,
      2.513273,
      2.443345,
      2,
      0.052924,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.080431,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.930697,
      NULL,
      1.340376,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.203313,
      NULL,
      NULL,
      NULL,
      1.565884,
      2.718987,
      3,
      0.109344,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.479593,
      2.302200,
      2.631040,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      0,
      1,
      0.648283,
      3.700095,
      2,
      2.087746,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.104043,
      NULL,
      NULL,
      1,
      5.541809,
      1,
      NULL,
      1.138427,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.359825,
      NULL,
      NULL,
      3,
      3.608702,
      NULL,
      1,
      3.714143,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242224,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.533195,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.256680,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.795104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675555,
      NULL,
      NULL,
      0.906669,
      NULL,
      NULL,
      8.943678,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.204227,
      3,
      2.034289,
      1.162927,
      2,
      0,
      4,
      8.211903,
      0.333913,
      1,
      3,
      1.312442,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.006329,
      1,
      0.725204,
      NULL,
      6,
      4,
      1,
      NULL,
      7,
      7.502927,
      0.009328,
      2,
      4.250695,
      NULL,
      1.394635,
      1.473592,
      0.078777,
      0.711695,
      3.256720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.849493,
      NULL,
      NULL,
      0.498287,
      NULL,
      NULL,
      0.912328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.319803,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.488382,
      NULL,
      1,
      1.321606,
      3,
      0.953846,
      NULL,
      NULL,
      0.961077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.409402,
      NULL,
      NULL,
      NULL,
      2.797856,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.203491,
      NULL,
      NULL,
      NULL,
      0.371277,
      NULL,
      NULL,
      NULL,
      3,
      27,
      1.072189,
      NULL,
      0,
      3.461859,
      0.140036,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.627697,
      NULL,
      0.922886,
      294.378106,
      1.417496,
      0,
      0.714761,
      0.989272,
      0,
      0,
      1.811497,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.802186,
      0,
      1.663890,
      1.635903,
      0,
      1,
      0,
      NULL,
      1.079323,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.913517,
      NULL,
      0.687751,
      NULL,
      15.454478,
      NULL,
      2.761599,
      25,
      3.376141,
      1.803014,
      2,
      1.547595,
      NULL,
      0.842944,
      NULL,
      1.953095,
      NULL,
      1.116678,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.779506,
      NULL,
      0.873911,
      NULL,
      1.970307,
      NULL,
      1,
      NULL,
      0.205330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.137159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.874852,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.034599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.524453,
      2.377546,
      NULL,
      1,
      NULL,
      1.198562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.162080,
      NULL,
      1.023576,
      NULL,
      NULL,
      NULL,
      0.556290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396070,
      3.468368,
      NULL,
      3.671841,
      NULL,
      0,
      NULL,
      73,
      NULL,
      0.989320,
      2.227574,
      NULL,
      1,
      NULL,
      1.392428,
      2.555066,
      NULL,
      17,
      0.485929,
      NULL,
      NULL,
      0.537621,
      0.903380,
      NULL,
      0,
      NULL,
      10.649379,
      1,
      NULL,
      0.317694,
      NULL,
      3.207778,
      3.542876,
      1.497776,
      0,
      3,
      3.523768,
      4.227340,
      5.712166,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149570,
      NULL,
      3.736809,
      NULL,
      NULL,
      2.349255,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.246888,
      NULL,
      0.354320,
      0,
      NULL,
      0.577625,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3.301579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408322,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.912795,
      1.997254,
      NULL,
      NULL,
      60,
      NULL,
      NULL,
      NULL,
      3,
      '01341',
      NULL,
      NULL,
      1.496023,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


