set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7413272';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4130422',
      0.712648,
      1,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      ' 1-28-1998',
      9.289571,
      NULL,
      0.547710,
      3,
      1,
      NULL,
      NULL,
      2,
      1.330298,
      89.100464,
      1.957563,
      NULL,
      NULL,
      ' 7-15-2001',
      1.180473,
      0,
      NULL,
      0.368352,
      NULL,
      2,
      1,
      0,
      1.275438,
      14,
      NULL,
      19.849802,
      1,
      99,
      84,
      4.301921,
      13.443100,
      5,
      1.760960,
      3.701096,
      NULL,
      NULL,
      NULL,
      0,
      0.176777,
      1,
      1,
      1.630601,
      NULL,
      0,
      NULL,
      NULL,
      0.371371,
      2.306213,
      0,
      0.257040,
      NULL,
      1.511911,
      1,
      0.286853,
      NULL,
      1.044868,
      0,
      0,
      NULL,
      0,
      1.378584,
      0.566244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793410,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.565579,
      NULL,
      1.278223,
      0.794699,
      1.618399,
      4.079586,
      0,
      1.408946,
      NULL,
      NULL,
      0.837634,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.452584,
      0.383391,
      0,
      0,
      0.743693,
      0.278627,
      1,
      0.215935,
      1.261354,
      1.147196,
      NULL,
      NULL,
      0,
      0.112041,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.669642,
      2.793392,
      1.263483,
      NULL,
      3.054080,
      3,
      0.726785,
      0.853675,
      0.522840,
      1.897204,
      0,
      1.482698,
      7.888364,
      4,
      1.344432,
      0.066162,
      4,
      3,
      NULL,
      3,
      1.314373,
      1.607772,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763453,
      0.705641,
      3.604264,
      0,
      NULL,
      0,
      0.734634,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.789980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.088501,
      2,
      2.671778,
      1,
      NULL,
      NULL,
      1.257749,
      2.382234,
      1.413530,
      NULL,
      0,
      1.576037,
      NULL,
      NULL,
      NULL,
      0,
      1.007504,
      1.495020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.982789,
      NULL,
      1,
      1,
      NULL,
      0.024182,
      49.136373,
      NULL,
      1.737910,
      NULL,
      NULL,
      NULL,
      3.874516,
      0,
      0.387688,
      2,
      0.939314,
      2,
      0.414268,
      NULL,
      3.320852,
      2.135103,
      NULL,
      1,
      1,
      0.227577,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.800940,
      0.066692,
      NULL,
      3,
      1,
      1.064416,
      0.910486,
      NULL,
      0.725195,
      3,
      1.641581,
      NULL,
      0.911702,
      9.077998,
      NULL,
      2.075596,
      NULL,
      0,
      4,
      1,
      0,
      3,
      0.263947,
      1.166505,
      3.774948,
      43,
      NULL,
      3,
      NULL,
      27.603630,
      104,
      NULL,
      2,
      0,
      0.869285,
      '22133',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      0.699815,
      7.467254,
      167,
      24,
      2,
      2,
      0.548715,
      11.915898,
      NULL,
      1,
      NULL,
      NULL,
      0.898426,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.725180,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.685445,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.423993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114054,
      NULL,
      NULL,
      0.395498,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527918,
      1.101304,
      0,
      1.508418,
      NULL,
      NULL,
      2,
      2.343511,
      0,
      3.829912,
      1.511607,
      0,
      1.521597,
      0,
      1.742811,
      0.052723,
      2.206962,
      0.886528,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.057590,
      1.967964,
      1.264921,
      1.125434,
      NULL,
      NULL,
      NULL,
      1.316944,
      NULL,
      NULL,
      4,
      0.569341,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.529018,
      0.652964,
      0.063840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.532946,
      1.777062,
      NULL,
      NULL,
      3.561637,
      1.450154,
      NULL,
      0.685785,
      NULL,
      NULL,
      0.472486,
      NULL,
      NULL,
      0.093432,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.283080,
      NULL,
      NULL,
      1.280723,
      NULL,
      NULL,
      0.040153,
      NULL,
      NULL,
      0.572449,
      NULL,
      NULL,
      NULL,
      2,
      2.259751,
      1,
      NULL,
      NULL,
      8.609469,
      NULL,
      2,
      6,
      2,
      5.590271,
      3,
      NULL,
      NULL,
      0.744041,
      NULL,
      NULL,
      0,
      NULL,
      2.798053,
      0.558142,
      2,
      2,
      2,
      3,
      0,
      NULL,
      2.848775,
      0.647523,
      0.265247,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      4,
      5.236701,
      NULL,
      NULL,
      3.504047,
      0,
      0,
      2,
      2.894302,
      1.835986,
      2.583392,
      1,
      0.005003,
      1,
      3,
      NULL,
      NULL,
      11.230440,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.220604,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.178447,
      NULL,
      NULL,
      2.691906,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.101589,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9.745302,
      NULL,
      NULL,
      2.264213,
      NULL,
      0,
      NULL,
      1.469576,
      1,
      NULL,
      NULL,
      0.262470,
      7.165005,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.021155,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.130106,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.943190,
      NULL,
      NULL,
      NULL,
      1.153147,
      NULL,
      NULL,
      NULL,
      2.985335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883269,
      NULL,
      NULL,
      NULL,
      1.451051,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.259020,
      NULL,
      NULL,
      NULL,
      3.545000,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      5.037811,
      NULL,
      3,
      3,
      9.527566,
      2,
      3.258572,
      NULL,
      37,
      2.953530,
      13,
      32,
      NULL,
      NULL,
      NULL,
      0.830673,
      NULL,
      NULL,
      0.476664,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.053978,
      NULL,
      1,
      4600.283315,
      1421,
      0.602148,
      0,
      1,
      NULL,
      0.833891,
      1,
      0.829865,
      0.618996,
      0.515904,
      0.592699,
      NULL,
      1.517523,
      0.018479,
      1,
      0,
      1,
      0.945047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.109229,
      1.427440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.122628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.346412,
      NULL,
      3.976719,
      NULL,
      8,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.693592,
      NULL,
      3.531908,
      1.054691,
      1.220877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.847597,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.000436,
      NULL,
      0,
      NULL,
      284.763010,
      NULL,
      3.609772,
      NULL,
      1.216002,
      NULL,
      0.699187,
      1.083379,
      3.167159,
      30.543403,
      33,
      0.837574,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      0.237163,
      NULL,
      0.961020,
      1,
      2.116920,
      0,
      0.699930,
      0.037723,
      1,
      2,
      3,
      NULL,
      1.422005,
      NULL,
      0.974539,
      1,
      0.391035,
      3.749503,
      2,
      2.044416,
      0,
      1,
      NULL,
      1,
      1,
      0.326938,
      1,
      0.404026,
      1,
      0.988923,
      1,
      1.259920,
      0,
      1,
      3,
      1,
      1.868858,
      1,
      NULL,
      1.120664,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.884495,
      0,
      2.780595,
      1.258808,
      0,
      1.006275,
      1.616980,
      2,
      1,
      0,
      1,
      1.386799,
      2.196469,
      0,
      3.822312,
      1,
      1,
      NULL,
      1.044931,
      1,
      1.335416,
      NULL,
      3,
      0,
      0,
      0,
      1.006025,
      NULL,
      0.202170,
      1,
      1,
      0,
      2,
      NULL,
      1.546145,
      1,
      3.472859,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      103,
      46.225007,
      NULL,
      1,
      2.273316,
      '44104',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.943828,
      NULL,
      '',
      '');
commit;
end;
/


