set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9539650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      0,
      3,
      0.955289,
      0,
      3.742572,
      2.734923,
      '244',
      '22140230',
      61.788335,
      NULL,
      '1114442',
      NULL,
      NULL,
      3,
      1,
      '0023',
      4.776290,
      NULL,
      NULL,
      NULL,
      ' 7- 0-1986',
      NULL,
      43,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '10-11-1994',
      ' 8- 9-1984',
      NULL,
      2,
      0,
      1,
      0.527521,
      0.896034,
      2,
      2.960598,
      NULL,
      NULL,
      NULL,
      NULL,
      0.968544,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.655214,
      1.567199,
      1.304699,
      NULL,
      0,
      1,
      0.597904,
      NULL,
      2.172651,
      1,
      0,
      3.951171,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.784081,
      0.452714,
      1,
      NULL,
      5.429146,
      1,
      0,
      NULL,
      0.181551,
      1,
      1,
      NULL,
      0,
      1.950912,
      2.800449,
      0.645114,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.692424,
      1,
      0.814481,
      NULL,
      NULL,
      1.328680,
      NULL,
      2.879437,
      1.097263,
      NULL,
      0,
      1,
      0.317234,
      NULL,
      NULL,
      0,
      3.342496,
      3,
      2.342068,
      1,
      1.083252,
      2.470547,
      2,
      0.165585,
      0.188251,
      1.563006,
      0.562716,
      NULL,
      NULL,
      0.165343,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.171862,
      0.733772,
      0.826908,
      NULL,
      1,
      NULL,
      1.127534,
      0,
      1.955835,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.934951,
      NULL,
      0.370045,
      0,
      7,
      2,
      0,
      5,
      0.178700,
      1,
      0,
      1,
      1.480270,
      1,
      7,
      NULL,
      NULL,
      0,
      0.682274,
      7.482869,
      6,
      0,
      1.242596,
      2.926448,
      NULL,
      0.608778,
      NULL,
      140.502150,
      ' 3-14-1984',
      29,
      1,
      NULL,
      1.658796,
      9,
      0.786586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737518,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.484496,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.074422,
      3.692040,
      1.304085,
      NULL,
      NULL,
      NULL,
      2.597333,
      1.844557,
      1,
      3.541589,
      NULL,
      2.084217,
      7.510211,
      2.827413,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.075991,
      NULL,
      0.847946,
      0,
      1,
      1,
      0,
      1,
      11.538723,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3.076818,
      0.925066,
      0.927933,
      NULL,
      NULL,
      2,
      4,
      3,
      2,
      2.683024,
      3.855487,
      NULL,
      0,
      0.551384,
      5.067662,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.468445,
      0.235766,
      0.496283,
      1.066770,
      1,
      2.568047,
      1.693260,
      1.351297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.950267,
      0.460423,
      24,
      NULL,
      26,
      36.329677,
      0,
      4,
      7.407091,
      '3404',
      '22343',
      NULL,
      NULL,
      NULL,
      '',
      '',
      2,
      NULL,
      '',
      '',
      NULL,
      4,
      23,
      10.310065,
      1.709732,
      12,
      NULL,
      1,
      4,
      1.178941,
      1.294192,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.247858,
      1,
      0.766340,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.937189,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      0.223430,
      0.576104,
      1.160050,
      1.903159,
      1,
      NULL,
      NULL,
      NULL,
      0.006828,
      NULL,
      NULL,
      NULL,
      3,
      1.080096,
      3.681740,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.395753,
      NULL,
      3,
      0,
      1.559696,
      0.488165,
      1.387222,
      3,
      0,
      1,
      NULL,
      2,
      2.925246,
      3.858532,
      0,
      1.801778,
      NULL,
      NULL,
      1.271941,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.637600,
      1.714305,
      5,
      0.339416,
      0.511606,
      NULL,
      NULL,
      NULL,
      1.103336,
      NULL,
      NULL,
      NULL,
      1.152702,
      NULL,
      NULL,
      1.112187,
      NULL,
      NULL,
      NULL,
      0,
      3.859736,
      1.636502,
      NULL,
      NULL,
      NULL,
      3.034511,
      1,
      1.178601,
      NULL,
      NULL,
      0.557491,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.963725,
      NULL,
      NULL,
      1.066698,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.431255,
      2.152050,
      0.380816,
      0,
      NULL,
      NULL,
      2,
      5.690692,
      3,
      NULL,
      NULL,
      3.434593,
      0.397631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428733,
      0,
      1,
      2,
      0,
      1,
      0.232723,
      0.031690,
      1,
      1,
      1.299457,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.434364,
      2,
      3.926294,
      NULL,
      0.825337,
      5.118599,
      2.502253,
      0,
      NULL,
      3,
      1.512954,
      NULL,
      NULL,
      0.234609,
      1,
      0.329004,
      1.698125,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427576,
      NULL,
      NULL,
      0,
      0,
      0.037595,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.406245,
      4.995629,
      1.334291,
      1,
      0.750081,
      2.112782,
      5.091984,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.871636,
      NULL,
      NULL,
      0.156038,
      NULL,
      NULL,
      1.711444,
      0,
      0.257260,
      0.503052,
      0.083850,
      0.685556,
      NULL,
      NULL,
      1,
      1.799399,
      0,
      NULL,
      1,
      0.590185,
      0.973808,
      0.654682,
      1,
      1.376271,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.444417,
      NULL,
      3.123881,
      NULL,
      0,
      1,
      NULL,
      3.943673,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.188831,
      0,
      NULL,
      0,
      3,
      NULL,
      3,
      2.708280,
      NULL,
      1.412519,
      0.174308,
      NULL,
      0,
      3.755331,
      NULL,
      1,
      0.902092,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.970016,
      NULL,
      0.460965,
      2.802839,
      NULL,
      1,
      1,
      NULL,
      2.174536,
      0,
      1.039589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026691,
      NULL,
      0.641725,
      NULL,
      NULL,
      NULL,
      NULL,
      2.532973,
      5.601720,
      1.359070,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      5,
      0.747761,
      '4102',
      '33313',
      '44303',
      0.630758,
      '',
      '',
      '',
      NULL,
      '30432',
      '',
      '');
commit;
end;
/


