set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8608370';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '0212022',
      3.619940,
      1,
      0,
      0,
      '4300',
      2.726531,
      1.800223,
      2.518519,
      9.470281,
      ' 0-16-1997',
      10,
      NULL,
      4,
      1,
      0.638786,
      ' 3-15-1982',
      31,
      1,
      254.829964,
      NULL,
      4.181597,
      NULL,
      NULL,
      ' 0-15-2001',
      NULL,
      1.123425,
      2.034392,
      NULL,
      0,
      0,
      1.993913,
      0,
      1,
      31.173075,
      6.105171,
      NULL,
      2.801187,
      NULL,
      NULL,
      NULL,
      24.051798,
      3,
      0.088199,
      9.456331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264650,
      1.405525,
      0,
      NULL,
      1,
      0.791299,
      0,
      NULL,
      1.283262,
      0,
      NULL,
      NULL,
      1.547011,
      1.437444,
      0.114622,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019988,
      0,
      0.342066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.807187,
      NULL,
      3.341697,
      NULL,
      1.823041,
      1.766730,
      1.143936,
      0.488195,
      1.068024,
      1,
      1,
      0,
      1,
      0.716652,
      NULL,
      0.608350,
      1.013605,
      NULL,
      NULL,
      0.880869,
      7,
      1,
      1.443412,
      0,
      0,
      4.203199,
      6.702201,
      6.062146,
      2,
      4.814600,
      NULL,
      NULL,
      0.663012,
      1,
      1.756405,
      2,
      5,
      2,
      8.734099,
      11.068569,
      1,
      6,
      9.239251,
      0.346713,
      0,
      0,
      1.842688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.814779,
      1,
      1,
      0.864733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      1.807791,
      1,
      NULL,
      NULL,
      NULL,
      0.881059,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.353561,
      0,
      0.845760,
      0,
      NULL,
      0.734638,
      0.067119,
      0.957713,
      NULL,
      NULL,
      0.042559,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091427,
      2.355534,
      1,
      3,
      2,
      1,
      3,
      1.007724,
      0,
      1.500145,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005757,
      0.866436,
      0.442455,
      3,
      3.735443,
      NULL,
      NULL,
      1.221764,
      1.263034,
      0.538441,
      NULL,
      0,
      1.227788,
      0.884798,
      0.614248,
      1.539957,
      NULL,
      7,
      NULL,
      4.502709,
      11,
      0,
      5,
      2,
      7,
      2.629335,
      3,
      NULL,
      38.019341,
      NULL,
      1.548187,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      0,
      '14232',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      17,
      NULL,
      14.705850,
      3.754207,
      32,
      13.117901,
      17,
      1.160193,
      3,
      4,
      0.977082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.956715,
      0,
      NULL,
      2.178494,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.492788,
      NULL,
      NULL,
      1.973060,
      NULL,
      NULL,
      3.039437,
      4,
      0,
      1.741308,
      1,
      NULL,
      NULL,
      NULL,
      1.437149,
      NULL,
      NULL,
      NULL,
      3.037328,
      2,
      1,
      0.842614,
      NULL,
      NULL,
      2.493489,
      NULL,
      NULL,
      2,
      2.696683,
      NULL,
      1.629662,
      0.218338,
      1.271154,
      1.950423,
      1,
      1.712157,
      1.515796,
      1,
      0,
      1.825350,
      0.052993,
      0.799471,
      0,
      0.047670,
      NULL,
      NULL,
      0.932175,
      NULL,
      NULL,
      0.049254,
      0.811375,
      NULL,
      NULL,
      1.087962,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.945068,
      2.931063,
      0.632207,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.945463,
      2.701385,
      2,
      1.635512,
      NULL,
      10,
      NULL,
      1.711338,
      3,
      3,
      0,
      2.478449,
      1,
      NULL,
      2,
      0,
      NULL,
      5.734131,
      NULL,
      1,
      NULL,
      NULL,
      1.460975,
      NULL,
      NULL,
      0.793250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.781800,
      0,
      2.767141,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.682377,
      3.532448,
      1.899912,
      2.431603,
      0.952639,
      3,
      0,
      0,
      4,
      NULL,
      2,
      NULL,
      1.588194,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1.104700,
      0.794064,
      2,
      7.517558,
      8.936051,
      0,
      1,
      1,
      1.021100,
      1,
      3.224994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.581853,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493889,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.083762,
      NULL,
      NULL,
      2.571400,
      NULL,
      NULL,
      0.122658,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      2,
      0.814310,
      0.313253,
      2,
      4.844486,
      NULL,
      0,
      1.215798,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.327733,
      NULL,
      NULL,
      0.841991,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.448281,
      NULL,
      0,
      0,
      NULL,
      NULL,
      16.791710,
      NULL,
      NULL,
      NULL,
      5.562331,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      1.267685,
      NULL,
      3,
      0.467282,
      NULL,
      NULL,
      1,
      0,
      0.529566,
      NULL,
      3,
      2.548542,
      2.930935,
      NULL,
      0.627222,
      0.469033,
      0,
      NULL,
      NULL,
      NULL,
      0.882043,
      NULL,
      1.685803,
      1,
      1.109864,
      NULL,
      NULL,
      0,
      7,
      NULL,
      4,
      5.631465,
      2,
      NULL,
      3,
      3,
      5.516389,
      1.500141,
      3,
      215,
      2.791881,
      1,
      1859,
      1671.975906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039850,
      704,
      541,
      NULL,
      NULL,
      NULL,
      0.484952,
      33,
      0,
      46,
      2.234290,
      0.277529,
      2.785147,
      0,
      0,
      1,
      0.306816,
      1.279100,
      0,
      0.498393,
      1,
      1,
      0,
      1.759037,
      NULL,
      1,
      0,
      1.126623,
      3.256695,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.788013,
      NULL,
      1.647132,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.005849,
      1.700800,
      1.259623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.129723,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868696,
      0.860373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825749,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.226995,
      3.809686,
      NULL,
      3,
      NULL,
      0.418344,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.772905,
      NULL,
      0.829782,
      1.776224,
      0.929132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.251678,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.817929,
      0,
      NULL,
      0.330176,
      NULL,
      2,
      1,
      1,
      0.434294,
      1.206840,
      1.328339,
      0.394378,
      1.331609,
      2,
      0,
      NULL,
      0,
      1,
      0.795610,
      0,
      1,
      0,
      NULL,
      1.040897,
      NULL,
      NULL,
      2.508793,
      1,
      1.647768,
      0,
      0.932365,
      3.147507,
      0,
      1,
      3,
      0,
      1,
      2.848686,
      NULL,
      0.322493,
      3.621062,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0.612421,
      0.698975,
      NULL,
      9,
      5.818325,
      3,
      1,
      1.868882,
      23,
      37.627297,
      1.871467,
      0.343864,
      3,
      '33330',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


