set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5409332';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '4211114',
      3.243166,
      1.851154,
      NULL,
      1,
      '2432',
      0.610706,
      2,
      3,
      NULL,
      ' 8-22-2001',
      28.675265,
      NULL,
      1,
      2.863725,
      0.256040,
      NULL,
      NULL,
      1.824250,
      200,
      97.204234,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289872,
      1.996994,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.885771,
      146.106005,
      NULL,
      7,
      15,
      28.123843,
      58,
      NULL,
      5.382073,
      NULL,
      8,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1.292557,
      NULL,
      106,
      0,
      0,
      1,
      3.043624,
      2,
      2,
      3,
      1,
      1.472000,
      0.976992,
      1,
      NULL,
      1.090593,
      1,
      3,
      1.785201,
      0.603504,
      0,
      NULL,
      1.245801,
      1.368049,
      2,
      0,
      0,
      0.835482,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399050,
      0.595320,
      2.860544,
      1.541243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.554060,
      0.384505,
      1.200622,
      NULL,
      1.901970,
      0.941361,
      0.245864,
      3.689479,
      1,
      1.423266,
      5,
      1.929074,
      2.908065,
      0.785685,
      0.381445,
      0,
      NULL,
      0.235181,
      NULL,
      0,
      5.200852,
      NULL,
      0.085567,
      5.717491,
      0.107776,
      7,
      2,
      1.506084,
      3.361339,
      7.570495,
      NULL,
      3.413466,
      NULL,
      2,
      NULL,
      7.464807,
      0,
      NULL,
      0.725892,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      1.775745,
      3.602859,
      NULL,
      979,
      ' 9-20-1986',
      421,
      1,
      0,
      0.639666,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.911576,
      0,
      NULL,
      0,
      1.257651,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0.023406,
      1.048734,
      0,
      1.154312,
      NULL,
      NULL,
      NULL,
      0,
      0.555409,
      0.258323,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.158683,
      0.105205,
      0.790867,
      0.479923,
      0,
      NULL,
      3.328603,
      4891.835875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.269570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.945275,
      NULL,
      0.790361,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0.689767,
      0.916913,
      16,
      0,
      1.166939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455586,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405679,
      1,
      '42101',
      '41013',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      14.566219,
      NULL,
      20.819446,
      3,
      6.693019,
      3.015256,
      167,
      2,
      3.179518,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.009110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.059020,
      1,
      NULL,
      NULL,
      1.669791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548450,
      NULL,
      NULL,
      0.415270,
      NULL,
      2,
      3.079020,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.798800,
      18,
      NULL,
      18,
      NULL,
      NULL,
      0.577729,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.394212,
      NULL,
      0,
      0,
      1.337843,
      1,
      1,
      1,
      1,
      1,
      3.643267,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1.784969,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.326528,
      NULL,
      NULL,
      NULL,
      0.140212,
      NULL,
      NULL,
      NULL,
      2,
      1.869238,
      NULL,
      3,
      2,
      2.163634,
      NULL,
      NULL,
      3.600236,
      4,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994114,
      NULL,
      NULL,
      3.761630,
      1.029910,
      1.921745,
      1.330628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.663900,
      2.109379,
      NULL,
      4.577880,
      4.780696,
      0.726615,
      2.226764,
      NULL,
      1.801643,
      2,
      2,
      2,
      1,
      9.643105,
      5.745927,
      2,
      5,
      3,
      8.651828,
      7,
      2.418097,
      2,
      2.209444,
      19.098982,
      3,
      1.062364,
      3,
      0,
      3.037470,
      3.944500,
      2.816224,
      5,
      5,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      1,
      3,
      3.109982,
      0.903877,
      NULL,
      2.532514,
      4,
      2,
      6.233094,
      NULL,
      NULL,
      6,
      NULL,
      7.770888,
      5.813381,
      0,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.752651,
      NULL,
      NULL,
      0.828962,
      NULL,
      NULL,
      0.211637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.364830,
      NULL,
      NULL,
      NULL,
      1,
      0.097398,
      1,
      0,
      0.625494,
      1.672243,
      NULL,
      NULL,
      2.515344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.826591,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.497193,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497205,
      NULL,
      NULL,
      NULL,
      3.697377,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.941212,
      212,
      64,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4.443138,
      0.000282,
      NULL,
      NULL,
      0,
      0,
      1.718128,
      1,
      1,
      NULL,
      0.739784,
      0.404366,
      0,
      0.967501,
      1,
      1.712134,
      1,
      0,
      1,
      1,
      1.294096,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.069383,
      3.865452,
      NULL,
      NULL,
      7,
      2.088269,
      4,
      7,
      3.717002,
      2,
      NULL,
      1.482316,
      10.561235,
      NULL,
      1.413021,
      10.866618,
      NULL,
      1,
      17,
      NULL,
      NULL,
      15.766299,
      NULL,
      0,
      3.080406,
      NULL,
      2.083755,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1,
      17,
      NULL,
      3.859559,
      0,
      1.649197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      7.380835,
      10.388668,
      NULL,
      NULL,
      0,
      1,
      28.131334,
      9.844976,
      2.355412,
      0.511873,
      NULL,
      '12103',
      '01342',
      '',
      0.772684,
      '',
      '',
      '',
      0.832904,
      '',
      '',
      '');
commit;
end;
/


