set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      1.999670,
      1,
      0,
      0,
      NULL,
      3.288373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.029612,
      2.099033,
      NULL,
      ' 1-24-1986',
      71.333411,
      NULL,
      337,
      183.708493,
      1.970303,
      ' 6- 6-2002',
      ' 8- 0-1976',
      ' 4- 0-1991',
      0.515439,
      NULL,
      3,
      0,
      NULL,
      2,
      1.459755,
      NULL,
      0.883099,
      82,
      10,
      17,
      0.330138,
      9,
      6,
      NULL,
      9.491539,
      6,
      2.661983,
      1.907842,
      0,
      3,
      1.794430,
      0.119631,
      NULL,
      0,
      NULL,
      0.428995,
      0,
      0,
      1,
      1,
      NULL,
      7,
      2.248418,
      6.295407,
      1.039697,
      1.028830,
      5,
      0.948214,
      0,
      10,
      2,
      1.936137,
      0,
      7,
      3.281980,
      7,
      0,
      NULL,
      3.404057,
      3.730132,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.658414,
      5,
      0,
      1.695812,
      NULL,
      0.974351,
      1.790120,
      1.016738,
      2.605096,
      0,
      0.304821,
      0.592101,
      NULL,
      1.602843,
      1,
      3,
      3.607354,
      3.570218,
      0.106588,
      0.271394,
      5.776954,
      0,
      1,
      3,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0.997687,
      1,
      0.258877,
      NULL,
      0.544761,
      0.675192,
      2.261609,
      1,
      NULL,
      0.821785,
      2.623710,
      1,
      NULL,
      1.873138,
      NULL,
      NULL,
      NULL,
      0.866462,
      3,
      0,
      1.220531,
      0,
      NULL,
      0,
      3,
      NULL,
      5,
      4,
      6.135844,
      5,
      3.669282,
      2,
      3,
      0.578647,
      NULL,
      7,
      4,
      NULL,
      NULL,
      NULL,
      0.261235,
      2.421623,
      0.592495,
      5.002598,
      3.409054,
      '10-19-1990',
      451.660087,
      ' 9- 9-1978',
      NULL,
      1,
      0,
      1.647510,
      6.776997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188643,
      0.824078,
      0.399804,
      1.216031,
      0.845895,
      1.542736,
      0.428601,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.166851,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.130399,
      0.734873,
      0,
      1.076040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187099,
      1.532415,
      1.359083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.987506,
      0.151721,
      NULL,
      0.211394,
      3.576008,
      55,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      2.627478,
      0,
      0.706429,
      1,
      NULL,
      2.085915,
      NULL,
      2.939202,
      NULL,
      3,
      NULL,
      0.456106,
      NULL,
      NULL,
      1,
      0.621359,
      0,
      0,
      1.953553,
      1.610907,
      NULL,
      0.856174,
      NULL,
      0,
      3,
      1,
      6.975834,
      7.778226,
      NULL,
      9,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2.891097,
      2.159507,
      3,
      22,
      1.357428,
      1,
      NULL,
      NULL,
      55.306589,
      NULL,
      0.999523,
      NULL,
      0.556782,
      '40142',
      NULL,
      '',
      0.109125,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      1.914670,
      13,
      166.661427,
      64.901871,
      2.034892,
      81.192961,
      0,
      5,
      0.506596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0.770713,
      1.023896,
      0.618713,
      0.745911,
      1.142361,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      2.982316,
      2.726189,
      7.254365,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.663154,
      NULL,
      NULL,
      NULL,
      2.466031,
      1,
      0,
      3.246875,
      0,
      1,
      1,
      0,
      NULL,
      3,
      NULL,
      0.947354,
      0,
      3,
      NULL,
      1.945563,
      3.872340,
      0,
      2.260884,
      1.016037,
      0.241582,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      2.451466,
      1.312472,
      NULL,
      2.740157,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.319884,
      NULL,
      NULL,
      0.344795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.733578,
      NULL,
      NULL,
      1.405349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.064882,
      NULL,
      NULL,
      0.471794,
      NULL,
      NULL,
      3,
      2,
      1.590417,
      0.137298,
      NULL,
      NULL,
      2.638932,
      0,
      1,
      5.012333,
      7,
      2,
      0.204874,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.367515,
      2.157287,
      2.718883,
      0,
      NULL,
      1.653289,
      3,
      5,
      NULL,
      2.371623,
      2.529271,
      1.903583,
      3.227950,
      0,
      NULL,
      1.903075,
      2.652209,
      3.929876,
      NULL,
      1,
      3,
      1,
      NULL,
      8.120981,
      0.909042,
      2,
      1,
      3,
      3.864864,
      9.612658,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522825,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.534397,
      NULL,
      NULL,
      1.024203,
      1.273402,
      1,
      0,
      0,
      2.516894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.402889,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.111908,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.108746,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.430637,
      NULL,
      NULL,
      NULL,
      3.345887,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.476079,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.068601,
      3.311883,
      9.885843,
      5.344309,
      0.946041,
      5,
      0.823308,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.576908,
      NULL,
      0,
      23.501889,
      1,
      1,
      NULL,
      1.079134,
      1.029785,
      NULL,
      NULL,
      0.371463,
      0.069335,
      0.252828,
      1.779812,
      0,
      1.393709,
      1,
      NULL,
      NULL,
      1.875748,
      1.678862,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.052514,
      1.840094,
      4,
      9.791933,
      1.496696,
      7,
      2.811904,
      1.274142,
      1,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      1.639226,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.837893,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.613220,
      NULL,
      0,
      2.482116,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.413682,
      NULL,
      0,
      1.850749,
      NULL,
      3.184650,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660484,
      NULL,
      0,
      NULL,
      1.730192,
      NULL,
      5,
      12.885331,
      NULL,
      NULL,
      0,
      NULL,
      57,
      20.803267,
      NULL,
      NULL,
      NULL,
      '12421',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


