set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3142333',
      2.033010,
      NULL,
      0,
      3,
      '0121',
      0,
      NULL,
      NULL,
      NULL,
      ' 6-21-1990',
      31,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      78,
      3.750570,
      208,
      96.862366,
      3,
      ' 7-24-1983',
      ' 6- 8-1991',
      ' 6-15-1999',
      NULL,
      NULL,
      1,
      NULL,
      0,
      2.982583,
      1,
      0.900187,
      1,
      NULL,
      10.374534,
      17,
      NULL,
      NULL,
      23.409578,
      6.810126,
      21.611671,
      0.689816,
      NULL,
      4,
      1,
      NULL,
      0,
      1.474849,
      NULL,
      0,
      1.609808,
      NULL,
      NULL,
      0.568218,
      NULL,
      0.200416,
      2,
      2,
      3,
      10,
      1.236008,
      2,
      6,
      1.388409,
      0,
      NULL,
      3.568730,
      0,
      7.912765,
      1,
      4.886571,
      8,
      0.117519,
      1.754134,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3.532631,
      5,
      4.502222,
      5.643616,
      8,
      2,
      3,
      0,
      0.020353,
      2.985436,
      2.135228,
      1.576216,
      0,
      NULL,
      3.095475,
      3,
      NULL,
      NULL,
      2,
      0,
      0.091419,
      1.585229,
      0.561373,
      0,
      2.017709,
      NULL,
      1.800634,
      1.943464,
      0,
      0.736237,
      NULL,
      NULL,
      3,
      0.971808,
      NULL,
      1.076011,
      7,
      3,
      NULL,
      NULL,
      3,
      0,
      0.002347,
      1,
      0,
      1,
      NULL,
      0,
      2,
      1.491786,
      NULL,
      1,
      1.593788,
      1.660839,
      NULL,
      1,
      9,
      NULL,
      NULL,
      3.630822,
      1,
      3,
      2.425058,
      NULL,
      3,
      4,
      6.042555,
      9.362383,
      2.754226,
      0,
      4,
      8.950589,
      NULL,
      5.884835,
      NULL,
      NULL,
      6,
      4.139655,
      3.468683,
      1,
      NULL,
      1,
      1.589654,
      ' 1- 0-1980',
      NULL,
      '11-25-1992',
      1322.201683,
      2,
      5,
      1.556697,
      4.016047,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.713591,
      NULL,
      1.087897,
      0.670550,
      NULL,
      0.529659,
      4,
      0.879854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0,
      2.048642,
      0.421625,
      0.702926,
      1,
      NULL,
      1.475426,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.075707,
      1,
      2,
      7.073585,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      NULL,
      3,
      9,
      4,
      1,
      '10- 4-1995',
      2.645293,
      ' 6-14-1992',
      NULL,
      0.765802,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      0.379499,
      NULL,
      1.691059,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.221715,
      NULL,
      1,
      2.959141,
      3,
      0.957901,
      1.079401,
      2,
      3.767665,
      0,
      0.421850,
      0.600508,
      3,
      NULL,
      2,
      2.440021,
      NULL,
      NULL,
      1.896195,
      0.987345,
      NULL,
      0.749351,
      0.526432,
      0,
      1.008029,
      0,
      1.175148,
      NULL,
      0,
      0,
      NULL,
      1,
      3,
      0,
      0,
      0,
      7.086563,
      1.903604,
      5,
      2.461870,
      1,
      1,
      3,
      0.736598,
      38.737129,
      0.513010,
      1,
      NULL,
      38,
      0,
      77.632739,
      2,
      0.664803,
      0.376687,
      '14233',
      '',
      NULL,
      1.832210,
      NULL,
      NULL,
      '',
      1.065518,
      NULL,
      '',
      '',
      0.295021,
      39,
      13,
      14,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      3,
      3.705309,
      0.317529,
      NULL,
      NULL,
      2.020471,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.531450,
      1.468802,
      1.957226,
      NULL,
      1,
      2,
      0.475463,
      1.526056,
      1.948343,
      NULL,
      0.057444,
      1.724332,
      0,
      0.262382,
      1.132970,
      3.795639,
      NULL,
      2.133114,
      1,
      1.326345,
      1.037511,
      1,
      1.989285,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.532795,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      1,
      1.405607,
      NULL,
      NULL,
      0,
      3.496339,
      1.655192,
      0.838330,
      2,
      NULL,
      0,
      1,
      NULL,
      2.142137,
      1,
      1,
      1.092084,
      0,
      1,
      2.681442,
      3.789688,
      1,
      0.817857,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      0.614788,
      8.210742,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.327004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.542213,
      0.592195,
      NULL,
      3.528831,
      0.780770,
      1,
      2.387656,
      0,
      0.585290,
      6,
      0.945599,
      1.304733,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.997914,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.583025,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.812829,
      3.313949,
      NULL,
      NULL,
      2.045418,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.048772,
      0.916004,
      NULL,
      1.349415,
      NULL,
      5.814581,
      7,
      NULL,
      2,
      0,
      1.651443,
      NULL,
      3.494249,
      3.505601,
      NULL,
      1,
      0,
      0,
      2,
      3.938792,
      2.894510,
      NULL,
      4,
      NULL,
      NULL,
      2,
      2.508859,
      2,
      7.364452,
      1,
      1,
      0.799468,
      1.905252,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.205852,
      NULL,
      NULL,
      1.959993,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.493369,
      1.624089,
      0,
      0,
      1,
      NULL,
      NULL,
      4.988582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.461335,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.686903,
      NULL,
      NULL,
      NULL,
      0.600194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.645310,
      NULL,
      NULL,
      NULL,
      0.931182,
      NULL,
      NULL,
      NULL,
      15.551071,
      NULL,
      NULL,
      NULL,
      2.890204,
      1,
      2.317881,
      NULL,
      1.046697,
      35.635121,
      3,
      0,
      NULL,
      NULL,
      0.041216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.152221,
      NULL,
      NULL,
      0.501857,
      NULL,
      NULL,
      0,
      NULL,
      0.970240,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0.383652,
      0,
      0.696169,
      NULL,
      0,
      0.177336,
      0,
      1.262047,
      NULL,
      NULL,
      1.887859,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.883652,
      2.689281,
      NULL,
      5,
      0,
      1.702317,
      2,
      7.445806,
      2.422109,
      2.560718,
      NULL,
      1,
      1.974748,
      NULL,
      2,
      NULL,
      NULL,
      1.359326,
      NULL,
      NULL,
      0,
      1.573191,
      NULL,
      1.838026,
      0.610436,
      NULL,
      2,
      NULL,
      NULL,
      1.758065,
      1.279396,
      NULL,
      NULL,
      NULL,
      NULL,
      1.881408,
      NULL,
      NULL,
      3.688782,
      3,
      NULL,
      1.141209,
      1,
      NULL,
      3.055429,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827746,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      3.722130,
      10,
      0.105911,
      NULL,
      2.792499,
      65.698236,
      51.507406,
      4,
      1.512598,
      NULL,
      '10103',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


