set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6002143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '0042141',
      3.743117,
      1,
      4,
      1,
      '0311',
      0,
      1.870908,
      NULL,
      NULL,
      ' 7-16-1982',
      NULL,
      NULL,
      1.779042,
      3.984177,
      8.409133,
      ' 7-13-1974',
      13,
      3,
      322.637382,
      12.086536,
      2,
      ' 7-18-1979',
      '10- 7-1991',
      ' 1-22-1975',
      0.937529,
      1,
      NULL,
      NULL,
      1.949736,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      7.959156,
      15.673199,
      3.569254,
      3,
      9.213842,
      1.605929,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1.895176,
      1.861429,
      1.383261,
      2,
      0,
      8.476979,
      5.739041,
      1.710580,
      0.790814,
      1,
      4.033870,
      1.745558,
      1.380765,
      2,
      1,
      0.769840,
      NULL,
      NULL,
      0,
      3,
      2.397886,
      2.130813,
      1,
      NULL,
      NULL,
      0.868474,
      NULL,
      NULL,
      7,
      NULL,
      1.063239,
      2.387441,
      1,
      1,
      3.287367,
      3,
      0.617640,
      3.174040,
      1.401691,
      0.502669,
      NULL,
      3.196190,
      1.925565,
      NULL,
      2,
      1.532927,
      0,
      NULL,
      0,
      1.917807,
      5,
      NULL,
      3.357004,
      NULL,
      0.004422,
      NULL,
      NULL,
      1.312484,
      NULL,
      NULL,
      0,
      1,
      0,
      1.803802,
      1.885650,
      NULL,
      2.923472,
      1.458731,
      1,
      0.840622,
      NULL,
      2.740211,
      1.817730,
      3,
      0,
      1.707555,
      1,
      0,
      1,
      NULL,
      1,
      4.953981,
      NULL,
      NULL,
      0,
      1.678565,
      6.674536,
      0.281117,
      1.947904,
      0,
      0,
      NULL,
      2,
      5.007883,
      NULL,
      1.550492,
      0,
      4,
      2.095177,
      0,
      3,
      2,
      NULL,
      2,
      0,
      7,
      9.519275,
      1.872779,
      '10-28-1981',
      320.604931,
      ' 0-27-1996',
      1,
      2,
      1.142770,
      0.553902,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.457323,
      1.020986,
      1.903390,
      0,
      1.436930,
      1.727953,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703822,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.557552,
      1.671545,
      1,
      NULL,
      2.284912,
      2,
      NULL,
      4.341782,
      4.565038,
      1.257767,
      1,
      7.926441,
      1.226219,
      NULL,
      NULL,
      NULL,
      1.750491,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747835,
      1.446749,
      NULL,
      1,
      0.360583,
      1,
      1.926241,
      2.349778,
      21,
      3.083421,
      0.874208,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.769889,
      1.687941,
      1,
      2,
      2,
      3,
      2,
      0.062134,
      3.758928,
      0.627413,
      3,
      3.735218,
      NULL,
      8.651944,
      7.116085,
      1.365409,
      1.065544,
      2,
      1,
      NULL,
      1,
      NULL,
      1,
      0.251616,
      1.374934,
      0,
      NULL,
      0.336310,
      3,
      0.007271,
      2.739717,
      NULL,
      0,
      NULL,
      NULL,
      4,
      4.800511,
      NULL,
      NULL,
      2.644358,
      3.925959,
      2,
      6,
      NULL,
      NULL,
      NULL,
      51.616524,
      19.124378,
      20,
      0.317149,
      1.707732,
      3,
      '34412',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.114211,
      39,
      11,
      37.052876,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      0,
      1.508739,
      NULL,
      NULL,
      1.237955,
      NULL,
      0.927334,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.346029,
      3,
      3.826881,
      1.695035,
      1.511386,
      2,
      3,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.585175,
      0.524733,
      3.123551,
      0,
      3.951952,
      5.356370,
      6,
      1,
      0.105915,
      0.376582,
      NULL,
      NULL,
      NULL,
      1.026430,
      NULL,
      NULL,
      NULL,
      1.643044,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.115475,
      NULL,
      1.830542,
      0.238591,
      1.165287,
      1.698735,
      3.878345,
      2,
      1.764561,
      NULL,
      0.685436,
      NULL,
      1.132389,
      3.929715,
      0.456631,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      0.175285,
      1,
      NULL,
      NULL,
      3.573945,
      2.447355,
      0,
      6.396262,
      5,
      5.311593,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.622298,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.539915,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      0.433105,
      0.362237,
      1,
      2,
      0.615795,
      NULL,
      NULL,
      1.625993,
      0,
      NULL,
      0.108175,
      NULL,
      NULL,
      1.070442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401674,
      NULL,
      NULL,
      0.772860,
      NULL,
      NULL,
      0.973091,
      NULL,
      NULL,
      2,
      1.847434,
      3.865890,
      3.627194,
      1,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      2.807984,
      NULL,
      0.237859,
      NULL,
      NULL,
      1.353603,
      NULL,
      0.677086,
      1.714400,
      0,
      1.441217,
      3.063564,
      2,
      1,
      5.426782,
      4,
      0.622199,
      0.835270,
      1.013011,
      1,
      0,
      3.172302,
      NULL,
      3,
      0,
      1.253693,
      NULL,
      1,
      3.854861,
      NULL,
      6,
      5,
      3.104304,
      5,
      2.701472,
      NULL,
      0,
      1.903620,
      NULL,
      0.151774,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1.430961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749935,
      NULL,
      NULL,
      1.920353,
      NULL,
      NULL,
      1.555006,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.047036,
      NULL,
      NULL,
      3.623350,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.856352,
      NULL,
      NULL,
      1,
      1,
      0.177742,
      NULL,
      1.709540,
      3.548019,
      3,
      NULL,
      NULL,
      3.632900,
      0,
      NULL,
      NULL,
      1678,
      467.456146,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.866644,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.749557,
      NULL,
      NULL,
      NULL,
      3,
      1.613879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894768,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.123120,
      0.087023,
      NULL,
      NULL,
      0,
      0.490491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.376083,
      NULL,
      NULL,
      1,
      1.929679,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      1.468310,
      NULL,
      NULL,
      NULL,
      1,
      12,
      4.000507,
      2.479831,
      1.198074,
      1.135677,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.849412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      6423.875177,
      800,
      1,
      0,
      0.232949,
      0,
      1.897472,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0.417185,
      NULL,
      1,
      0.334106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.567951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.004125,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995185,
      NULL,
      1,
      NULL,
      1.681756,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.623188,
      0,
      NULL,
      1.669862,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.476904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.861258,
      3,
      8.989861,
      1.572897,
      4,
      2,
      4,
      5.161780,
      NULL,
      0.732648,
      0.365232,
      0.221057,
      0,
      NULL,
      1,
      NULL,
      2.775595,
      3.508058,
      2.703153,
      NULL,
      2.045821,
      0.037636,
      2,
      2.924534,
      NULL,
      2,
      1,
      NULL,
      0.179441,
      NULL,
      1.362853,
      3,
      0.141812,
      1,
      1,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1.147133,
      NULL,
      1.976052,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.933228,
      0,
      NULL,
      0.484710,
      NULL,
      2.563984,
      NULL,
      1,
      2,
      2.903383,
      1,
      3,
      0.184962,
      2.498862,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3.896064,
      1,
      2.592340,
      3,
      NULL,
      1.395009,
      NULL,
      124.139366,
      1.324472,
      NULL,
      0.536421,
      0,
      1.724277,
      1,
      NULL,
      0,
      0.107737,
      4,
      NULL,
      1.438830,
      NULL,
      NULL,
      113.473314,
      NULL,
      NULL,
      0,
      0.053664,
      '31004',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.385024,
      '',
      '',
      '');
commit;
end;
/


