set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8812738';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1042430',
      2.249911,
      1,
      3,
      1,
      '2014',
      0,
      0,
      NULL,
      NULL,
      NULL,
      6.494931,
      NULL,
      5,
      2,
      1.037674,
      ' 0- 4-1996',
      21.970835,
      2.284773,
      354,
      168,
      0.132148,
      NULL,
      NULL,
      ' 1-18-1992',
      0,
      NULL,
      2,
      0,
      0.946799,
      0,
      0,
      1,
      0.698262,
      38,
      5.535178,
      NULL,
      8,
      175.502471,
      NULL,
      16,
      23.684155,
      0.553842,
      1,
      7.279192,
      1.306866,
      0,
      3.503689,
      0,
      5,
      3,
      1,
      0.805620,
      NULL,
      1,
      NULL,
      0,
      0.041723,
      6,
      2,
      0.123535,
      0,
      1.642245,
      NULL,
      1,
      0.353891,
      1,
      0,
      NULL,
      0,
      1.455277,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.855138,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328170,
      0.433161,
      1,
      0.481931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571577,
      0,
      NULL,
      2.744116,
      0.821244,
      NULL,
      0,
      1.782027,
      1,
      0.196761,
      0,
      NULL,
      0,
      0.091124,
      0,
      0.532752,
      0,
      0,
      NULL,
      NULL,
      0.487152,
      1.807444,
      1.879699,
      NULL,
      1,
      NULL,
      9,
      1,
      0.638759,
      0,
      NULL,
      1,
      3.285085,
      4.173035,
      0,
      9,
      1,
      NULL,
      1,
      2.732106,
      1.539622,
      0.610343,
      3.807606,
      4,
      NULL,
      5.204437,
      2.693342,
      '10-15-1979',
      49,
      NULL,
      NULL,
      0,
      0,
      0.309328,
      1.257628,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.171580,
      0,
      NULL,
      1.504026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834512,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171739,
      1,
      NULL,
      0,
      1,
      1.626851,
      NULL,
      NULL,
      NULL,
      1.872452,
      0,
      0.466781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.808367,
      0,
      NULL,
      1,
      NULL,
      1,
      0.668655,
      NULL,
      2.933296,
      1.680759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      9.021619,
      4.061176,
      3,
      3,
      3.575073,
      3.734883,
      3,
      2,
      NULL,
      1.676275,
      NULL,
      NULL,
      3,
      1.835937,
      57,
      NULL,
      NULL,
      NULL,
      4.568983,
      0.229424,
      0,
      '00140',
      NULL,
      '',
      0.312235,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      30.785469,
      NULL,
      34,
      2.720577,
      NULL,
      8,
      3,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.518689,
      1.896918,
      0.727453,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.771729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.670278,
      NULL,
      1,
      0.971227,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.893409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999900,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.550497,
      1,
      NULL,
      0.565917,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      2.925890,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.692916,
      NULL,
      NULL,
      0.687096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.327824,
      NULL,
      NULL,
      0.594542,
      NULL,
      NULL,
      3.299129,
      3.821482,
      2,
      1.020383,
      NULL,
      NULL,
      3.596357,
      NULL,
      NULL,
      9.893990,
      0,
      NULL,
      6,
      0.309845,
      9,
      1,
      NULL,
      NULL,
      0,
      0.613452,
      NULL,
      NULL,
      1,
      3.163295,
      NULL,
      7.865757,
      4.889474,
      0,
      1.703043,
      NULL,
      3.802492,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      5,
      0,
      3,
      4.523283,
      2.540218,
      0.494525,
      2,
      8,
      1.503549,
      1,
      0.276739,
      1.804949,
      1.323122,
      2.119341,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.108142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.805920,
      NULL,
      NULL,
      0.054824,
      NULL,
      1.258809,
      NULL,
      0.310174,
      3,
      1.916295,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401820,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039791,
      NULL,
      NULL,
      NULL,
      3.534163,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.863105,
      NULL,
      NULL,
      NULL,
      0.135022,
      NULL,
      NULL,
      NULL,
      NULL,
      93.362765,
      7,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      140,
      1991.378271,
      NULL,
      NULL,
      0.498170,
      11446,
      NULL,
      0.384893,
      0,
      0.523730,
      0,
      NULL,
      0.491663,
      0.399869,
      1.729319,
      0,
      1,
      1,
      0,
      0,
      1.110334,
      0.012804,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.293625,
      NULL,
      2.963577,
      NULL,
      1.145800,
      18,
      NULL,
      15.376576,
      NULL,
      NULL,
      3.210624,
      14,
      NULL,
      9,
      6.854657,
      NULL,
      16.930245,
      10,
      NULL,
      17,
      18.128359,
      NULL,
      9.576788,
      15,
      NULL,
      9.117518,
      NULL,
      NULL,
      4,
      15,
      NULL,
      7.685688,
      11,
      NULL,
      0.148039,
      1.630767,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.341084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.078780,
      4.180567,
      2.504838,
      NULL,
      3,
      58.103383,
      20,
      7.322641,
      1.827977,
      2.861982,
      '04241',
      '',
      NULL,
      0.177298,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


