set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220693';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '40',
      6.938894,
      33.147582,
      '4024041',
      2.796053,
      0,
      3,
      NULL,
      '4124',
      2.423059,
      0,
      NULL,
      NULL,
      ' 3- 9-1990',
      45.119420,
      35,
      NULL,
      1,
      3.408911,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 4- 7-1991',
      ' 2- 6-1986',
      ' 0-26-1996',
      1,
      NULL,
      0,
      2,
      1,
      1.545083,
      4.110786,
      0.035173,
      0.389372,
      22,
      8,
      3.182004,
      0.573799,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082636,
      1.025473,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.415597,
      1,
      NULL,
      9.676805,
      1,
      1.763414,
      1,
      0.829172,
      1.328126,
      6,
      NULL,
      NULL,
      3,
      4,
      1,
      9.989156,
      0,
      1.257959,
      2,
      2.151316,
      0.459589,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      9,
      NULL,
      0,
      1.549249,
      NULL,
      1,
      3,
      2.124560,
      1.549599,
      1,
      0,
      3,
      NULL,
      0,
      1.391324,
      1,
      2,
      1,
      0.414793,
      1,
      2.129567,
      0,
      5.928484,
      2,
      0.983339,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.673102,
      9.580245,
      NULL,
      NULL,
      4.689153,
      0.644680,
      3,
      1.143389,
      NULL,
      1.518607,
      0,
      1,
      NULL,
      2.612224,
      0,
      0.021640,
      1,
      0.937048,
      1.468646,
      NULL,
      NULL,
      6.320462,
      0,
      0.150162,
      NULL,
      2,
      2.756922,
      4.213381,
      0.903272,
      NULL,
      2,
      2,
      1.670213,
      2.386625,
      1.726819,
      NULL,
      9.723133,
      9.186403,
      10,
      5.037977,
      4.039129,
      8.756660,
      6.017673,
      5,
      NULL,
      9.169039,
      3.688738,
      2,
      ' 6-18-1997',
      1684.731988,
      ' 8-26-1976',
      11.212185,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865463,
      0,
      NULL,
      0,
      0,
      3,
      2.388899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.649770,
      NULL,
      1,
      NULL,
      1,
      0.600378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031375,
      NULL,
      0,
      0.336237,
      0,
      7,
      NULL,
      NULL,
      4,
      2.662771,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.608541,
      2.226686,
      17.678175,
      0.188756,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.584710,
      2,
      NULL,
      3.205352,
      3.943573,
      1.371995,
      NULL,
      0,
      NULL,
      0,
      3.676956,
      NULL,
      3.961061,
      1,
      0.981673,
      1,
      NULL,
      3.074732,
      1,
      1.496495,
      0.965014,
      NULL,
      0.027366,
      NULL,
      1.974828,
      NULL,
      1,
      1,
      NULL,
      0.077828,
      9.360439,
      10,
      3,
      NULL,
      4,
      1,
      NULL,
      2.074599,
      5.917207,
      NULL,
      3.249297,
      1,
      52.825092,
      2.331717,
      NULL,
      NULL,
      NULL,
      NULL,
      0.358544,
      5.644912,
      2.714769,
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      24,
      384,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.142841,
      NULL,
      NULL,
      NULL,
      1.888950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.213169,
      NULL,
      NULL,
      0,
      1,
      1.940918,
      2.325035,
      NULL,
      1,
      0,
      NULL,
      1.158642,
      3.375164,
      0,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      0.562662,
      NULL,
      2.884909,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.920083,
      NULL,
      NULL,
      NULL,
      0,
      1.577002,
      1.434475,
      3.880018,
      0.654865,
      1,
      NULL,
      0.775697,
      NULL,
      3,
      1.099735,
      NULL,
      NULL,
      0,
      3.277524,
      3,
      1,
      1,
      2.016712,
      NULL,
      1,
      0,
      0.802077,
      1.924238,
      3.486522,
      NULL,
      NULL,
      NULL,
      1.393425,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.060172,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.163387,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      2.116695,
      NULL,
      2.847329,
      1.497766,
      1.583031,
      NULL,
      NULL,
      0.197407,
      3,
      0,
      NULL,
      0.673271,
      0.913627,
      NULL,
      NULL,
      NULL,
      2.728420,
      2.349254,
      2,
      1.792391,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.094594,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.202083,
      NULL,
      1,
      0.318821,
      0,
      0,
      3.342309,
      0.971476,
      NULL,
      4.051950,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      1.525463,
      0.110244,
      3,
      0,
      2,
      1,
      5.152124,
      NULL,
      3,
      1,
      2,
      2,
      1.911374,
      3.670581,
      1.763969,
      3.278253,
      3,
      0,
      1,
      3.069296,
      2,
      4.766177,
      4,
      2,
      0.032571,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.683252,
      0.814892,
      1,
      1.420950,
      1.060744,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.826707,
      0.565214,
      0.836236,
      1.195897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.362302,
      0,
      0.194421,
      1.838269,
      NULL,
      NULL,
      0.774256,
      NULL,
      NULL,
      1.201208,
      NULL,
      NULL,
      3,
      3,
      1.913652,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.071715,
      9.464953,
      6.670825,
      1.980565,
      NULL,
      0.291395,
      1,
      NULL,
      0.631712,
      1,
      0.614962,
      1.940976,
      3.350227,
      0,
      1.751624,
      0,
      0.343772,
      0,
      1,
      1.544286,
      2.778091,
      NULL,
      1.355545,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      48,
      NULL,
      NULL,
      38,
      67,
      0.558538,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.023850,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.523983,
      NULL,
      3.358500,
      NULL,
      NULL,
      NULL,
      2.538787,
      NULL,
      0.260132,
      NULL,
      0.051520,
      NULL,
      0.445712,
      NULL,
      NULL,
      NULL,
      0.332942,
      0.582626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.030336,
      3.126982,
      5,
      NULL,
      4.649940,
      3.493252,
      6,
      2.963208,
      0,
      0.558603,
      1,
      1,
      NULL,
      1,
      2,
      NULL,
      0.806402,
      3,
      NULL,
      1.464755,
      0.824654,
      NULL,
      1,
      3,
      NULL,
      2.913623,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1.145789,
      1,
      NULL,
      0,
      1.059808,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.644471,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      11,
      NULL,
      NULL,
      2.959372,
      29.192752,
      56,
      NULL,
      2.914695,
      4,
      '21440',
      '14244',
      '',
      1,
      '',
      NULL,
      '',
      1.794753,
      '',
      '',
      '');
commit;
end;
/


