set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8813900';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '0220241',
      2,
      1.182512,
      1,
      0,
      '2031',
      2.177320,
      2,
      NULL,
      12,
      '10-18-1986',
      33,
      NULL,
      0,
      NULL,
      0.213085,
      ' 9-15-1980',
      29.186196,
      2.666512,
      32,
      NULL,
      2,
      NULL,
      NULL,
      ' 4-16-1992',
      0,
      NULL,
      1.478741,
      0.993975,
      0,
      NULL,
      2.587336,
      1.985362,
      0,
      NULL,
      NULL,
      19,
      3.832443,
      17,
      11,
      NULL,
      NULL,
      3,
      NULL,
      6.542542,
      0.171187,
      1,
      1,
      0.997774,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      61.614219,
      4.105294,
      NULL,
      3.245014,
      3,
      NULL,
      NULL,
      0.439886,
      1.335458,
      2,
      NULL,
      2.914721,
      1,
      NULL,
      0.712212,
      NULL,
      NULL,
      9.768412,
      3,
      3.057165,
      3.720495,
      1.418282,
      1.056902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.200078,
      1,
      1.107317,
      1.098581,
      1.223215,
      NULL,
      NULL,
      0,
      0.992191,
      0.146369,
      0.672363,
      0.486337,
      2.035376,
      0,
      1.023080,
      0,
      NULL,
      NULL,
      0,
      1,
      6,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.086387,
      NULL,
      NULL,
      1.309824,
      NULL,
      NULL,
      0.658439,
      0.832302,
      1,
      NULL,
      0.440521,
      5.935079,
      1.129287,
      0,
      1,
      6.449380,
      9.838897,
      0,
      0,
      6,
      1.877947,
      0,
      NULL,
      1.693011,
      1.436431,
      NULL,
      0,
      0,
      1.780041,
      0,
      NULL,
      6,
      3.999145,
      1,
      0,
      NULL,
      1,
      1.824848,
      0,
      2.260690,
      NULL,
      1,
      7,
      NULL,
      0,
      0,
      0,
      NULL,
      3.671679,
      9,
      0,
      0.417478,
      3.055702,
      NULL,
      NULL,
      550,
      ' 1-16-2001',
      858.913450,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.930660,
      4,
      6,
      0,
      0,
      1.894439,
      0.170936,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940267,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676707,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.630113,
      0.189209,
      2.806165,
      3,
      NULL,
      2,
      NULL,
      1.166498,
      2,
      0.529326,
      1,
      5,
      5,
      0.615922,
      NULL,
      NULL,
      NULL,
      NULL,
      0.353804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.445771,
      1,
      1,
      1.504918,
      0,
      0.416916,
      1,
      0,
      254.102697,
      1,
      0.879965,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0.572698,
      5.843342,
      0.488911,
      0,
      2.198207,
      0.754601,
      NULL,
      2,
      5,
      0,
      5.710343,
      5.097565,
      2.405261,
      0,
      2,
      1.820295,
      1.284178,
      2,
      NULL,
      NULL,
      NULL,
      1.172956,
      NULL,
      0,
      0,
      1.968163,
      0,
      7,
      1,
      0.953394,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      55.159082,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      '21413',
      '',
      '',
      0.686370,
      '',
      NULL,
      '',
      1.511100,
      '',
      '',
      '',
      0.268401,
      NULL,
      102,
      NULL,
      3.160262,
      38,
      9,
      NULL,
      11.077020,
      NULL,
      2.980589,
      0.939060,
      1.084504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.334775,
      NULL,
      1.758551,
      0.857939,
      NULL,
      NULL,
      2.843023,
      1,
      1,
      0.525214,
      NULL,
      NULL,
      1.400537,
      NULL,
      NULL,
      3,
      2,
      3.850121,
      NULL,
      NULL,
      0.757274,
      0,
      NULL,
      NULL,
      3,
      7,
      2.891766,
      7.243807,
      1.768604,
      NULL,
      NULL,
      NULL,
      2.438710,
      0.231637,
      3.114393,
      3.890577,
      2,
      3,
      3.158045,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.567271,
      2.477403,
      0.068053,
      1.194322,
      1,
      NULL,
      2,
      1,
      3.427633,
      NULL,
      0,
      2.305217,
      NULL,
      0.177888,
      3.334663,
      0.376413,
      2,
      3,
      1,
      0,
      2.342170,
      1.331944,
      0.911284,
      NULL,
      0,
      1,
      6,
      10.272326,
      NULL,
      4.040041,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802524,
      NULL,
      0.182474,
      2.207336,
      NULL,
      NULL,
      NULL,
      2,
      1.804681,
      0.323453,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.880063,
      3,
      0,
      0,
      0,
      1,
      0.061934,
      9.329510,
      NULL,
      4.131714,
      0.228010,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.107906,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658293,
      NULL,
      NULL,
      4,
      0.192058,
      1,
      3.982240,
      1.277954,
      2,
      NULL,
      1,
      2.541011,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151929,
      NULL,
      NULL,
      0.784403,
      NULL,
      NULL,
      NULL,
      1.158049,
      3,
      8.546980,
      9.103765,
      1,
      4.881218,
      2,
      NULL,
      0,
      3.667806,
      2.915729,
      0,
      0,
      1.670657,
      NULL,
      1.341761,
      3.812378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969456,
      NULL,
      NULL,
      2.690351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.599210,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.973601,
      3,
      NULL,
      0.788679,
      3.439202,
      NULL,
      NULL,
      NULL,
      5,
      5.977683,
      NULL,
      NULL,
      1207,
      NULL,
      NULL,
      NULL,
      2.082842,
      NULL,
      NULL,
      NULL,
      0.245180,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.684374,
      3,
      NULL,
      NULL,
      3.541073,
      0.289192,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.200059,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      2.577594,
      NULL,
      NULL,
      1.798048,
      1,
      NULL,
      NULL,
      1,
      1.745084,
      NULL,
      NULL,
      0,
      1.294370,
      NULL,
      NULL,
      1.307413,
      0.431957,
      NULL,
      NULL,
      3.852636,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1,
      3.340042,
      0.447002,
      NULL,
      NULL,
      2,
      33.031196,
      585.813285,
      0.253402,
      NULL,
      1915.817129,
      0.127333,
      NULL,
      NULL,
      1,
      1851.103105,
      NULL,
      NULL,
      154,
      205,
      0.797821,
      1863,
      NULL,
      0,
      12.535703,
      0.239716,
      3295.026669,
      318,
      0.084575,
      NULL,
      0.882557,
      2,
      0.581486,
      1,
      0,
      0.137877,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.613153,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.552012,
      NULL,
      3.448964,
      NULL,
      1,
      NULL,
      3,
      NULL,
      115,
      NULL,
      2.346451,
      11,
      47.818750,
      3.695019,
      1,
      1.559038,
      NULL,
      2,
      NULL,
      2.410862,
      NULL,
      3.205468,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.842575,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.257823,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238949,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.092006,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938531,
      NULL,
      NULL,
      NULL,
      2,
      1.490669,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.617564,
      11.566808,
      0.798613,
      3.412612,
      1.024677,
      1.309234,
      6.291946,
      5,
      NULL,
      5.728436,
      5.650922,
      2,
      2.588621,
      2,
      0.708655,
      8,
      NULL,
      1.508717,
      1,
      0,
      0,
      NULL,
      0,
      0.912851,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893627,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3.409842,
      NULL,
      1,
      3.962120,
      NULL,
      3.590133,
      3,
      NULL,
      0.506027,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.162412,
      NULL,
      1,
      0.573703,
      3,
      1,
      NULL,
      1.666051,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.946634,
      NULL,
      3,
      NULL,
      1.538560,
      NULL,
      0.568504,
      NULL,
      2,
      NULL,
      3,
      NULL,
      2.913861,
      NULL,
      2,
      NULL,
      114.058290,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      9.993579,
      2.343941,
      4,
      3,
      NULL,
      2.597600,
      NULL,
      73,
      5,
      1,
      2,
      '20044',
      NULL,
      '32442',
      1,
      '',
      '',
      '',
      1.109448,
      '',
      NULL,
      '');
commit;
end;
/


