set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7700718';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3421202',
      NULL,
      0,
      5,
      0,
      '1404',
      1.357473,
      1,
      NULL,
      NULL,
      '11- 2-1992',
      NULL,
      NULL,
      1,
      2.950909,
      NULL,
      NULL,
      23.816793,
      NULL,
      106.315967,
      91,
      NULL,
      NULL,
      ' 1- 2-1985',
      ' 7-11-2002',
      2,
      0.827564,
      1,
      0,
      NULL,
      1.087232,
      3,
      1,
      0.939461,
      6,
      4,
      2,
      4,
      33.603624,
      21,
      2,
      NULL,
      0,
      NULL,
      1.518858,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.469715,
      0,
      0.995545,
      5,
      1,
      0,
      0,
      1,
      0,
      0.091762,
      NULL,
      0,
      6.922597,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.665488,
      0,
      0.220708,
      0,
      1,
      NULL,
      NULL,
      0.423472,
      NULL,
      NULL,
      1.478678,
      0.823045,
      1.411296,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438362,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451292,
      4,
      NULL,
      2,
      2,
      5.510865,
      3,
      NULL,
      7,
      0,
      0.111955,
      3.955441,
      0,
      NULL,
      1,
      0,
      1.943155,
      1,
      0.250629,
      NULL,
      0.562544,
      4,
      1.165325,
      NULL,
      2,
      NULL,
      NULL,
      1.875283,
      2,
      5,
      4,
      NULL,
      5.764571,
      NULL,
      NULL,
      3,
      7.043560,
      4,
      1.318626,
      3,
      3,
      NULL,
      NULL,
      4,
      1,
      9,
      2,
      3.551498,
      '10-16-1975',
      NULL,
      ' 8-29-1999',
      23,
      1.029261,
      1,
      NULL,
      5.635410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920951,
      2,
      1,
      4.209939,
      0.145994,
      1.522023,
      1.228337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.445085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.730201,
      0,
      0.366011,
      1,
      3,
      0.801207,
      4.532806,
      5.952898,
      3,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.847400,
      5.776808,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      0,
      0.822674,
      2.591878,
      NULL,
      0,
      1.655759,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051006,
      0.646843,
      1.616665,
      1.944281,
      5,
      2.592048,
      0.031828,
      3,
      3.843449,
      NULL,
      5,
      2.598871,
      NULL,
      NULL,
      1,
      NULL,
      0.489942,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0.655465,
      1.862060,
      1,
      1.307227,
      0.607797,
      0.127847,
      NULL,
      NULL,
      5,
      2,
      4,
      6.200942,
      3.603410,
      3.943595,
      0,
      3,
      0,
      0,
      38,
      0,
      2,
      NULL,
      21.266269,
      18.827706,
      6,
      3.600063,
      1,
      2.799311,
      '22301',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1.274248,
      20.425706,
      NULL,
      5,
      0.368830,
      26.336972,
      NULL,
      1.349971,
      4.209673,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.906676,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.726026,
      0.606789,
      1.652580,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.777374,
      NULL,
      NULL,
      1.168858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.743802,
      1.993542,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.688034,
      NULL,
      NULL,
      0,
      0,
      0.361136,
      0.583918,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709029,
      NULL,
      NULL,
      NULL,
      1.720463,
      NULL,
      NULL,
      2.500808,
      2,
      1,
      NULL,
      2,
      1.488503,
      1.246967,
      NULL,
      NULL,
      2.441547,
      2,
      0,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      5.465195,
      2,
      1,
      1.701772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.312731,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.981420,
      6.220875,
      7.404186,
      0,
      0.133063,
      NULL,
      NULL,
      0.463447,
      NULL,
      NULL,
      1.130122,
      NULL,
      NULL,
      1.801029,
      NULL,
      NULL,
      1.612042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.373725,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.648847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.404011,
      7,
      0,
      1,
      1.747175,
      NULL,
      1,
      1.443976,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.996426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.908185,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.478973,
      1.567219,
      1,
      0.274159,
      0,
      3.793325,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467410,
      1.393615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.164359,
      0.612243,
      NULL,
      NULL,
      3.035037,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.086347,
      0,
      NULL,
      NULL,
      1.533797,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.469370,
      1,
      NULL,
      NULL,
      NULL,
      1.704208,
      NULL,
      NULL,
      3,
      0.663951,
      NULL,
      NULL,
      1.703357,
      0.395349,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.970651,
      NULL,
      1,
      0.569680,
      NULL,
      NULL,
      0.731042,
      NULL,
      NULL,
      1.095188,
      NULL,
      NULL,
      0,
      0.628481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      87,
      0,
      0,
      0,
      NULL,
      0,
      0.134062,
      NULL,
      1.766532,
      0.656769,
      1.034207,
      NULL,
      1.960172,
      NULL,
      1.977943,
      0.795899,
      0,
      1.376824,
      1,
      0.833386,
      NULL,
      1.327546,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.132530,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.868858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9,
      1.588396,
      3.221683,
      3,
      NULL,
      6,
      2,
      0.772387,
      1,
      NULL,
      1.714788,
      0.860063,
      0,
      1,
      1.989330,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.892979,
      0,
      1.606593,
      NULL,
      0,
      1,
      0,
      0,
      1.115389,
      NULL,
      NULL,
      0,
      1.516583,
      0.296442,
      0.091236,
      3.131970,
      1.139318,
      0.760921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078429,
      NULL,
      0,
      NULL,
      NULL,
      3,
      4,
      1.623989,
      1.175361,
      NULL,
      NULL,
      75,
      62,
      NULL,
      0,
      2.405306,
      '42431',
      '00433',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


